/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.makeproject.MakeProjectHelperImpl;
import org.netbeans.modules.cnd.makeproject.MakeProjectTypeImpl;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectHelper;
import org.netbeans.spi.project.ProjectFactory2;
import org.netbeans.spi.project.ProjectState;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class MakeBasedProjectFactorySingleton
implements ProjectFactory2 {
    public static final String PROJECT_XML_PATH = "nbproject/project.xml";
    public static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    public static final Logger LOG = Logger.getLogger(MakeBasedProjectFactorySingleton.class.getName());
    public static final MakeProjectTypeImpl TYPE_INSTANCE = new MakeProjectTypeImpl();
    private static final Map<Project, Reference<MakeProjectHelperImpl>> project2Helper = new WeakHashMap<Project, Reference<MakeProjectHelperImpl>>();
    private static final Map<MakeProjectHelperImpl, Reference<Project>> helper2Project = new WeakHashMap<MakeProjectHelperImpl, Reference<Project>>();

    private static MakeProjectTypeImpl findMakeProjectType(String type) {
        if ("org.netbeans.modules.cnd.makeproject".equals(type)) {
            return TYPE_INSTANCE;
        }
        return null;
    }

    public boolean isProject(FileObject dir) {
        FileObject projectFile = dir.getFileObject(PROJECT_XML_PATH);
        return projectFile != null && projectFile.isValid() && projectFile.isData();
    }

    public ProjectManager.Result isProject2(FileObject projectDirectory) {
        FileObject projectFile = projectDirectory.getFileObject(PROJECT_XML_PATH);
        if (projectFile == null || !projectFile.isData() || projectFile.isVirtual()) {
            return null;
        }
        try {
            MakeProjectTypeImpl provider;
            String type;
            Element typeEl;
            Document projectXml = this.loadProjectXml(projectFile);
            if (projectXml != null && (typeEl = XMLUtil.findElement((Element)projectXml.getDocumentElement(), (String)"type", (String)PROJECT_NS)) != null && (type = XMLUtil.findText((Node)typeEl)) != null && (provider = MakeBasedProjectFactorySingleton.findMakeProjectType(type)) != null) {
                return new ProjectManager.Result(provider.getIcon(projectXml.getDocumentElement()));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(MakeProjectTypeImpl.class.getName()).log(Level.FINE, "Failed to load the project.xml file.", ex);
        }
        return new ProjectManager.Result(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Project loadProject(FileObject projectDirectory, ProjectState state) throws IOException {
        FileObject projectFile = projectDirectory.getFileObject(PROJECT_XML_PATH);
        if (projectFile == null) {
            LOG.log(Level.FINE, "not found data file {0}/nbproject/project.xml", projectDirectory.getPath());
            return null;
        }
        if (!projectFile.isData()) {
            LOG.log(Level.FINE, "not found plain file {0}/nbproject/project.xml", projectDirectory.getPath());
            return null;
        }
        if (projectFile.isVirtual()) {
            LOG.log(Level.FINE, "not concrete data file {0}/nbproject/project.xml", projectDirectory.getPath());
            return null;
        }
        Document projectXml = this.loadProjectXml(projectFile);
        if (projectXml == null) {
            LOG.log(Level.FINE, "could not load {0}", projectFile);
            return null;
        }
        Element typeEl = XMLUtil.findElement((Element)projectXml.getDocumentElement(), (String)"type", (String)PROJECT_NS);
        if (typeEl == null) {
            LOG.log(Level.FINE, "no <type> in {0}", projectFile);
            return null;
        }
        String type = XMLUtil.findText((Node)typeEl);
        if (type == null) {
            LOG.log(Level.FINE, "no <type> text in {0}", projectFile);
            return null;
        }
        MakeProjectTypeImpl provider = MakeBasedProjectFactorySingleton.findMakeProjectType(type);
        if (provider == null) {
            LOG.log(Level.FINE, "no provider for {0}", type);
            return null;
        }
        MakeProjectHelperImpl helper = MakeProjectHelperImpl.create(projectDirectory, projectXml, state, provider);
        Project project = provider.createProject(helper);
        project2Helper.put(project, new WeakReference<MakeProjectHelperImpl>(helper));
        Map<MakeProjectHelperImpl, Reference<Project>> map = helper2Project;
        synchronized (map) {
            helper2Project.put(helper, new WeakReference<Project>(project));
        }
        return project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document loadProjectXml(FileObject projectDiskFile) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream is = projectDiskFile.getInputStream();){
            FileUtil.copy((InputStream)is, (OutputStream)baos);
        }
        byte[] data = baos.toByteArray();
        InputSource src = new InputSource(new ByteArrayInputStream(data));
        try {
            DocumentBuilder builder;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException x) {
                throw new SAXException(x);
            }
            builder.setErrorHandler(XMLUtil.defaultErrorHandler());
            Document projectXml = builder.parse(src);
            LOG.fine("parsed document");
            Element projectEl = projectXml.getDocumentElement();
            LOG.fine("got document element");
            String namespace = projectEl.getNamespaceURI();
            LOG.log(Level.FINE, "got namespace {0}", namespace);
            if (!PROJECT_NS.equals(namespace)) {
                LOG.log(Level.FINE, "{0} had wrong root element namespace {1} when parsed from {2}", new Object[]{projectDiskFile, namespace, baos});
                return null;
            }
            if (!"project".equals(projectEl.getLocalName())) {
                LOG.log(Level.FINE, "{0} had wrong root element name {1} when parsed from {2}", new Object[]{projectDiskFile, projectEl.getLocalName(), baos});
                return null;
            }
            return projectXml;
        }
        catch (SAXException e) {
            IOException ioe = new IOException(projectDiskFile + ": " + e, e);
            throw ioe;
        }
    }

    public void saveProject(Project project) throws IOException, ClassCastException {
        Reference<MakeProjectHelperImpl> helperRef = project2Helper.get(project);
        if (helperRef == null) {
            StringBuilder sBuff = new StringBuilder("#191029: no project helper for a ");
            sBuff.append(project.getClass().getName()).append('\n');
            sBuff.append("argument project: ").append(project).append(" => ").append(project.hashCode()).append('\n');
            sBuff.append("project2Helper keys: \n");
            project2Helper.keySet().forEach(prj -> sBuff.append("    project: ").append(prj).append(" => ").append(prj.hashCode()).append('\n'));
            LOG.warning(sBuff.toString());
            return;
        }
        MakeProjectHelperImpl helper = helperRef.get();
        assert (helper != null) : "MakeProjectHelper collected for " + project;
        helper.save();
    }

    public static MakeProjectHelperImpl getHelperFor(Project p) {
        Reference<MakeProjectHelperImpl> helperRef = project2Helper.get(p);
        return helperRef != null ? helperRef.get() : null;
    }

    public static Project getProjectFor(MakeProjectHelper helper) {
        Reference<Project> ref = helper2Project.get(helper);
        if (ref != null) {
            return ref.get();
        }
        return null;
    }
}

