/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.netbeans.modules.cnd.makeproject.NativeProjectRelocationMapperProviderImpl;
import org.netbeans.modules.cnd.makeproject.spi.ProjectMetadataFactory;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class PathMapperProjectMetadataFactory
implements ProjectMetadataFactory {
    public static final String NAME = "path_mapper.properties";

    @Override
    public void read(FileObject projectDir) {
        FileObject nbproject = projectDir.getFileObject("nbproject");
        if (nbproject != null && nbproject.isValid()) {
            FileChangeListenerImpl fileChangeListener = new FileChangeListenerImpl(projectDir);
            nbproject.addFileChangeListener((FileChangeListener)fileChangeListener);
            this.initListeners(fileChangeListener, projectDir);
            PathMapperProjectMetadataFactory.reload(projectDir);
        }
    }

    private void initListeners(FileChangeListener fileChangeListener, FileObject projectDir) {
        FileObject nbproject = projectDir.getFileObject("nbproject");
        if (nbproject != null && nbproject.isValid()) {
            FileObject privateNbFolder;
            FileObject publicPathMapper = nbproject.getFileObject(NAME);
            if (publicPathMapper != null) {
                publicPathMapper.removeFileChangeListener(fileChangeListener);
                publicPathMapper.addFileChangeListener(fileChangeListener);
            }
            if ((privateNbFolder = projectDir.getFileObject("nbproject/private")) != null && privateNbFolder.isValid()) {
                privateNbFolder.removeFileChangeListener(fileChangeListener);
                privateNbFolder.addFileChangeListener(fileChangeListener);
                FileObject privatePathMapper = privateNbFolder.getFileObject(NAME);
                if (privatePathMapper != null) {
                    privatePathMapper.removeFileChangeListener(fileChangeListener);
                    privatePathMapper.addFileChangeListener(fileChangeListener);
                }
            }
        }
    }

    @Override
    public void write(FileObject projectDir) {
    }

    private static void reload(FileObject projectDir) {
        NativeProjectRelocationMapperProviderImpl.ProjectMapper projectMapper = NativeProjectRelocationMapperProviderImpl.get(projectDir);
        Properties properties = new Properties();
        FileObject nbProjectFolder = projectDir.getFileObject("nbproject");
        if (nbProjectFolder == null) {
            return;
        }
        FileObject publicMappers = nbProjectFolder.getFileObject(NAME);
        FileObject privateNbFolder = projectDir.getFileObject("nbproject/private");
        FileObject privateMappers = null;
        if (privateNbFolder != null && privateNbFolder.isValid()) {
            privateMappers = privateNbFolder.getFileObject(NAME);
        }
        try {
            InputStream inputStream;
            if (publicMappers != null && publicMappers.isValid()) {
                inputStream = publicMappers.getInputStream();
                properties.load(inputStream);
                inputStream.close();
            }
            if (privateMappers != null && privateMappers.isValid()) {
                inputStream = privateMappers.getInputStream();
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        projectMapper.load(properties, projectDir);
    }

    private class FileChangeListenerImpl
    implements FileChangeListener {
        private final FileObject projectDir;

        public FileChangeListenerImpl(FileObject projectDir) {
            this.projectDir = projectDir;
        }

        public void fileFolderCreated(FileEvent fe) {
            PathMapperProjectMetadataFactory.this.initListeners(this, this.projectDir);
        }

        public void fileDataCreated(FileEvent fe) {
            PathMapperProjectMetadataFactory.this.initListeners(this, this.projectDir);
            PathMapperProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileChanged(FileEvent fe) {
            PathMapperProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileDeleted(FileEvent fe) {
            fe.getFile().removeFileChangeListener((FileChangeListener)this);
            PathMapperProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileRenamed(FileRenameEvent fe) {
            PathMapperProjectMetadataFactory.reload(this.projectDir);
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

