/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectChangeSupport;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.api.ProjectSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DebuggerChooserConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeLogicalViewModel;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.cnd.makeproject.uiapi.CancellableProgressHandleFactory;
import org.netbeans.modules.cnd.makeproject.uiapi.ConfirmSupport;
import org.netbeans.modules.cnd.makeproject.uiapi.EventsProcessorActions;
import org.netbeans.modules.cnd.spi.utils.CndNotifier;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.execution.IOTabsController;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.project.ActionProgress;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;

public class ProjectActionSupport {
    private static ProjectActionSupport instance;
    private static final RequestProcessor RP;
    private static final RequestProcessor tasksProcessor;
    private static final Logger LOGGER;
    private final List<ProjectActionHandlerFactory> handlerFactories = new ArrayList<ProjectActionHandlerFactory>(Lookup.getDefault().lookupAll(ProjectActionHandlerFactory.class));

    private ProjectActionSupport() {
    }

    public static synchronized ProjectActionSupport getInstance() {
        if (instance == null) {
            instance = new ProjectActionSupport();
        }
        return instance;
    }

    private static boolean isFileOperationsIntensive(ProjectActionEvent pae) {
        ProjectActionEvent.Type type = pae.getType();
        return type == ProjectActionEvent.PredefinedType.PRE_BUILD || type == ProjectActionEvent.PredefinedType.BUILD || type == ProjectActionEvent.PredefinedType.CLEAN || type == ProjectActionEvent.PredefinedType.BUILD_TESTS;
    }

    private static void refreshProjectFilesOnFinish(ProjectActionEvent curPAE, FileOperationsNotifier fon) {
        try {
            SourceGroup[] groups;
            if (curPAE.getType() != ProjectActionEvent.PredefinedType.RUN && !fon.isLastExpectedEvent(curPAE)) {
                return;
            }
            Project project = curPAE.getProject();
            HashSet<File> files = new HashSet<File>();
            HashSet<FileObject> fileObjects = new HashSet<FileObject>();
            FileObject projectFileObject = project.getProjectDirectory();
            File f = FileUtil.toFile((FileObject)projectFileObject);
            if (f != null) {
                files.add(f);
            } else {
                fileObjects.add(projectFileObject);
            }
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : groups = sources.getSourceGroups("generic")) {
                FileObject rootFolder = sourceGroup.getRootFolder();
                File file = FileUtil.toFile((FileObject)rootFolder);
                if (file != null) {
                    files.add(file);
                    continue;
                }
                fileObjects.add(rootFolder);
            }
            Runnable refresher = () -> {
                File[] array = files.toArray(new File[files.size()]);
                if (array.length > 0) {
                    FileUtil.refreshFor((File[])array);
                }
                if (!fileObjects.isEmpty()) {
                    fileObjects.forEach(fo -> FileSystemProvider.scheduleRefresh((FileObject)fo));
                }
            };
            RP.post(() -> {
                FileUtil.runAtomicAction((Runnable)refresher);
                fon.onFinish(curPAE);
                MakeLogicalViewModel viewModel = (MakeLogicalViewModel)project.getLookup().lookup(MakeLogicalViewModel.class);
                if (viewModel != null) {
                    viewModel.refreshBrokenItems();
                }
            });
            ConfigurationDescriptorProvider.SnapShot snapShot = (ConfigurationDescriptorProvider.SnapShot)curPAE.getContext().lookup(ConfigurationDescriptorProvider.SnapShot.class);
            if (snapShot != null) {
                ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                cdp.endModifications(snapShot, true, LOGGER);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "Cannot refresh project files", e);
        }
    }

    public boolean canHandle(MakeConfiguration conf, Lookup context, ProjectActionEvent.Type type) {
        DebuggerChooserConfiguration chooser;
        ProjectActionHandlerFactory node;
        if (conf != null && (node = (chooser = conf.getDebuggerChooserConfiguration()).getNode()) != null && node.canHandle(type, context, conf)) {
            return true;
        }
        for (ProjectActionHandlerFactory factory : this.handlerFactories) {
            if (!factory.canHandle(type, context, conf)) continue;
            return true;
        }
        return false;
    }

    public void fireActionPerformed(ProjectActionEvent[] paes) {
        this.fireActionPerformed(paes, null);
    }

    public void fireActionPerformed(ProjectActionEvent[] paes, ProjectActionHandler preferredHandler) {
        this.fireActionPerformed(paes, null, null);
    }

    public void fireActionPerformed(ProjectActionEvent[] paes, ProjectActionHandler preferredHandler, ActionProgress actionProgress) {
        ProjectActionSupport.submitTask(new EventsProcessorImpl(paes, preferredHandler, actionProgress));
    }

    private static void submitTask(EventsProcessorImpl eventsProcessor) {
        tasksProcessor.post((Runnable)eventsProcessor);
    }

    private static boolean checkProject(ProjectActionEvent pae) {
        FileObject projectDirectory;
        Project project = pae.getProject();
        if (project != null && (CndUtils.isUnitTestMode() || OpenProjects.getDefault().isProjectOpen(project)) && (projectDirectory = project.getProjectDirectory()) != null) {
            FileObject nbproject = projectDirectory.getFileObject("nbproject");
            return nbproject != null && nbproject.isValid();
        }
        return pae.getType() == ProjectActionEvent.PredefinedType.ATTACH;
    }

    private static String getString(String s, String ... arg) {
        return NbBundle.getMessage(ProjectActionSupport.class, (String)s, (Object[])arg);
    }

    static {
        RP = new RequestProcessor("ProjectActionSupport.refresh", 1);
        tasksProcessor = new RequestProcessor("ProjectActionSupport.tasks", 50);
        LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    }

    private final class EventsProcessorImpl
    implements Runnable,
    BuildActionsProvider.EventsProcessor {
        private final IOTabsController.TabsGroup tabs;
        private final ProjectActionEvent[] paes;
        private final ProjectActionHandler customHandler;
        private final FileOperationsNotifier fon;
        private final EventsProcessorActions epa;
        private final ActionProgress actionProgress;
        private final String[] FILE_LOCATIONS = new String[]{"/usr/bin", "/usr/sbin", "/bin"};

        public EventsProcessorImpl(ProjectActionEvent[] paes, ProjectActionHandler customHandler, ActionProgress actionProgress) {
            this.paes = paes;
            this.customHandler = customHandler;
            this.epa = EventsProcessorActions.getEventsProcessorActionsFactory().getEventsProcessorActions(this);
            this.fon = this.getFileOperationsNotifier(paes);
            this.tabs = IOTabsController.getDefault().openTabsGroup(this.getTabName(paes), MakeOptions.getInstance().getReuse());
            this.actionProgress = actionProgress;
        }

        @Override
        public void submitTask() {
            tasksProcessor.post((Runnable)this);
        }

        @Override
        public ProjectActionEvent[] getProjectActionEvents() {
            return this.paes;
        }

        @Override
        public boolean checkProject(ProjectActionEvent pae) {
            return ProjectActionSupport.checkProject(pae);
        }

        private String getTabName(ProjectActionEvent[] paes) {
            MakeConfiguration conf;
            String projectName = paes[0].getProject() == null ? NbBundle.getMessage(ProjectActionSupport.class, (String)"NO_PROJECT") : ProjectUtils.getInformation((Project)paes[0].getProject()).getDisplayName();
            StringBuilder name = new StringBuilder(projectName);
            name.append(" (");
            int counter = 0;
            boolean skipDebug = paes.length > 1;
            for (int i = 0; i < paes.length; ++i) {
                boolean isDebugAction;
                if (counter >= 2) {
                    name.append("...");
                    break;
                }
                ProjectActionEvent.Type type = paes[i].getType();
                boolean bl = isDebugAction = type == ProjectActionEvent.PredefinedType.DEBUG || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO || type == ProjectActionEvent.PredefinedType.DEBUG_TEST || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO_TEST;
                if (skipDebug && isDebugAction) continue;
                if (counter > 0) {
                    name.append(", ");
                }
                ++counter;
                name.append(paes[i].getActionName());
            }
            name.append(")");
            if (paes.length > 0 && !(conf = paes[0].getConfiguration()).getDevelopmentHost().isLocalhost()) {
                String hkey = conf.getDevelopmentHost().getHostKey();
                name.append(" - ").append(hkey);
            }
            return name.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.tabs.lockAndReset();
            LifecycleManager.getDefault().saveAll();
            this.epa.setEnableRerunAction(false);
            this.epa.setEnableRerunModAction(false);
            this.epa.setEnableStopAction(false);
            final AtomicInteger currentEventIndex = new AtomicInteger(-1);
            AtomicReference<Object> currentIORef = new AtomicReference<Object>(null);
            final AtomicBoolean result = new AtomicBoolean(true);
            try {
                for (final ProjectActionEvent currentEvent : this.paes) {
                    IOTabsController.IOTabFactory tabFactory;
                    String tabBaseName;
                    boolean isRunAction;
                    currentEventIndex.incrementAndGet();
                    if (!ProjectActionSupport.checkProject(currentEvent)) {
                        result.set(false);
                        return;
                    }
                    ProjectActionEvent.Type type = currentEvent.getType();
                    boolean isDebugAction = type == ProjectActionEvent.PredefinedType.DEBUG || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO || type == ProjectActionEvent.PredefinedType.DEBUG_TEST || type == ProjectActionEvent.PredefinedType.DEBUG_STEPINTO_TEST || type == ProjectActionEvent.PredefinedType.ATTACH;
                    boolean bl = isRunAction = type == ProjectActionEvent.PredefinedType.RUN || isDebugAction || type == ProjectActionEvent.PredefinedType.CUSTOM_ACTION;
                    if ((isRunAction || type == ProjectActionEvent.PredefinedType.CHECK_EXECUTABLE) && !this.checkExecutable(currentEvent)) {
                        result.set(false);
                        return;
                    }
                    int consoleType = currentEvent.getProfile().getConsoleType().getValue();
                    if (consoleType == 1 && !currentEvent.getConfiguration().getDevelopmentHost().isLocalhost()) {
                        consoleType = 0;
                    }
                    if (consoleType == 0) {
                        consoleType = RunProfile.getDefaultConsoleType();
                    }
                    if (isRunAction && consoleType == 3) {
                        tabBaseName = this.getTabName(new ProjectActionEvent[]{currentEvent});
                        tabFactory = tabName -> {
                            IOProvider ioProvider = IOProvider.get((String)"Terminal");
                            if (ioProvider == null) {
                                ioProvider = IOProvider.getDefault();
                            }
                            return ioProvider.getIO(tabName, this.epa.getActions(currentEvent.getActionName()));
                        };
                    } else if (isDebugAction) {
                        tabBaseName = this.getTabName(new ProjectActionEvent[]{currentEvent});
                        tabFactory = tabName -> IOProvider.getDefault().getIO(tabName, this.epa.getActions(currentEvent.getActionName()));
                    } else {
                        tabBaseName = this.getTabName(this.paes);
                        tabFactory = tabName -> IOProvider.getDefault().getIO(tabName, this.epa.getActions(currentEvent.getActionName()));
                    }
                    IOTabsController.InputOutputTab ioTab = this.tabs.getTab(tabBaseName, tabFactory);
                    IOTabsController.InputOutputTab prevIO = currentIORef.getAndSet(ioTab);
                    if (prevIO != null && prevIO != ioTab) {
                        prevIO.closeOutput();
                    }
                    ProjectActionHandler handlerToUse = null;
                    if (type == ProjectActionEvent.PredefinedType.CUSTOM_ACTION && this.customHandler != null) {
                        handlerToUse = this.customHandler;
                    } else {
                        for (ProjectActionHandlerFactory factory : ProjectActionSupport.this.handlerFactories) {
                            if (!factory.canHandle(currentEvent)) continue;
                            handlerToUse = factory.createHandler();
                            break;
                        }
                    }
                    if (handlerToUse == null) {
                        break;
                    }
                    final CountDownLatch eventProcessed = new CountDownLatch(1);
                    final AtomicBoolean stepFailed = new AtomicBoolean(true);
                    ExecutionListener eventExecutionListener = new ExecutionListener(){

                        public void executionStarted(int pid) {
                            try {
                                ProjectActionHandler handler = EventsProcessorImpl.this.epa.getActiveHandler();
                                EventsProcessorImpl.this.epa.setEnableStopAction(handler != null && handler.canCancel());
                                if (EventsProcessorImpl.this.epa.getAdditional() != null) {
                                    EventsProcessorImpl.this.epa.getAdditional().forEach(action -> {
                                        try {
                                            action.setStep(currentEventIndex.get());
                                            action.executionStarted(pid);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    });
                                }
                            }
                            finally {
                                EventsProcessorImpl.this.fon.onStart(currentEvent);
                            }
                        }

                        public void executionFinished(int rc) {
                            try {
                                EventsProcessorImpl.this.epa.setEnableStopAction(false);
                                stepFailed.set(rc != 0);
                                result.set(rc == 0);
                                if (EventsProcessorImpl.this.epa.getAdditional() != null) {
                                    EventsProcessorImpl.this.epa.getAdditional().forEach(action -> {
                                        try {
                                            action.executionFinished(rc);
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                    });
                                }
                            }
                            finally {
                                eventProcessed.countDown();
                            }
                        }
                    };
                    ProgressHandle progressHandle = null;
                    try {
                        this.initHandler(handlerToUse, currentEvent, this.paes);
                        this.epa.setActiveHandler(handlerToUse);
                        handlerToUse.addExecutionListener(eventExecutionListener);
                        progressHandle = CancellableProgressHandleFactory.getProgressHandleFactory().createProgressHandle(ioTab, handlerToUse, this.epa);
                        progressHandle.start();
                        handlerToUse.execute(IOTabsController.getInputOutput((IOTabsController.InputOutputTab)ioTab));
                        try {
                            eventProcessed.await();
                        }
                        catch (InterruptedException ex) {
                            Thread.interrupted();
                            handlerToUse.removeExecutionListener(eventExecutionListener);
                            this.epa.setActiveHandler(null);
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            this.epa.setEnableStopAction(false);
                            break;
                        }
                        ProjectActionSupport.refreshProjectFilesOnFinish(currentEvent, this.fon);
                        if (!stepFailed.get()) continue;
                        break;
                    }
                    finally {
                        handlerToUse.removeExecutionListener(eventExecutionListener);
                        this.epa.setActiveHandler(null);
                        if (progressHandle != null) {
                            progressHandle.finish();
                        }
                        this.epa.setEnableStopAction(false);
                    }
                }
            }
            catch (IllegalStateException ex) {
                ex.printStackTrace();
            }
            finally {
                this.tabs.unlockAndCloseOutput();
                this.epa.setEnableRerunAction(true);
                this.epa.setEnableRerunModAction(true);
                this.epa.setEnableStopAction(false);
                this.fon.finishAll();
                if (this.actionProgress != null) {
                    this.actionProgress.finished(result.get());
                }
            }
        }

        private void initHandler(ProjectActionHandler handler, ProjectActionEvent pae, ProjectActionEvent[] paes) {
            if (this.epa.getAdditional() == null) {
                this.epa.setAdditional(pae.getActionName());
            }
            ArrayList<BuildActionsProvider.OutputStreamHandler> streamHandlers = new ArrayList<BuildActionsProvider.OutputStreamHandler>();
            for (BuildActionsProvider.BuildAction action : this.epa.getAdditional()) {
                if (!(action instanceof BuildActionsProvider.OutputStreamHandler)) continue;
                streamHandlers.add((BuildActionsProvider.OutputStreamHandler)((Object)action));
            }
            handler.init(pae, paes, streamHandlers);
        }

        private FileOperationsNotifier getFileOperationsNotifier(ProjectActionEvent[] paes) {
            HashMap<Project, ProjectFileOperationsNotifier> prj2Notifier = new HashMap<Project, ProjectFileOperationsNotifier>();
            for (ProjectActionEvent pae : paes) {
                if (!ProjectActionSupport.isFileOperationsIntensive(pae)) continue;
                Project project = pae.getProject();
                ProjectFileOperationsNotifier notifer = (ProjectFileOperationsNotifier)prj2Notifier.get(project);
                if (notifer == null) {
                    NativeProjectChangeSupport npcs = null;
                    try {
                        NativeProject nativeProject;
                        npcs = (NativeProjectChangeSupport)project.getLookup().lookup(NativeProjectChangeSupport.class);
                        if (npcs == null && (nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)) instanceof NativeProjectChangeSupport) {
                            npcs = (NativeProjectChangeSupport)nativeProject;
                        }
                    }
                    catch (Exception e) {
                        System.err.println("getNativeProject " + e);
                    }
                    notifer = new ProjectFileOperationsNotifier(npcs, pae);
                    prj2Notifier.put(project, notifer);
                }
                notifer.finishPAE = pae;
            }
            return new FileOperationsNotifier(prj2Notifier);
        }

        public NativeProjectChangeSupport getNativeProjectChangeSupport(Project project) {
            NativeProject nativeProject = null;
            try {
                nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
            }
            catch (Exception e) {
                System.err.println("getNativeProject " + e);
            }
            if (nativeProject instanceof NativeProjectChangeSupport) {
                return (NativeProjectChangeSupport)nativeProject;
            }
            return null;
        }

        private boolean checkExecutable(ProjectActionEvent pae) {
            String executable = pae.getExecutable();
            if (executable.length() == 0) {
                ConfirmSupport.SelectExecutable confirm = ConfirmSupport.getDefaultSelectExecutableFactory().create(pae);
                if (confirm != null) {
                    String currentValue;
                    String selectedExecutable = confirm.getExecutable();
                    MakeConfiguration projectConfiguration = pae.getConfiguration();
                    RunProfile runProfile = projectConfiguration.getProfile();
                    if (runProfile != null && (currentValue = runProfile.getRunCommand().getValue()).isEmpty()) {
                        runProfile.getRunCommand().setValue("\"${OUTPUT_PATH}\"");
                    }
                    String relativeToBaseDir = ProjectSupport.toProperPath(projectConfiguration.getBaseFSPath(), selectedExecutable, pae.getProject());
                    projectConfiguration.getMakefileConfiguration().getOutput().setValue(relativeToBaseDir);
                    pae.setExecutable(selectedExecutable);
                    pae.setFinalExecutable();
                    return true;
                }
                return false;
            }
            if (!CndPathUtilities.isPathAbsolute((CharSequence)executable)) {
                String runDir = pae.getProfile().getRunDir();
                if (runDir != null && ((runDir = runDir.trim()).startsWith("~/") || runDir.startsWith("~\\") || runDir.equals("~"))) {
                    try {
                        runDir = pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment().isLocal() ? HostInfoUtils.getHostInfo((ExecutionEnvironment)pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment()).getUserDirFile().getAbsolutePath() + runDir.substring(1) : HostInfoUtils.getHostInfo((ExecutionEnvironment)pae.getConfiguration().getDevelopmentHost().getExecutionEnvironment()).getUserDir() + runDir.substring(1);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ProjectActionSupport.class.getName()).log(Level.INFO, "", ex);
                    }
                    catch (ConnectionManager.CancellationException ex) {
                        Logger.getLogger(ProjectActionSupport.class.getName()).log(Level.INFO, "", ex);
                    }
                }
                if (runDir == null || runDir.length() == 0) {
                    executable = CndPathUtilities.toAbsolutePath((FSPath)pae.getConfiguration().getBaseFSPath(), (String)executable);
                } else {
                    runDir = CndPathUtilities.toAbsolutePath((FSPath)pae.getConfiguration().getBaseFSPath(), (String)runDir);
                    FileSystem fs = pae.getConfiguration().getFileSystem();
                    executable = pae.getConfiguration().getBaseDir().equals(runDir) ? CndPathUtilities.toAbsolutePath((FileSystem)fs, (String)runDir, (String)executable) : CndPathUtilities.toAbsolutePath((FileSystem)fs, (String)runDir, (String)CndPathUtilities.getBaseName((String)executable));
                }
                executable = CndPathUtilities.normalizeSlashes((String)executable);
            }
            if (CndPathUtilities.isPathAbsolute((CharSequence)executable)) {
                MakeConfiguration conf = pae.getConfiguration();
                boolean ok = true;
                if (conf != null && !conf.getDevelopmentHost().isLocalhost()) {
                    String testUtility;
                    ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
                    if (!pae.isFinalExecutable()) {
                        PathMap mapper = RemoteSyncSupport.getPathMap((Lookup.Provider)pae.getProject());
                        if (mapper != null) {
                            String anExecutable = mapper.getRemotePath(executable, true);
                            if (anExecutable != null) {
                                executable = anExecutable;
                            }
                        } else {
                            LOGGER.log(Level.SEVERE, "Path Mapper not found for project {0} - using local path {1}", new Object[]{pae.getProject(), executable});
                        }
                    }
                    if ((testUtility = HostInfoUtils.searchFile((ExecutionEnvironment)execEnv, Arrays.asList(this.FILE_LOCATIONS), (String)"test", (boolean)true)) != null) {
                        ProcessUtils.ExitStatus res = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)testUtility, (String[])new String[]{"-x", executable, "-a", "-f", executable});
                        ok = res.isOK();
                    }
                } else {
                    File file = new File(executable);
                    if (!file.exists() && Utilities.isWindows()) {
                        file = CndFileUtils.createLocalFile((String)(executable + ".exe"));
                    }
                    if (!file.exists() || file.isDirectory()) {
                        ok = false;
                    }
                }
                if (!ok) {
                    String value = pae.getProfile().getRunCommand().getValue();
                    String errormsg = ProjectActionSupport.getString("EXECUTABLE_DOESNT_EXISTS", new String[]{executable});
                    CndNotifier.getDefault().notifyError(errormsg);
                    return false;
                }
            }
            pae.setExecutable(executable);
            pae.setFinalExecutable();
            return true;
        }
    }

    private static final class FileOperationsNotifier {
        private final Map<Project, ProjectFileOperationsNotifier> prjNotifier;

        public FileOperationsNotifier(Map<Project, ProjectFileOperationsNotifier> prjNotifier) {
            this.prjNotifier = prjNotifier;
        }

        private void onStart(ProjectActionEvent curPAE) {
            ProjectFileOperationsNotifier notifier = this.prjNotifier.get(curPAE.getProject());
            if (notifier != null && notifier.npcs != null && curPAE == notifier.startPAE) {
                notifier.npcs.fireFileOperationsStarted();
            }
        }

        public void onFinish(ProjectActionEvent curPAE) {
            ProjectFileOperationsNotifier notifier = this.prjNotifier.get(curPAE.getProject());
            if (notifier != null && notifier.npcs != null && curPAE == notifier.finishPAE) {
                notifier.npcs.fireFileOperationsFinished();
            }
        }

        private void finishAll() {
            for (ProjectFileOperationsNotifier notifier : this.prjNotifier.values()) {
                if (notifier.npcs == null) continue;
                notifier.npcs.fireFileOperationsFinished();
            }
        }

        private boolean isLastExpectedEvent(ProjectActionEvent curPAE) {
            ProjectFileOperationsNotifier notifier = this.prjNotifier.get(curPAE.getProject());
            return notifier != null && notifier.npcs != null && curPAE == notifier.finishPAE;
        }
    }

    private static final class ProjectFileOperationsNotifier {
        private final NativeProjectChangeSupport npcs;
        private final ProjectActionEvent startPAE;
        private ProjectActionEvent finishPAE;

        public ProjectFileOperationsNotifier(NativeProjectChangeSupport npcs, ProjectActionEvent startPAE) {
            this.npcs = npcs;
            this.startPAE = startPAE;
        }

        public String toString() {
            return "ProjectFileOperationsNotifier{npcs=" + this.npcs + ", startPAE=" + this.startPAE + ", finishPAE=" + this.finishPAE + '}';
        }
    }
}

