/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.wizards;

import java.io.IOException;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Lookup;

public abstract class DefaultMakeProjectLocationProvider {
    private static final DefaultMakeProjectLocationProvider EMPTY = new Empty();

    protected DefaultMakeProjectLocationProvider() {
    }

    public static DefaultMakeProjectLocationProvider getDefault() {
        DefaultMakeProjectLocationProvider provider = (DefaultMakeProjectLocationProvider)Lookup.getDefault().lookup(DefaultMakeProjectLocationProvider.class);
        return provider == null ? EMPTY : provider;
    }

    public abstract String getDefaultProjectFolder();

    public abstract String getDefaultProjectFolder(ExecutionEnvironment var1);

    private static final class Empty
    extends DefaultMakeProjectLocationProvider {
        Empty() {
        }

        @Override
        public String getDefaultProjectFolder() {
            return System.getProperty("user.home");
        }

        @Override
        public String getDefaultProjectFolder(ExecutionEnvironment env) {
            try {
                if (env.isLocal()) {
                    return this.getDefaultProjectFolder();
                }
                return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir();
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            catch (ConnectionManager.CancellationException ex) {
                ex.printStackTrace(System.err);
            }
            return null;
        }
    }
}

