/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.wizards;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Platforms;
import org.netbeans.modules.cnd.makeproject.api.support.SmartOutputStream;
import org.netbeans.modules.cnd.makeproject.api.wizards.PostProjectCreationProcessor;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectGenerator;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class MakeSampleProjectGenerator {
    private static final String PROJECT_CONFIGURATION_FILE = "nbproject/configurations.xml";
    private static final String PROJECT_PRIVATE_CONFIGURATION_FILE = "nbproject/private/configurations.xml";

    private MakeSampleProjectGenerator() {
    }

    public static Set<FileObject> createProjectFromTemplate(FileObject template, ProjectGenerator.ProjectParameters prjParams) throws IOException {
        String postCreationClassName;
        String subProjects;
        String mainProject = (String)template.getAttribute("mainProjectLocation");
        if (mainProject != null && mainProject.length() > 0) {
            prjParams.setMainProject(mainProject);
        }
        if ((subProjects = (String)template.getAttribute("subProjectLocations")) != null && subProjects.length() > 0) {
            prjParams.setSubProjects(subProjects);
        }
        if ((postCreationClassName = (String)template.getAttribute("postProjectCreationClassName")) != null && postCreationClassName.length() > 0) {
            prjParams.setPostCreationClassName(postCreationClassName);
        }
        if (mainProject != null) {
            String projectFolderPath = prjParams.getProjectFolderPath();
            FOPath fopath = new FOPath(projectFolderPath);
            FileObject parentFolderLocation = fopath.root != null ? FileUtil.createFolder((FileObject)fopath.root, (String)fopath.relPath) : FileUtil.createFolder((FileObject)prjParams.getSourceFileSystem().getRoot(), (String)projectFolderPath);
            FileObject mainProjectLocation = mainProject.equals(".") ? parentFolderLocation : FileUtil.createFolder((FileObject)parentFolderLocation, (String)mainProject);
            FileObject[] subProjectLocations = null;
            if (subProjects != null) {
                ArrayList<FileObject> subProjectsFiles = new ArrayList<FileObject>();
                StringTokenizer st = new StringTokenizer(subProjects, ",");
                while (st.hasMoreTokens()) {
                    subProjectsFiles.add(FileUtil.createFolder((FileObject)parentFolderLocation, (String)st.nextToken()));
                }
                subProjectLocations = subProjectsFiles.toArray(new FileObject[subProjectsFiles.size()]);
            }
            return MakeSampleProjectGenerator.createProjectWithSubprojectsFromTemplate(template.getInputStream(), parentFolderLocation, mainProjectLocation, subProjectLocations, prjParams);
        }
        return MakeSampleProjectGenerator.createProjectFromTemplate(template.getInputStream(), prjParams);
    }

    private static void addEmptyNode(Document doc, String nodeName) {
        Element data = null;
        NodeList list = doc.getElementsByTagName("data");
        if (list != null && list.getLength() > 0) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                if (!(node instanceof Element)) continue;
                data = (Element)node;
                break;
            }
        }
        if (data == null) {
            return;
        }
        NodeList nodeList = data.getElementsByTagName(nodeName);
        if (nodeList == null) {
            return;
        }
        Element element = doc.createElementNS("http://www.netbeans.org/ns/make-project/1", nodeName);
        data.appendChild(element);
    }

    private static void postProcessProject(FileObject prjLoc, String name, ProjectGenerator.ProjectParameters prjParams) throws IOException {
        try {
            FileObject fo = prjLoc.getFileObject("nbproject/project.xml");
            Document doc = XMLUtil.parse((InputSource)new InputSource(fo.getInputStream()), (boolean)false, (boolean)true, null, null);
            if (name != null) {
                MakeSampleProjectGenerator.changeXmlFileByTagName(doc, "name", name, null);
            }
            MakeSampleProjectGenerator.addEmptyNode(doc, "sourceRootList");
            MakeSampleProjectGenerator.saveXml(doc, prjLoc, "nbproject/project.xml");
            FileObject pfo = prjLoc.getFileObject(PROJECT_CONFIGURATION_FILE);
            if (pfo != null) {
                doc = XMLUtil.parse((InputSource)new InputSource(pfo.getInputStream()), (boolean)false, (boolean)true, null, null);
                String hostUID = prjParams.getHostUID();
                ExecutionEnvironment env = null;
                if (hostUID != null) {
                    env = ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
                }
                env = env != null ? env : ServerList.getDefaultRecord().getExecutionEnvironment();
                String prjHostUID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
                CompilerSetManager compilerSetManager = CompilerSetManager.get((ExecutionEnvironment)env);
                ExecutionEnvironment projectEE = FileSystemProvider.getExecutionEnvironment((FileObject)prjLoc);
                int platform = projectEE.isLocal() ? compilerSetManager.getPlatform() : CompilerSetManager.get((ExecutionEnvironment)projectEE).getPlatform();
                CompilerSet compilerSet = prjParams.getToolchain();
                compilerSet = compilerSet != null ? compilerSet : compilerSetManager.getDefaultCompilerSet();
                String variant = null;
                String csVariant = "GNU|GNU";
                if (compilerSet != null) {
                    variant = MakeConfiguration.getVariant(compilerSet, platform);
                    csVariant = compilerSet.getName();
                    if (compilerSet.getCompilerFlavor() != null) {
                        csVariant = csVariant + "|" + compilerSet.getCompilerFlavor().getToolchainDescriptor().getName();
                    }
                } else {
                    CndUtils.assertTrue((boolean)false, (String)"Expected not null tool collection");
                }
                CndUtils.assertTrue((platform != 6 ? 1 : 0) != 0, (String)"Expected not Unknown platform");
                if (prjParams.isDefaultToolchain()) {
                    csVariant = "default";
                }
                MakeSampleProjectGenerator.changeXmlFileByTagName(doc, "compilerSet", csVariant, "X-TOOLCHAIN-X");
                if (platform == 3) {
                    MakeSampleProjectGenerator.changeXmlFileByTagName(doc, "output", "lib", "X-LIBPREFIX-X");
                    MakeSampleProjectGenerator.changeXmlFileByTagAttrName(doc, "makeArtifact", "OP", "lib", "X-LIBPREFIX-X");
                    if (variant != null) {
                        MakeSampleProjectGenerator.changeXmlFileByTagAttrName(doc, "makeArtifact", "OP", variant, "X-PLATFORM-X");
                    }
                } else if (platform == 4) {
                    MakeSampleProjectGenerator.changeXmlFileByTagName(doc, "output", "lib", "X-LIBPREFIX-X");
                    MakeSampleProjectGenerator.changeXmlFileByTagAttrName(doc, "makeArtifact", "OP", "lib", "X-LIBPREFIX-X");
                    if (variant != null) {
                        MakeSampleProjectGenerator.changeXmlFileByTagAttrName(doc, "makeArtifact", "OP", variant, "X-PLATFORM-X");
                    }
                } else {
                    MakeSampleProjectGenerator.changeXmlFileByTagName(doc, "output", "lib", "X-LIBPREFIX-X");
                    MakeSampleProjectGenerator.changeXmlFileByTagAttrName(doc, "makeArtifact", "OP", "lib", "X-LIBPREFIX-X");
                    if (variant != null) {
                        MakeSampleProjectGenerator.changeXmlFileByTagAttrName(doc, "makeArtifact", "OP", variant, "X-PLATFORM-X");
                    }
                }
                MakeSampleProjectGenerator.saveXml(doc, prjLoc, PROJECT_CONFIGURATION_FILE);
                FileObject privateConfiguration = prjLoc.getFileObject(PROJECT_PRIVATE_CONFIGURATION_FILE);
                if (privateConfiguration != null) {
                    Document secodaryDoc = XMLUtil.parse((InputSource)new InputSource(privateConfiguration.getInputStream()), (boolean)false, (boolean)true, null, null);
                    MakeSampleProjectGenerator.changeXmlFileByTagName(secodaryDoc, "developmentServer", prjHostUID, "X-HOST-UID-X");
                    MakeSampleProjectGenerator.changeXmlFileByTagName(secodaryDoc, "platform", "" + platform, "X-PLATFORM-INDEX-X");
                    MakeSampleProjectGenerator.saveXml(secodaryDoc, prjLoc, PROJECT_PRIVATE_CONFIGURATION_FILE);
                } else {
                    Document secodaryDoc = XMLUtil.createDocument((String)"configurationDescriptor", null, null, null);
                    Element masterRoot = doc.getDocumentElement();
                    if (masterRoot != null) {
                        Element secodaryRoot = secodaryDoc.getDocumentElement();
                        secodaryRoot.setAttribute("version", masterRoot.getAttribute("version"));
                        NodeList masterConfsList = masterRoot.getElementsByTagName("confs");
                        if (masterConfsList.getLength() > 0) {
                            Element secondaryConfs = secodaryDoc.createElement("confs");
                            secodaryRoot.appendChild(secondaryConfs);
                            Node masterConfs = masterConfsList.item(0);
                            NodeList masterConfList = masterConfs.getChildNodes();
                            for (int i = 0; i < masterConfList.getLength(); ++i) {
                                if (masterConfList.item(i).getNodeType() != 1) continue;
                                Element masterConf = (Element)masterConfList.item(i);
                                Element secondaryConf = secodaryDoc.createElement("conf");
                                secondaryConf.setAttribute("name", masterConf.getAttribute("name"));
                                secondaryConf.setAttribute("type", masterConf.getAttribute("type"));
                                secondaryConfs.appendChild(secondaryConf);
                                Element secondaryToolSet = secodaryDoc.createElement("toolsSet");
                                secondaryConf.appendChild(secondaryToolSet);
                                Element secondaryDevelopmentServer = secodaryDoc.createElement("developmentServer");
                                secondaryToolSet.appendChild(secondaryDevelopmentServer);
                                secondaryDevelopmentServer.setTextContent(prjHostUID);
                                Element secondaryPlatform = secodaryDoc.createElement("platform");
                                secondaryToolSet.appendChild(secondaryPlatform);
                                secondaryPlatform.setTextContent("" + platform);
                            }
                        }
                    }
                    MakeSampleProjectGenerator.saveXml(secodaryDoc, prjLoc, PROJECT_PRIVATE_CONFIGURATION_FILE);
                }
                MakeSampleProjectGenerator.recordCreateSampleProject(env);
            }
        }
        catch (Exception e) {
            ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileObject)prjLoc);
            if (env.isRemote()) {
                Logger.getLogger("remote.support.logger").log(Level.INFO, "__DIAGNOSTICS__", new Object[]{prjLoc, Boolean.TRUE});
                ProcessUtils.ExitStatus rc = ProcessUtils.execute((ExecutionEnvironment)env, (String)"find", (String[])new String[]{prjLoc.getPath(), " -ls"});
                System.err.printf("Find in%n%s%nexited with rc=%d;%nerr=%s%nout=%n%s%n", prjLoc.getPath(), rc.exitCode, rc.getErrorString(), rc.getOutputString());
            }
            IOException ex = new IOException(e);
            throw ex;
        }
    }

    private static void customPostProcessProject(FileObject prjLoc, String name, ProjectGenerator.ProjectParameters prjParams) {
        PostProjectCreationProcessor ppcp = null;
        String postCreationClassName = prjParams.getPostCreationClassName();
        if (postCreationClassName != null && postCreationClassName.length() > 0) {
            Collection col = Lookup.getDefault().lookupAll(PostProjectCreationProcessor.class);
            for (PostProjectCreationProcessor instance : col) {
                if (!postCreationClassName.equals(instance.getClass().getName())) continue;
                ppcp = instance;
                break;
            }
            if (ppcp != null) {
                ppcp.postProcess(prjLoc, prjParams);
            }
        }
    }

    private static void recordCreateSampleProject(ExecutionEnvironment env) {
        String family;
        String flavor;
        String[] families;
        CompilerSetManager compilerSetManager = CompilerSetManager.get((ExecutionEnvironment)env);
        CompilerSet compilerSet = compilerSetManager.getDefaultCompilerSet();
        String host = env.isLocal() ? "LOCAL" : "REMOTE";
        String platform = compilerSet != null && Platforms.getPlatform(compilerSetManager.getPlatform()) != null ? Platforms.getPlatform(compilerSetManager.getPlatform()).getName() : "UNKNOWN_PLATFORM";
        if (compilerSet != null) {
            families = compilerSet.getCompilerFlavor().getToolchainDescriptor().getFamily();
            flavor = compilerSet.getCompilerFlavor().getToolchainDescriptor().getName();
        } else {
            families = new String[]{};
            flavor = "UKNOWN";
        }
        if (families.length == 0) {
            family = "UKNOWN";
        } else {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < families.length; ++i) {
                buffer.append(families[i]);
                if (i >= families.length - 1) continue;
                buffer.append(",");
            }
            family = buffer.toString();
        }
        UIGesturesSupport.submit((String)"USG_PROJECT_CREATE_CND", (Object[])new Object[]{"APPLICATION", flavor, family, host, platform, "SAMPLE_PROJECT"});
    }

    public static Set<FileObject> createProjectFromTemplate(InputStream inputStream, ProjectGenerator.ProjectParameters prjParams) throws IOException {
        String projectFolderPath = prjParams.getProjectFolderPath();
        FOPath fopath = new FOPath(projectFolderPath);
        FileObject prjLoc = fopath.root != null ? FileUtil.createFolder((FileObject)fopath.root, (String)fopath.relPath) : FileUtil.createFolder((FileObject)prjParams.getSourceFileSystem().getRoot(), (String)projectFolderPath);
        MakeSampleProjectGenerator.unzip(inputStream, prjLoc);
        MakeSampleProjectGenerator.postProcessProject(prjLoc, prjParams.getProjectName(), prjParams);
        MakeSampleProjectGenerator.customPostProcessProject(prjLoc, prjParams.getProjectName(), prjParams);
        prjLoc.refresh(false);
        return Collections.singleton(prjLoc);
    }

    private static void addToSet(List<FileObject> set, FileObject projectFile, ProjectGenerator.ProjectParameters prjParams, String projectName) throws IOException {
        try {
            MakeSampleProjectGenerator.postProcessProject(projectFile, projectName, prjParams);
            projectFile.refresh(false);
            set.add(projectFile);
        }
        catch (Exception e) {
            IOException ex = new IOException(e);
            throw ex;
        }
    }

    private static Set<FileObject> createProjectWithSubprojectsFromTemplate(InputStream templateResourceStream, FileObject parentFolderLocation, FileObject mainProjectLocation, FileObject[] subProjectLocations, ProjectGenerator.ProjectParameters prjParams) throws IOException {
        ArrayList<FileObject> set = new ArrayList<FileObject>();
        MakeSampleProjectGenerator.unzip(templateResourceStream, parentFolderLocation);
        MakeSampleProjectGenerator.addToSet(set, mainProjectLocation, prjParams, prjParams.getProjectName());
        if (subProjectLocations != null) {
            for (int i = 0; i < subProjectLocations.length; ++i) {
                MakeSampleProjectGenerator.addToSet(set, subProjectLocations[i], prjParams, null);
            }
        }
        FileObject prjLoc = CndFileUtils.toFileObject((File)prjParams.getProjectFolder());
        MakeSampleProjectGenerator.customPostProcessProject(prjLoc, prjParams.getProjectName(), prjParams);
        return new LinkedHashSet<FileObject>(set);
    }

    private static void changeXmlFileByNameNS(Document doc, String tagNameNS, String tagName, String newText, String regex) throws IOException {
        NodeList nlist = doc.getElementsByTagNameNS(tagNameNS, tagName);
        MakeSampleProjectGenerator.changeXmlFileByNodeList(nlist, newText, regex);
    }

    private static void changeXmlFileByTagName(Document doc, String tagName, String newText, String regex) throws IOException {
        NodeList nlist = doc.getElementsByTagName(tagName);
        MakeSampleProjectGenerator.changeXmlFileByNodeList(nlist, newText, regex);
    }

    private static void changeXmlFileByTagAttrName(Document doc, String tagName, String attrName, String newText, String regex) throws IOException {
        NodeList nlist = doc.getElementsByTagName(tagName);
        MakeSampleProjectGenerator.changeXmlFileByAttrList(nlist, attrName, newText, regex);
    }

    private static void changeXmlFileByNodeList(NodeList nlist, String newText, String regex) throws IOException {
        if (nlist != null) {
            for (int i = 0; i < nlist.getLength(); ++i) {
                Node n = nlist.item(i);
                if (n.getNodeType() != 1) continue;
                Element e = (Element)n;
                MakeSampleProjectGenerator.replaceText(e, newText, regex);
            }
        }
    }

    private static void changeXmlFileByAttrList(NodeList nlist, String attrName, String newText, String regex) throws IOException {
        if (nlist != null) {
            for (int i = 0; i < nlist.getLength(); ++i) {
                Element e;
                Attr attr;
                Node n = nlist.item(i);
                if (n.getNodeType() != 1 || (attr = (e = (Element)n).getAttributeNode(attrName)) == null) continue;
                attr.setValue(attr.getValue().replaceAll(regex, newText));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, FileObject targetFolder) throws IOException {
        try (ZipInputStream zip = new ZipInputStream(source);){
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                if (ent.isDirectory()) {
                    FileObject fileObject = FileUtil.createFolder((FileObject)targetFolder, (String)ent.getName());
                    continue;
                }
                FileObject f = FileUtil.createData((FileObject)targetFolder, (String)ent.getName());
                try (OutputStream out = f.getOutputStream();){
                    String ls;
                    if (ent.getName().toLowerCase(Locale.getDefault()).contains("makefile")) {
                        ls = "\n";
                    } else {
                        ls = (String)f.getAttribute("default-line-separator");
                        if (ls == null) {
                            ls = System.getProperty("line.separator");
                        }
                    }
                    MakeSampleProjectGenerator.copy(zip, out, ls);
                }
            }
        }
    }

    private static void copy(InputStream is, OutputStream os, String ls) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os, FileEncodingQuery.getDefaultEncoding()));
        while ((line = br.readLine()) != null) {
            bw.write(line + ls);
        }
        bw.flush();
    }

    private static void replaceText(Element parent, String name, String regex) {
        NodeList l = parent.getChildNodes();
        for (int i = 0; i < l.getLength(); ++i) {
            if (l.item(i).getNodeType() != 3) continue;
            Text text = (Text)l.item(i);
            if (regex != null) {
                String s = text.getNodeValue();
                text.setNodeValue(s.replaceAll(regex, name));
            } else {
                text.setNodeValue(name);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document doc, FileObject dir, String path) throws IOException {
        FileObject xml = FileUtil.createData((FileObject)dir, (String)path);
        FileLock lock = xml.lock();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            XMLUtil.write((Document)doc, (OutputStream)baos, (String)"UTF-8");
            byte[] data = SmartOutputStream.convertLineSeparator(baos, xml, xml.getParent());
            try (OutputStream os = SmartOutputStream.getSmartOutputStream(xml, lock);){
                os.write(data);
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    public static final class FOPath {
        public FileObject root;
        public String relPath;

        public FOPath(String projectFolderPath) {
            block8: {
                int index;
                if (projectFolderPath.length() > 1 && projectFolderPath.charAt(1) == ':') {
                    try {
                        if (projectFolderPath.length() > 2 && projectFolderPath.charAt(2) == '\\') {
                            File driver = new File(projectFolderPath.substring(0, 3));
                            URL url = Utilities.toURI((File)driver).toURL();
                            this.root = URLMapper.findFileObject((URL)url);
                            this.relPath = projectFolderPath.substring(3);
                            break block8;
                        }
                        File driver = new File(projectFolderPath.substring(0, 2));
                        URL url = Utilities.toURI((File)driver).toURL();
                        this.root = URLMapper.findFileObject((URL)url);
                        this.relPath = projectFolderPath.substring(2);
                    }
                    catch (Throwable driver) {}
                } else if (projectFolderPath.startsWith("\\\\") && (index = projectFolderPath.indexOf(92, 2)) > 0 && (index = projectFolderPath.indexOf(92, index + 1)) > 0) {
                    try {
                        File server = new File(projectFolderPath.substring(0, index));
                        URL url = Utilities.toURI((File)server).toURL();
                        this.root = URLMapper.findFileObject((URL)url);
                        this.relPath = projectFolderPath.substring(index + 1);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

