/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.databinding.svg;

import javax.microedition.m2g.SVGImage;
import org.netbeans.microedition.databinding.DataBindingProvider;
import org.netbeans.microedition.svg.SVGPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGMatrix;
import org.w3c.dom.svg.SVGPath;
import org.w3c.dom.svg.SVGRGBColor;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGBindingProvider
implements DataBindingProvider {
    public void notifyBind(String elPointer, Object consumer, Object feature) {
    }

    public void notifyUnbind(String elPointer, Object consumer, Object feature) {
    }

    public Object pullDataFromConsumer(String elPointer, Object consumer, Object feature) {
        return null;
    }

    public void pushDataToConsumer(String elPointer, Object consumer, Object feature, Object value) {
        if (consumer instanceof SVGPlayer) {
            SVGPlayer player = (SVGPlayer)((Object)consumer);
            if (feature instanceof SVGImageFeature) {
                SVGImageFeature svgImageFeature = (SVGImageFeature)feature;
                this.safelyUpdateDOM(player, svgImageFeature, value);
            }
        }
    }

    private void safelyUpdateDOM(SVGPlayer player, final SVGImageFeature feature, final Object value) {
        int state = player.getAnimatorState();
        SVGImage svgImage = player.getSVGImage();
        Document doc = svgImage.getDocument();
        final SVGSVGElement svgsvg = (SVGSVGElement)doc.getDocumentElement();
        Element element = doc.getElementById(feature.elementID);
        if (element instanceof SVGElement) {
            final SVGElement svgElement = (SVGElement)element;
            Runnable runnable = new Runnable(){

                public void run() {
                    SVGBindingProvider.setTypeSafeTrait(svgsvg, svgElement, feature.trait, value);
                }
            };
            player.invokeLaterSafely(runnable);
        }
    }

    private static void setTypeSafeTrait(SVGSVGElement svgsvg, SVGElement svgElement, String traitName, Object traitValue) {
        if ("fill".equals(traitName) && traitValue instanceof Integer) {
            int color = (Integer)traitValue;
            traitValue = SVGBindingProvider.getRGBColor(svgsvg, color);
        }
        if (traitValue instanceof Float) {
            svgElement.setFloatTrait(traitName, ((Float)traitValue).floatValue());
        } else if (traitValue instanceof SVGMatrix) {
            svgElement.setMatrixTrait(traitName, (SVGMatrix)traitValue);
        } else if (traitValue instanceof SVGPath) {
            svgElement.setPathTrait(traitName, (SVGPath)traitValue);
        } else if (traitValue instanceof SVGRGBColor) {
            svgElement.setRGBColorTrait(traitName, (SVGRGBColor)traitValue);
        } else if (traitValue instanceof SVGRect) {
            svgElement.setRectTrait(traitName, (SVGRect)traitValue);
        } else {
            svgElement.setTrait(traitName, "" + traitValue);
        }
    }

    private static SVGRGBColor getRGBColor(SVGSVGElement svgsvg, int color) {
        int r = color / 65536 & 0xFF;
        int g = color / 256 & 0xFF;
        int b = color & 0xFF;
        return svgsvg.createSVGRGBColor(r, g, b);
    }

    public static class SVGImageFeature {
        private String elementID;
        private String trait;

        public SVGImageFeature(String elementID, String trait) {
            if (elementID == null) {
                throw new IllegalArgumentException("elementID cannot be null");
            }
            if (trait == null) {
                throw new IllegalArgumentException("trait cannot be null");
            }
            this.elementID = elementID;
            this.trait = trait;
        }
    }
}

