/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.source;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfMacinfoTable;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfStatementList;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.MACINFO;
import org.netbeans.modules.cnd.dwarfdump.section.FileEntry;
import org.netbeans.modules.cnd.dwarfdump.source.Artifacts;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.dwarfdump.source.DefaultDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceFile
implements CompilationUnitInterface {
    private final String compileLine;
    private final String compileDir;
    private final String sourceFile;
    private String dwarfDump;
    private Map<String, String> userMacros;
    private List<String> userUndefs;
    private List<String> userPaths;
    private List<String> userIncludes;
    private final String absolutePath;
    private final String sourceLanguage;
    private final boolean hasMain;
    private final int mainLine;

    public static SourceFile createSourceFile(String compileDir, String sourceFile, String compileLine) {
        return new SourceFile(compileDir, sourceFile, compileLine, null, null, false, -1, null);
    }

    public static SourceFile createSourceFile(String compileDir, String sourceFile, String compileLine, String absolutePath, String sourceLanguage, boolean hasMain, int mainLine, String dwarf) {
        return new SourceFile(compileDir, sourceFile, compileLine, absolutePath, sourceLanguage, hasMain, mainLine, dwarf);
    }

    public static SourceFile createSourceFile(CompilationUnitInterface cu, boolean dwarf) throws IOException, Exception {
        SourceFile res = new SourceFile(cu);
        if (res.compileLine.length() == 0 && cu instanceof CompilationUnit && dwarf) {
            DwarfMacinfoTable dwarfMacroTable;
            CompilationUnit dcu = (CompilationUnit)cu;
            StringBuilder buf = new StringBuilder();
            DwarfStatementList dwarfStatementTable = dcu.getStatementList();
            if (dwarfStatementTable != null) {
                for (String dir : dwarfStatementTable.includeDirs) {
                    buf.append(" -d").append("'").append(dir).append("'");
                }
                for (FileEntry fileEntry : dwarfStatementTable.fileEntries) {
                    buf.append(" -f:").append("" + fileEntry.dirIndex).append(":'").append(fileEntry.fileName).append("'");
                }
            }
            if ((dwarfMacroTable = dcu.getMacrosTable()) != null) {
                List<DwarfMacinfoEntry> table = dwarfMacroTable.getCommandLineMarcos();
                for (DwarfMacinfoEntry entry : table) {
                    if ((entry.type == MACINFO.DW_MACINFO_define || entry.type == MACINFO.DW_MACRO_define_indirect) && entry.definition != null) {
                        String def = entry.definition;
                        int i = def.indexOf(32);
                        if (i > 0) {
                            buf.append(" -D").append(def.substring(0, i)).append("='").append(def.substring(i + 1).trim()).append("'");
                            continue;
                        }
                        buf.append(" -D").append(def.substring(0, i));
                        continue;
                    }
                    if (entry.type != MACINFO.DW_MACINFO_undef && entry.type != MACINFO.DW_MACRO_undef_indirect || entry.definition == null) continue;
                    buf.append(" -U").append(entry.definition);
                }
                if (dwarfStatementTable != null) {
                    List<Integer> commandLineIncludedFiles = dwarfMacroTable.getCommandLineIncludedFiles();
                    for (int i : commandLineIncludedFiles) {
                        String includedSource = dwarfStatementTable.getFilePath(i);
                        if (includedSource.startsWith("./")) {
                            includedSource = res.compileDir + includedSource.substring(1);
                        }
                        if (res.absolutePath.equals(includedSource)) continue;
                        buf.append(" -include").append("'").append(includedSource).append("'");
                    }
                }
            }
            res.dwarfDump = buf.toString().trim();
        }
        return res;
    }

    private SourceFile(CompilationUnitInterface cu) throws IOException, Exception {
        String s = cu.getCommandLine();
        if (s == null) {
            s = "";
        }
        this.compileLine = s.trim();
        this.compileDir = cu.getCompilationDir();
        this.sourceFile = cu.getSourceFileName();
        if (this.sourceFile == null) {
            throw new Exception("Dwarf information does not contain source file name");
        }
        this.absolutePath = cu.getSourceFileAbsolutePath();
        this.sourceLanguage = cu.getSourceLanguage();
        this.hasMain = cu.hasMain();
        this.mainLine = cu.getMainLine();
    }

    private SourceFile(String compileDir, String sourceFile, String compileLine, String absolutePath, String sourceLanguage, boolean hasMain, int mainLine, String dwarf) {
        this.compileLine = compileLine == null ? "" : compileLine;
        this.compileDir = compileDir;
        this.sourceFile = sourceFile;
        this.absolutePath = absolutePath;
        this.sourceLanguage = sourceLanguage;
        this.hasMain = hasMain;
        this.mainLine = mainLine;
        this.dwarfDump = dwarf;
    }

    @Override
    public final String getCompilationDir() {
        return this.compileDir;
    }

    @Override
    public final String getSourceFileName() {
        return this.sourceFile;
    }

    @Override
    public final String getCommandLine() {
        return this.compileLine;
    }

    @Override
    public String getSourceFileAbsolutePath() {
        return this.absolutePath;
    }

    @Override
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    @Override
    public boolean hasMain() {
        return this.hasMain;
    }

    @Override
    public int getMainLine() {
        return this.mainLine;
    }

    public final String getDwarfDump() {
        return this.dwarfDump;
    }

    public final Map<String, String> getUserMacros() {
        if (this.userMacros == null) {
            this.initMacrosAndPaths();
        }
        return this.userMacros;
    }

    public final List<String> getUndefs() {
        if (this.userUndefs == null) {
            this.initMacrosAndPaths();
        }
        return this.userUndefs;
    }

    public final List<String> getUserPaths() {
        if (this.userPaths == null) {
            this.initMacrosAndPaths();
        }
        return this.userPaths;
    }

    public final List<String> getIncludeFiles() {
        if (this.userIncludes == null) {
            this.initMacrosAndPaths();
        }
        return this.userIncludes;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceFile other = (SourceFile)obj;
        if (this.compileLine == null ? other.compileLine != null : !this.compileLine.equals(other.compileLine)) {
            return false;
        }
        if (this.compileDir == null ? other.compileDir != null : !this.compileDir.equals(other.compileDir)) {
            return false;
        }
        return !(this.sourceFile == null ? other.sourceFile != null : !this.sourceFile.equals(other.sourceFile));
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.compileLine != null ? this.compileLine.hashCode() : 0);
        hash = 97 * hash + (this.compileDir != null ? this.compileDir.hashCode() : 0);
        hash = 97 * hash + (this.sourceFile != null ? this.sourceFile.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "SourceFile{compileLine=" + this.compileLine + ", compileDir=" + this.compileDir + ", sourceFile=" + this.sourceFile + '}';
    }

    private void initMacrosAndPaths() {
        ListIterator<String> st = null;
        DefaultDriver driver = new DefaultDriver();
        if (this.compileLine.length() > 0) {
            st = driver.splitCommandLine(this.compileLine, CompileLineOrigin.DwarfCompileLine).listIterator();
        } else if (this.dwarfDump != null && this.dwarfDump.length() > 0) {
            st = driver.splitCommandLine(this.dwarfDump, CompileLineOrigin.DwarfCompileLine).listIterator();
        } else {
            this.userPaths = new ArrayList<String>();
            this.userIncludes = new ArrayList<String>();
            this.userMacros = new LinkedHashMap<String, String>();
            this.userUndefs = new ArrayList<String>();
            return;
        }
        Artifacts res = driver.gatherCompilerLine(st, CompileLineOrigin.BuildLog, LANG.DW_LANG_C_plus_plus.toString().equals(this.sourceLanguage));
        this.userPaths = new ArrayList<String>(res.getUserIncludes());
        this.userIncludes = new ArrayList<String>(res.getUserFiles());
        this.userMacros = new LinkedHashMap<String, String>(res.getUserMacros());
        this.userUndefs = new ArrayList<String>(res.getUserUndefinedMacros());
    }
}

