/*
 * Decompiled with CFR 0.152.
 */
package net.java.html.boot.fx;

import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.web.WebView;
import net.java.html.BrwsrCtx;
import net.java.html.boot.BrowserBuilder;
import org.netbeans.html.boot.fx.AbstractFXPresenter;

public final class FXBrowsers {
    private FXBrowsers() {
    }

    public static void load(WebView webView, URL url, Class<?> onPageLoad, String methodName, String ... args) {
        Object[] context = new Object[args.length + 1];
        System.arraycopy(args, 0, context, 1, args.length);
        Load load = new Load(webView, null);
        context[0] = load;
        BrowserBuilder.newBrowser((Object[])context).loadPage(url.toExternalForm()).loadFinished((Runnable)load).loadClass(onPageLoad).invoke(methodName, args).showAndWait();
    }

    public static void load(WebView webView, URL url, Runnable onPageLoad) {
        FXBrowsers.load(webView, url, onPageLoad, null);
    }

    public static void load(WebView webView, URL url, Runnable onPageLoad, ClassLoader loader) {
        FXBrowsers.load(webView, url, onPageLoad, loader, new Object[0]);
    }

    public static void load(WebView webView, URL url, Runnable onPageLoad, ClassLoader loader, Object ... context) {
        Object[] newCtx = new Object[context.length + 1];
        System.arraycopy(context, 0, newCtx, 1, context.length);
        Load load = new Load(webView, onPageLoad);
        newCtx[0] = load;
        BrowserBuilder.newBrowser((Object[])newCtx).loadPage(url.toExternalForm()).loadFinished((Runnable)load).classloader(loader).showAndWait();
    }

    public static void runInBrowser(WebView webView, Runnable code) {
        Object ud = webView.getUserData();
        if (!(ud instanceof Load)) {
            throw new IllegalArgumentException();
        }
        ((Load)ud).ctx.execute(code);
    }

    private static class Load
    extends AbstractFXPresenter
    implements Runnable {
        private final WebView webView;
        private final Runnable myLoad;
        private BrwsrCtx ctx;

        public Load(WebView webView, Runnable onLoad) {
            this.webView = webView;
            this.myLoad = onLoad;
            webView.setUserData((Object)this);
        }

        @Override
        public void run() {
            this.ctx = BrwsrCtx.findDefault(Load.class);
            if (this.myLoad != null) {
                this.myLoad.run();
            }
        }

        @Override
        protected void waitFinished() {
        }

        @Override
        protected WebView findView(final URL resource) {
            final Worker w = this.webView.getEngine().getLoadWorker();
            w.stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){
                private String previous;

                public void changed(ObservableValue<? extends Worker.State> ov, Worker.State t, Worker.State newState) {
                    if (newState.equals((Object)Worker.State.SUCCEEDED) && this.checkValid()) {
                        Load.this.onPageLoad();
                    }
                    if (newState.equals((Object)Worker.State.FAILED)) {
                        this.checkValid();
                        throw new IllegalStateException("Failed to load " + resource);
                    }
                }

                private boolean checkValid() {
                    String crnt = Load.this.webView.getEngine().getLocation();
                    if (this.previous != null && !this.previous.equals(crnt)) {
                        w.stateProperty().removeListener((ChangeListener)this);
                        return false;
                    }
                    this.previous = crnt;
                    return true;
                }
            });
            return this.webView;
        }
    }
}

