/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.GitRef;
import org.netbeans.modules.git.remote.cli.jgit.JGitConfig;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.ListBranchCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public final class Utils {
    private Utils() {
    }

    public static VCSFileProxy getMetadataFolder(VCSFileProxy workDir) {
        return VCSFileProxy.createFileProxy((VCSFileProxy)workDir, (String)".git");
    }

    public static List<String> getRelativePaths(VCSFileProxy workDir, VCSFileProxy[] roots) {
        ArrayList<String> paths = new ArrayList<String>(roots.length);
        for (VCSFileProxy root : roots) {
            if (workDir.equals((Object)root)) {
                paths.clear();
                break;
            }
            paths.add(Utils.getRelativePath(workDir, root));
        }
        return paths;
    }

    public static String getRelativePath(VCSFileProxy repo, VCSFileProxy file) {
        return Utils.getRelativePath(repo, file, false);
    }

    private static String getRelativePath(VCSFileProxy repo, VCSFileProxy file, boolean canonicalized) {
        StringBuilder relativePath = new StringBuilder("");
        VCSFileProxy parent = file;
        if (!parent.equals((Object)repo)) {
            while (parent != null && !parent.equals((Object)repo)) {
                relativePath.insert(0, "/").insert(0, parent.getName());
                parent = parent.getParentFile();
            }
            if (parent == null) {
                if (!canonicalized) {
                    try {
                        return Utils.getRelativePath(VCSFileProxySupport.getCanonicalFile((VCSFileProxy)repo), VCSFileProxySupport.getCanonicalFile((VCSFileProxy)file), true);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(Utils.class.getName()).log(Level.FINE, null, ex);
                    }
                }
                throw new IllegalArgumentException(file.getPath() + " is not under " + repo.getPath());
            }
            relativePath.deleteCharAt(relativePath.length() - 1);
        }
        return relativePath.toString();
    }

    public static void deleteRecursively(VCSFileProxy file) {
        VCSFileProxy[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                Utils.deleteRecursively(files[i]);
            }
        }
        VCSFileProxySupport.delete((VCSFileProxy)file);
    }

    public static String getRefName(GitRef ref) {
        String name = ref.getName();
        for (String prefix : Arrays.asList("refs/heads/", "refs/remotes/", "refs/tags/", "refs/")) {
            if (!name.startsWith(prefix)) continue;
            name = name.substring(prefix.length());
        }
        return name;
    }

    public static Map<String, GitBranch> refsToBranches(Collection<GitRef> allRefs, String prefix, GitClassFactory factory) {
        LinkedHashMap<String, GitBranch> branches = new LinkedHashMap<String, GitBranch>();
        GitRef head = null;
        for (GitRef ref : allRefs) {
            if (!ref.getLeaf().getName().equals("HEAD")) continue;
            head = ref;
            break;
        }
        for (GitRef ref : allRefs) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith(prefix)) continue;
            String name = refName.substring(prefix.length());
            String id = ref.getLeaf().getObjectId();
            if (id == null) {
                Logger.getLogger(Utils.class.getName()).log(Level.INFO, "Null object id for ref: {0}, {1}:{2}, {3}", new Object[]{ref.toString(), ref.getName(), ref.getObjectId(), ref.getLeaf()});
                continue;
            }
            branches.put(name, factory.createBranch(name, false, head != null && ref.getObjectId().equals(head.getObjectId()), id));
        }
        return branches;
    }

    public static Map<String, String> refsToTags(Collection<GitRef> allRefs) {
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        for (GitRef ref : allRefs) {
            String refName = ref.getLeaf().getName();
            if (!refName.startsWith("refs/tags/")) continue;
            String name = refName.substring("refs/tags/".length());
            tags.put(name, ref.getLeaf().getObjectId());
        }
        return tags;
    }

    public static ResourceBundle getBundle(Class clazz) {
        String pref = clazz.getName();
        int last = pref.lastIndexOf(46);
        pref = last >= 0 ? pref.substring(0, last + 1) + "Bundle" : "Bundle";
        return ResourceBundle.getBundle(pref);
    }

    public static GitBranch getTrackedBranch(JGitConfig config, String branchName, Map<String, GitBranch> allBranches) {
        String remoteName = config.getString("branch", branchName, "remote");
        String trackedBranchName = config.getString("branch", branchName, "merge");
        if (trackedBranchName != null) {
            if (trackedBranchName.startsWith("refs/heads/")) {
                trackedBranchName = trackedBranchName.substring("refs/heads/".length());
            } else if (trackedBranchName.startsWith("refs/remotes/")) {
                trackedBranchName = trackedBranchName.substring("refs/remotes/".length());
            }
        }
        if (trackedBranchName == null) {
            return null;
        }
        remoteName = remoteName != null && ".".equals(remoteName) ? "" : remoteName + "/";
        return allBranches.get(remoteName + trackedBranchName);
    }

    public static Map getAllBranches(JGitRepository repository, GitClassFactory fac, ProgressMonitor monitor) throws GitException {
        ListBranchCommand cmd = new ListBranchCommand(repository, fac, true, monitor);
        cmd.execute();
        return cmd.getBranches();
    }
}

