/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRebaseResult;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.util.Cancellable;

public class RebaseCommand
extends GitCommand {
    private final String revision;
    private GitRebaseResult result;
    private final ProgressMonitor monitor;
    private final GitClient.RebaseOperationType operation;

    public RebaseCommand(JGitRepository repository, GitClassFactory gitFactory, String revision, GitClient.RebaseOperationType operation, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.revision = revision;
        this.operation = operation;
        this.monitor = monitor;
    }

    public GitRebaseResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "rebase");
        if (this.operation == GitClient.RebaseOperationType.BEGIN) {
            this.addArgument(0, "-v");
            this.addArgument(0, "--stat");
            this.addArgument(0, this.revision);
        } else {
            this.addArgument(0, this.operation.toString());
        }
        this.addArgument(1, "show");
        this.addArgument(1, "--raw");
        this.addArgument(1, "HEAD");
    }

    @Override
    protected void run() throws GitException {
        block7: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                String read;
                VCSFileProxy orig;
                final GitRebaseResult.RebaseResultContainer status = new GitRebaseResult.RebaseResultContainer();
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        RebaseCommand.this.parseRebaseOutput(output, status);
                    }

                    @Override
                    protected void outputErrorParser(String output, String error, int exitCode) throws GitException {
                        RebaseCommand.this.parseRebaseOutput(output, error, exitCode, status);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                    }
                }.runCLI();
                if (status.rebaseStatus == GitRebaseResult.RebaseStatus.UP_TO_DATE || status.rebaseStatus == GitRebaseResult.RebaseStatus.ABORTED || status.rebaseStatus == GitRebaseResult.RebaseStatus.OK || status.rebaseStatus == GitRebaseResult.RebaseStatus.NOTHING_TO_COMMIT) {
                    final GitRevisionInfo.GitRevCommit st = new GitRevisionInfo.GitRevCommit();
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CommitCommand.parseLog(output, st);
                        }
                    }.runCLI();
                    status.currentHead = st.revisionCode;
                } else if (status.rebaseStatus == GitRebaseResult.RebaseStatus.STOPPED && (orig = VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)".git/rebase-apply/original-commit")).exists() && !(read = this.read(orig)).isEmpty()) {
                    status.currentCommit = read;
                }
                this.result = this.getClassFactory().createRebaseResult(status);
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block7;
                throw new GitException(t);
            }
        }
    }

    private void parseRebaseOutput(String output, GitRebaseResult.RebaseResultContainer status) {
        if (output.contains("is up to date.")) {
            status.rebaseStatus = GitRebaseResult.RebaseStatus.UP_TO_DATE;
        } else if (output.startsWith("HEAD")) {
            if (this.operation == GitClient.RebaseOperationType.ABORT) {
                status.rebaseStatus = GitRebaseResult.RebaseStatus.ABORTED;
            }
        } else if (this.operation == GitClient.RebaseOperationType.SKIP || this.operation == GitClient.RebaseOperationType.CONTINUE) {
            status.rebaseStatus = GitRebaseResult.RebaseStatus.OK;
        }
    }

    private void parseRebaseOutput(String output, String error, int exitCode, GitRebaseResult.RebaseResultContainer status) {
        if (error.contains("Cannot rebase: You have unstaged changes.")) {
            status.rebaseStatus = GitRebaseResult.RebaseStatus.FAILED;
        } else if (error.contains("Cannot rebase: Your index contains uncommitted changes.")) {
            status.rebaseStatus = GitRebaseResult.RebaseStatus.FAILED;
        } else if (output.contains("Cannot rebase: Your index contains uncommitted changes.")) {
            status.rebaseStatus = GitRebaseResult.RebaseStatus.FAILED;
        } else {
            status.rebaseStatus = GitRebaseResult.RebaseStatus.STOPPED;
            for (String line : output.split("\n")) {
                if (line.startsWith("Changes from")) {
                    String[] s = line.substring(12).trim().split(" ");
                    if (s.length != 3) continue;
                    String from = s[0];
                    String to = s[2];
                    if (to.endsWith(":")) {
                        to = to.substring(0, to.length() - 1);
                    }
                    status.currentCommit = from;
                    status.currentHead = to;
                    continue;
                }
                if (line.startsWith(" ") && line.indexOf(124) > 0) {
                    String file = line.substring(1, line.indexOf(124)).trim();
                    status.conflicts.add(VCSFileProxy.createFileProxy((VCSFileProxy)this.getRepository().getLocation(), (String)file));
                    continue;
                }
                if (line.startsWith("CONFLICT") || !line.startsWith("No changes")) continue;
                status.rebaseStatus = GitRebaseResult.RebaseStatus.NOTHING_TO_COMMIT;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String read(VCSFileProxy file) throws IOException {
        StringBuilder sb;
        block8: {
            FileObject fo = file.toFileObject();
            Charset encoding = null;
            if (fo != null) {
                encoding = FileEncodingQuery.getEncoding((FileObject)fo);
            }
            if (encoding == null) {
                encoding = Charset.forName("UTF-8");
            }
            sb = new StringBuilder();
            try (BufferedReader r = null;){
                r = new BufferedReader(new InputStreamReader(file.getInputStream(false), encoding));
                String s = r.readLine();
                if (s == null) break block8;
                while (true) {
                    sb.append(s);
                    s = r.readLine();
                    if (s == null) {
                        break;
                    }
                    sb.append('\n');
                }
            }
        }
        return sb.toString();
    }
}

