/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmFileInfoQuery;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorComponent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorContent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorModel;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.modules.editor.breadcrumbs.spi.BreadcrumbsController;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.IndexingAwareParserResultTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;
import org.netbeans.modules.parsing.spi.TaskIndexingMode;
import org.netbeans.modules.parsing.spi.support.CancelSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class NavigatorNodeFactoryTask
extends IndexingAwareParserResultTask<Parser.Result> {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.model.tasks");
    private final CancelSupport cancel = CancelSupport.create((SchedulerTask)this);
    private AtomicBoolean canceled = new AtomicBoolean(false);
    static final int PRIORITY = 90;

    public NavigatorNodeFactoryTask() {
        super(TaskIndexingMode.ALLOWED_DURING_SCAN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        Document doc;
        NavigatorNodeFactoryTask navigatorNodeFactoryTask = this;
        synchronized (navigatorNodeFactoryTask) {
            this.canceled.set(true);
            this.canceled = new AtomicBoolean(false);
        }
        if (this.cancel.isCancelled()) {
            return;
        }
        boolean navigatorEnabled = NavigatorComponent.getInstance().isNavigatorEnabled();
        Source source = result.getSnapshot().getSource();
        if (!navigatorEnabled && (doc = source.getDocument(false)) != null && !BreadcrumbsController.areBreadCrumsEnabled((Document)doc)) {
            return;
        }
        FileObject fo = source.getFileObject();
        if (fo == null) {
            return;
        }
        DataObject cdo = null;
        try {
            cdo = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        if (cdo == null) {
            return;
        }
        long time = 0L;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "NavigatorNodeFactoryTask started");
            time = System.currentTimeMillis();
        }
        try {
            NavigatorModel oldModel;
            NavigatorContent content;
            NavigatorPanelUI panelUI;
            if (!navigatorEnabled) {
                panelUI = null;
                content = NavigatorComponent.getContent();
            } else {
                panelUI = NavigatorComponent.getInstance().getPanelUI();
                content = panelUI.getContent();
            }
            String mimeType = result.getSnapshot().getMimePath().getPath();
            CsmFile csmFile = CsmFileInfoQuery.getDefault().getCsmFile(result);
            if (csmFile != null && (oldModel = content.getModel()) != null) {
                DataObject oldCdo = oldModel.getDataObject();
                CsmFile oldCsmFile = oldModel.getCsmFile();
                if (oldCsmFile != null && oldCsmFile.isValid() && cdo.equals(oldCdo) && csmFile.equals(oldCsmFile) && csmFile.isValid()) {
                    oldModel.update(this.canceled, false);
                    return;
                }
            }
            NavigatorModel model = new NavigatorModel(cdo, fo, panelUI, mimeType, csmFile);
            content.setModel(model);
            model.update(this.canceled, true);
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "NavigatorNodeFactoryTask finished for {0}ms", System.currentTimeMillis() - time);
            }
        }
    }

    public int getPriority() {
        return 90;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.SELECTED_NODES_SENSITIVE_TASK_SCHEDULER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void cancel() {
        NavigatorNodeFactoryTask navigatorNodeFactoryTask = this;
        synchronized (navigatorNodeFactoryTask) {
            this.canceled.set(true);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "NavigatorNodeFactoryTask cancelled");
        }
    }

    public static class NavigatorSourceFactory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singletonList(new NavigatorNodeFactoryTask());
        }
    }
}

