/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProgressEvent;
import org.netbeans.modules.refactoring.api.ProgressListener;
import org.netbeans.modules.refactoring.java.api.EncapsulateFieldRefactoring;
import org.netbeans.modules.refactoring.java.api.JavaRefactoringUtils;
import org.netbeans.modules.refactoring.java.plugins.EncapsulateFieldRefactoringPlugin;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldPanel;
import org.netbeans.modules.refactoring.java.ui.EncapsulateFieldsRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class EncapsulateFieldsPlugin
extends JavaRefactoringPlugin {
    private List<EncapsulateFieldRefactoringPlugin> refactorings;
    private final EncapsulateFieldsRefactoring refactoring;
    private ProgressListener listener = new ProgressListener(){

        public void start(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStart(event.getOperationType(), event.getCount());
        }

        public void step(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStep();
        }

        public void stop(ProgressEvent event) {
            EncapsulateFieldsPlugin.this.fireProgressListenerStop();
        }
    };

    public EncapsulateFieldsPlugin(EncapsulateFieldsRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    @Override
    protected Problem checkParameters(CompilationController javac) throws IOException {
        return this.validation(2, javac);
    }

    @Override
    public Problem fastCheckParameters() {
        Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> fields = this.refactoring.getRefactorFields();
        if (fields.isEmpty()) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateNothingSelected"));
        }
        this.initRefactorings(fields, this.refactoring.getMethodModifiers(), this.refactoring.getFieldModifiers(), this.refactoring.isAlwaysUseAccessors(), this.refactoring.isGeneratePropertyChangeSupport(), this.refactoring.isGenerateVetoableSupport());
        try {
            return this.validation(1, null);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    protected Problem preCheck(CompilationController javac) throws IOException {
        javac.toPhase(JavaSource.Phase.RESOLVED);
        Problem preCheckProblem = EncapsulateFieldsPlugin.isElementAvail(this.refactoring.getSelectedObject(), (CompilationInfo)javac);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        TreePath selectedField = this.refactoring.getSelectedObject().resolve((CompilationInfo)javac);
        if (selectedField == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"DSC_ElNotAvail"));
        }
        Element elm = javac.getTrees().getElement(selectedField);
        if (elm != null && ElementKind.FIELD == elm.getKind()) {
            preCheckProblem = JavaPluginUtils.isSourceElement(elm, (CompilationInfo)javac);
            if (preCheckProblem != null) {
                return preCheckProblem;
            }
            TreePath source = javac.getTrees().getPath(elm);
            if (source == null) {
                return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"DSC_ElNotAvail"));
            }
            TypeElement encloser = (TypeElement)elm.getEnclosingElement();
            if (ElementKind.INTERFACE == encloser.getKind() || NestingKind.ANONYMOUS == encloser.getNestingKind()) {
                return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateInIntf"));
            }
            return null;
        }
        TreePath clazz = JavaRefactoringUtils.findEnclosingClass((CompilationInfo)javac, selectedField, true, false, true, false, false);
        TypeElement clazzElm = (TypeElement)javac.getTrees().getElement(clazz);
        preCheckProblem = JavaPluginUtils.isSourceElement(clazzElm, (CompilationInfo)javac);
        if (preCheckProblem != null) {
            return preCheckProblem;
        }
        if (elm != clazzElm || clazzElm == null) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateWrongType"));
        }
        if (ElementKind.INTERFACE == clazzElm.getKind() || ElementKind.ANNOTATION_TYPE == clazzElm.getKind() || NestingKind.ANONYMOUS == clazzElm.getNestingKind()) {
            return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateInIntf"));
        }
        for (Element element : clazzElm.getEnclosedElements()) {
            if (ElementKind.FIELD != element.getKind()) continue;
            return null;
        }
        return new Problem(true, NbBundle.getMessage(EncapsulateFieldsPlugin.class, (String)"ERR_EncapsulateNoFields", (Object)clazzElm.getQualifiedName()));
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Problem problem = null;
        HashSet<FileObject> references = new HashSet<FileObject>();
        ArrayList<EncapsulateFieldRefactoringPlugin.EncapsulateDesc> descs = new ArrayList<EncapsulateFieldRefactoringPlugin.EncapsulateDesc>(this.refactorings.size());
        this.fireProgressListenerStart(3, this.refactorings.size() + 1);
        for (EncapsulateFieldRefactoringPlugin ref : this.refactorings) {
            if (this.cancelRequested.get()) {
                return null;
            }
            EncapsulateFieldRefactoringPlugin.EncapsulateDesc desc = ref.prepareEncapsulator(problem);
            problem = desc.p;
            desc.p = null;
            if (problem != null && problem.isFatal()) {
                return problem;
            }
            descs.add(desc);
            references.addAll(desc.refs);
            this.fireProgressListenerStep();
        }
        EncapsulateFieldRefactoringPlugin.Encapsulator encapsulator = new EncapsulateFieldRefactoringPlugin.Encapsulator(descs, problem, (Integer)this.refactoring.getContext().lookup(Integer.class), (EncapsulateFieldPanel.SortBy)this.refactoring.getContext().lookup(EncapsulateFieldPanel.SortBy.class), (EncapsulateFieldPanel.Javadoc)this.refactoring.getContext().lookup(EncapsulateFieldPanel.Javadoc.class));
        Problem prob = this.createAndAddElements(references, new JavaRefactoringPlugin.TransformTask(this, encapsulator, ((EncapsulateFieldRefactoringPlugin.EncapsulateDesc)descs.get((int)0)).fieldHandle), elements, this.refactoring);
        this.fireProgressListenerStop();
        problem = encapsulator.getProblem();
        return prob != null ? prob : problem;
    }

    private void initRefactorings(Collection<EncapsulateFieldsRefactoring.EncapsulateFieldInfo> refactorFields, Set<Modifier> methodModifier, Set<Modifier> fieldModifier, boolean alwaysUseAccessors, boolean pcs, boolean vcs) {
        this.refactorings = new ArrayList<EncapsulateFieldRefactoringPlugin>(refactorFields.size());
        for (EncapsulateFieldsRefactoring.EncapsulateFieldInfo info : refactorFields) {
            EncapsulateFieldRefactoring ref = new EncapsulateFieldRefactoring(info.getField());
            ref.setGetterName(info.getGetterName());
            ref.setSetterName(info.getSetterName());
            ref.setMethodModifiers(methodModifier);
            ref.setFieldModifiers(fieldModifier);
            ref.setAlwaysUseAccessors(alwaysUseAccessors);
            ref.setGeneratePropertyChangeSupport(pcs);
            ref.setGenerateVetoableSupport(vcs);
            this.refactorings.add(new EncapsulateFieldRefactoringPlugin(ref));
        }
    }

    private Problem validation(int phase, CompilationController javac) throws IOException {
        Problem result = null;
        for (EncapsulateFieldRefactoringPlugin ref : this.refactorings) {
            Problem lastresult = null;
            switch (phase) {
                case 1: {
                    lastresult = ref.fastCheckParameters();
                    break;
                }
                case 2: {
                    lastresult = ref.preCheck(javac);
                    result = JavaPluginUtils.chainProblems(result, lastresult);
                    if (result != null && result.isFatal()) {
                        return result;
                    }
                    lastresult = ref.checkParameters(javac);
                    ref.addProgressListener(this.listener);
                }
            }
            if ((result = JavaPluginUtils.chainProblems(result, lastresult)) == null || !result.isFatal()) continue;
            return result;
        }
        return result;
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase p) {
        TreePathHandle selectedField = this.refactoring.getSelectedObject();
        FileObject fo = selectedField.getFileObject();
        return JavaSource.forFileObject((FileObject)fo);
    }
}

