/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.Trees;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;

public class FindSubtypesVisitor
extends FindVisitor {
    private boolean recursive;

    public FindSubtypesVisitor(boolean recursive, CompilationController workingCopy) {
        super(workingCopy);
        this.recursive = recursive;
    }

    @Override
    public Tree visitClass(ClassTree node, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return (Tree)super.visitClass(node, elementToFind);
        }
        Trees trees = this.workingCopy.getTrees();
        Types types = this.workingCopy.getTypes();
        TypeMirror type2 = elementToFind.asType();
        type2 = types.erasure(type2);
        if (this.recursive) {
            TypeMirror type1 = trees.getTypeMirror(this.getCurrentPath());
            if (type1 != null && this.isSubtype(type1 = types.erasure(type1), type2)) {
                this.addUsage(this.getCurrentPath());
            }
        } else {
            TypeElement el = (TypeElement)this.workingCopy.getTrees().getElement(this.getCurrentPath());
            if (el != null && el.getSuperclass() != null && types.isSameType(types.erasure(el.getSuperclass()), type2) || this.containsType(el.getInterfaces(), type2)) {
                this.addUsage(this.getCurrentPath());
            }
        }
        return (Tree)super.visitClass(node, elementToFind);
    }

    @Override
    public Tree visitLambdaExpression(LambdaExpressionTree node, Element elementToFind) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(this.getCurrentPath())) {
            return (Tree)super.visitLambdaExpression(node, elementToFind);
        }
        Trees trees = this.workingCopy.getTrees();
        Types types = this.workingCopy.getTypes();
        TypeMirror type1 = trees.getTypeMirror(this.getCurrentPath());
        if (type1 == null) {
            return (Tree)super.visitLambdaExpression(node, elementToFind);
        }
        type1 = types.erasure(type1);
        TypeMirror type2 = elementToFind.asType();
        if (types.isSameType(type1, type2 = types.erasure(type2)) || this.recursive && this.isSubtype(type1, type2)) {
            this.addUsage(this.getCurrentPath());
        }
        return (Tree)super.visitLambdaExpression(node, elementToFind);
    }

    private boolean containsType(List<? extends TypeMirror> list, TypeMirror t) {
        Types types = this.workingCopy.getTypes();
        for (TypeMirror typeMirror : list) {
            if (!types.isSameType(t, types.erasure(typeMirror))) continue;
            return true;
        }
        return false;
    }

    protected boolean isSubtype(TypeMirror type1, TypeMirror type2) {
        TypeMirror tm2;
        TypeMirror tm1;
        Types types = this.workingCopy.getTypes();
        return types.isSubtype(tm1 = type1, tm2 = type2) && !types.isSameType(tm1, tm2);
    }
}

