/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.client.Bundle;
import org.netbeans.modules.subversion.remote.client.MissingClientPanel;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnClientFactory;
import org.netbeans.modules.subversion.remote.options.SvnOptionsController;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class MissingClient
implements ActionListener,
HyperlinkListener {
    private final MissingClientPanel panel;
    private static final HashSet<String> ALLOWED_EXECUTABLES = new HashSet<String>(Arrays.asList("svn"));
    private final Context context;

    public MissingClient(Context context) {
        this.context = context;
        this.panel = new MissingClientPanel();
        this.panel.browseButton.addActionListener(this);
        this.panel.executablePathTextField.setText(SvnModuleConfig.getDefault(context.getFileSystem()).getExecutableBinaryPath());
        this.panel.textPane.addHyperlinkListener(this);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void show() {
        JButton ok = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_OK"));
        JButton cancel = new JButton(NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"CTL_Action_Cancel"));
        NotifyDescriptor descriptor = new NotifyDescriptor((Object)this.panel, NbBundle.getMessage(SvnClientExceptionHandler.class, (String)"MSG_CommandFailed_Title"), 2, 0, new Object[]{ok, cancel}, (Object)ok);
        if (DialogDisplayer.getDefault().notify(descriptor) == ok) {
            SvnModuleConfig.getDefault(this.context.getFileSystem()).setExecutableBinaryPath(this.panel.executablePathTextField.getText());
            SvnClientFactory.resetClient();
        }
    }

    private void onBrowseClick() {
        VCSFileProxy oldFile = this.getExecutableFile();
        JFileChooser fileChooser = VCSFileProxySupport.createFileChooser((VCSFileProxy)oldFile);
        fileChooser.setDialogTitle(NbBundle.getMessage(SvnOptionsController.class, (String)"Browse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || ALLOWED_EXECUTABLES.contains(f.getName());
            }

            @Override
            public String getDescription() {
                return Bundle.FileChooser_SvnExecutables_desc();
            }
        });
        fileChooser.showDialog(this.panel, NbBundle.getMessage(SvnOptionsController.class, (String)"OK_Button"));
        VCSFileProxy f = VCSFileProxySupport.getSelectedFile((JFileChooser)fileChooser);
        if (f != null) {
            VCSFileProxy parent;
            while ((!f.exists() || f.isFile()) && (parent = f.getParentFile()) != null) {
                f = parent;
            }
            this.panel.executablePathTextField.setText(f.getPath());
        }
    }

    private VCSFileProxy getExecutableFile() {
        String execPath = this.panel.executablePathTextField.getText();
        VCSFileProxy resource = VCSFileProxySupport.getResource((FileSystem)this.context.getFileSystem(), (String)execPath);
        return resource.normalizeFile();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.browseButton) {
            this.onBrowseClick();
        }
    }

    @Override
    @SuppressWarnings(value={"RCN"})
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
            return;
        }
        URL url = e.getURL();
        assert (url != null);
        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (displayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (displayer != null) {
            displayer.showURL(url);
        } else {
            Subversion.LOG.info("No URLDisplayer found.");
        }
    }
}

