/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNBaseDir;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.CommandNotificationListener;
import org.netbeans.modules.subversion.remote.client.cli.CommandlineClient;
import org.netbeans.modules.subversion.remote.client.cli.Parser;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public abstract class SvnCommand
implements CommandNotificationListener {
    private static final boolean EXPAND_TARGETS_OPTION = true;
    private final List<String> cmdError = new ArrayList<String>(10);
    private Exception thrownException;
    private boolean hasFailed;
    private Integer exitCode;
    private boolean commandExecuted;
    private final Arguments arguments;
    private CommandlineClient.NotificationHandler notificationHandler;
    private VCSFileProxy configDir;
    private String username;
    private String password;
    private VCSFileProxy tmpFolder;
    private final FileSystem fileSystem;

    protected SvnCommand(FileSystem fs) {
        this.fileSystem = fs;
        this.arguments = new Arguments();
    }

    public void setConfigDir(VCSFileProxy configDir) {
        this.configDir = configDir;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    CommandlineClient.NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    void setNotificationHandler(CommandlineClient.NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
        if (this.notifyOutput()) {
            notificationHandler.enableLog();
        } else {
            notificationHandler.disableLog();
        }
    }

    void prepareCommand() throws IOException {
        assert (this.notificationHandler != null);
        this.prepareCommand(this.arguments);
        this.config(this.configDir, this.username, this.password, this.arguments);
    }

    public abstract void prepareCommand(Arguments var1) throws IOException;

    protected abstract ISVNNotifyListener.Command getCommand();

    public void setCommandWorkingDirectory(VCSFileProxy ... files) {
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir(files));
    }

    protected boolean hasBinaryOutput() {
        return false;
    }

    protected boolean notifyOutput() {
        return true;
    }

    @Override
    public void commandStarted() {
        assert (!this.commandExecuted) : "Command re-use is not supported";
        this.commandExecuted = true;
        String cmdString = SvnCommand.toString(this.arguments, true).toString();
        this.notificationHandler.logCommandLine(cmdString);
    }

    @Override
    public void outputText(String lineString) {
        if (Subversion.LOG.isLoggable(Level.FINE)) {
            Subversion.LOG.fine("outputText [" + lineString + "]");
        }
        if (!this.notifyOutput()) {
            return;
        }
        Parser.Line line = Parser.getInstance().parse(lineString);
        if (line != null) {
            if (this.notificationHandler != null && line.getPath() != null) {
                String path;
                if (Subversion.LOG.isLoggable(Level.FINE)) {
                    Subversion.LOG.fine("outputText [" + line.getPath() + "]");
                }
                if (!(path = this.getAbsolutePath(line.getPath())).startsWith("/")) {
                    path = "/" + path;
                }
                this.notificationHandler.notifyListenersOfChange(VCSFileProxySupport.getResource((FileSystem)this.fileSystem, (String)path));
            }
            this.notify(line);
            this.notificationHandler.logMessage(lineString);
        }
    }

    public String getAbsolutePath(String path) {
        return path;
    }

    protected final String getAbsolutePath(String path, VCSFileProxy ... files) {
        if (!path.startsWith("/")) {
            for (VCSFileProxy f : files) {
                if (!f.getPath().endsWith("/" + path)) continue;
                return f.getPath();
            }
        }
        return path;
    }

    public void output(byte[] bytes) {
    }

    @Override
    public void errorText(String line) {
        if (line.toLowerCase(Locale.ENGLISH).contains("killed by signal")) {
            return;
        }
        this.cmdError.add(line);
        if (this.isErrorMessage(line)) {
            this.hasFailed = true;
        }
        this.notificationHandler.logError(line);
    }

    public void commandCompleted(int exitCode) {
        this.exitCode = exitCode;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    public final void commandFinished() {
        try {
            VCSFileProxy f = this.getTempCommandFolder(false);
            if (f != null) {
                SvnUtils.deleteRecursively(f);
            }
            this.notificationHandler.logCompleted("");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
    }

    public boolean hasFailed() {
        return this.hasFailed;
    }

    public List<String> getCmdError() {
        return this.cmdError;
    }

    public void setException(Exception e) {
        this.thrownException = e;
    }

    public Exception getThrownException() {
        return this.thrownException;
    }

    protected void notify(Parser.Line line) {
    }

    protected boolean isErrorMessage(String s) {
        return true;
    }

    public String getStringCommand() {
        return SvnCommand.toString(this.arguments, false).toString();
    }

    String[] getCliArguments() {
        ArrayList<String> l = new ArrayList<String>(this.arguments.size());
        for (String arg : this.arguments.toArray()) {
            l.add(arg);
        }
        return l.toArray(new String[l.size()]);
    }

    private static StringBuilder toString(Arguments args, boolean scramble) {
        StringBuilder cmd = new StringBuilder(100);
        boolean psswd = false;
        for (String arg : args) {
            cmd.append(psswd && scramble ? "******" : arg);
            cmd.append(' ');
            if (!scramble) continue;
            psswd = arg.equals("--password");
        }
        cmd.delete(cmd.length() - 1, cmd.length());
        return cmd;
    }

    protected String createTempCommandFile(String value) throws IOException {
        return this.createTempCommandFile(new String[]{value});
    }

    protected String createTempCommandFile(VCSFileProxy[] files) throws IOException {
        String[] lines = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            lines[i] = files[i].getPath();
            if (files[i].getPath().indexOf(64) == -1) continue;
            int n = i;
            lines[n] = lines[n] + '@';
        }
        return this.createTempCommandFile(lines);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String createTempCommandFile(String[] lines) throws IOException {
        VCSFileProxy targetFile = VCSFileProxySupport.createTempFile((VCSFileProxy)this.getTempCommandFolder(true), (String)"svn_", (String)"", (boolean)true);
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)targetFile), "UTF-8"));
            for (int i = 0; i < lines.length; ++i) {
                writer.print(i < lines.length - 1 ? lines[i] + "\n" : lines[i]);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
        return targetFile.getPath();
    }

    protected void config(VCSFileProxy configDir, String username, String password, Arguments arguments) {
        arguments.addConfigDir(configDir);
        arguments.add("--non-interactive");
        arguments.addCredentials(username, password);
    }

    protected static SVNUrl encodeUrl(SVNUrl url) {
        try {
            url = SvnUtils.decodeAndEncodeUrl(url);
        }
        catch (MalformedURLException ex) {
            Subversion.LOG.log(Level.INFO, "Url: " + url, ex);
        }
        return url;
    }

    private VCSFileProxy getTempCommandFolder(boolean forceCreation) throws IOException {
        if (this.tmpFolder == null && forceCreation) {
            this.tmpFolder = VCSFileProxySupport.getTempFolder((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)this.fileSystem.getRoot()), (boolean)true);
        }
        return this.tmpFolder;
    }

    public final class Arguments
    implements Iterable<String> {
        private final List<String> args = new ArrayList<String>(5);

        public void add(String argument) {
            this.args.add(argument);
        }

        public void add(VCSFileProxy ... files) {
            for (VCSFileProxy file : files) {
                this.add(file);
            }
        }

        public void add(VCSFileProxy file) {
            String absolutePath = file.getPath();
            if (absolutePath.indexOf(64) == -1) {
                this.add(absolutePath);
            } else {
                this.add(absolutePath + '@');
            }
        }

        public void add(SVNUrl url) {
            if (url != null) {
                this.add(this.makeCliUrlString(url, true));
            }
        }

        public void addNonExistent(SVNUrl url) {
            if (url != null) {
                this.add(this.makeCliUrlString(url, false));
            }
        }

        public void add(SVNRevision rev1, SVNRevision rev2) {
            this.add("-r");
            this.add((rev1 == null || rev1.toString().trim().equals("") ? "HEAD" : rev1.toString()) + ":" + (rev2 == null || rev2.toString().trim().equals("") ? "HEAD" : rev2.toString()));
        }

        public void add(SVNUrl url, SVNRevision pegging) {
            if (url != null) {
                this.add(this.makeCliUrlString(url, pegging));
            }
        }

        public void add(SVNRevision revision) {
            this.add("-r");
            this.add(revision == null || revision.toString().trim().equals("") ? "HEAD" : revision.toString());
        }

        public void addPathArguments(String ... paths) throws IOException {
            if (paths.length > 0 && paths.length < 500) {
                for (String path : paths) {
                    this.add("'" + path + "'");
                }
            } else {
                this.add("--targets");
                this.add(SvnCommand.this.createTempCommandFile(paths));
            }
        }

        public void addFileArguments(VCSFileProxy ... files) throws IOException {
            if (files.length > 0 && files.length < 500) {
                for (VCSFileProxy file : files) {
                    String path = file.getPath();
                    if (path.indexOf(64) != -1) {
                        path = path + '@';
                    }
                    this.add("'" + path + "'");
                }
            } else {
                this.add("--targets");
                this.add(SvnCommand.this.createTempCommandFile(files));
            }
        }

        public void addUrlArguments(SVNUrl ... urls) throws IOException {
            String[] paths = new String[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                paths[i] = this.makeCliUrlString(urls[i], true);
            }
            if (paths.length > 0 && paths.length < 500) {
                for (String path : paths) {
                    this.add("'" + path + "'");
                }
            } else {
                this.add("--targets");
                this.add(SvnCommand.this.createTempCommandFile(paths));
            }
        }

        private String makeCliUrlString(SVNUrl url, boolean appendAtSign) {
            String cliUrlString = SvnCommand.encodeUrl(url).toString();
            if (appendAtSign) {
                for (String pathSegment : url.getPathSegments()) {
                    if (pathSegment.indexOf(64) == -1) continue;
                    cliUrlString = cliUrlString + '@';
                    break;
                }
            }
            return cliUrlString;
        }

        private String makeCliUrlString(SVNUrl url, SVNRevision pegRev) {
            return SvnCommand.encodeUrl(url).toString() + '@' + (pegRev == null ? "HEAD" : pegRev);
        }

        public void addMessage(String message) throws IOException {
            if (message == null) {
                return;
            }
            this.add("--force-log");
            this.add("-F");
            String msgFile = SvnCommand.this.createTempCommandFile(message);
            this.add(msgFile);
        }

        public void addConfigDir(VCSFileProxy configDir) {
            if (configDir != null) {
                SvnCommand.this.arguments.add("--config-dir");
                SvnCommand.this.arguments.add(configDir);
            }
        }

        public void addCredentials(String user, String psswd) {
            if (user == null || user.trim().equals("")) {
                return;
            }
            this.add("--username");
            this.add(user);
            if (psswd == null) {
                psswd = "";
            }
            this.add("--password");
            this.add(psswd);
        }

        @Override
        public Iterator<String> iterator() {
            return this.args.iterator();
        }

        String[] toArray() {
            return this.args.toArray(new String[this.args.size()]);
        }

        int size() {
            return this.args.size();
        }
    }
}

