/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class MoveCommand
extends SvnCommand {
    private final SVNUrl fromUrl;
    private final SVNUrl toUrl;
    private final VCSFileProxy fromFile;
    private final VCSFileProxy toFile;
    private final String msg;
    private final SVNRevision rev;
    private final boolean force;

    public MoveCommand(FileSystem fileSystem, VCSFileProxy fromFile, VCSFileProxy toFile, boolean force) {
        super(fileSystem);
        this.fromFile = fromFile;
        this.toFile = toFile;
        this.force = force;
        this.toUrl = null;
        this.fromUrl = null;
        this.msg = null;
        this.rev = null;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.MOVE;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("move");
        arguments.add(this.fromFile);
        arguments.add(this.toFile.getPath());
        if (this.force) {
            arguments.add("--force");
        }
        this.setCommandWorkingDirectory(this.fromFile, this.toFile);
    }
}

