/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.client.cli.commands;

import java.io.IOException;
import org.netbeans.modules.subversion.remote.api.ISVNNotifyListener;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.client.cli.Parser;
import org.netbeans.modules.subversion.remote.client.cli.SvnCommand;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileSystem;

public class UpdateCommand
extends SvnCommand {
    private final VCSFileProxy[] files;
    private final boolean recursive;
    private final SVNRevision rev;
    private final boolean ignoreExternals;
    private long revision;

    public UpdateCommand(FileSystem fileSystem, VCSFileProxy[] files, SVNRevision rev, boolean recursive, boolean ignoreExternals) {
        super(fileSystem);
        this.files = files;
        this.recursive = recursive;
        this.rev = rev;
        this.ignoreExternals = ignoreExternals;
    }

    @Override
    protected ISVNNotifyListener.Command getCommand() {
        return ISVNNotifyListener.Command.UPDATE;
    }

    @Override
    public void prepareCommand(SvnCommand.Arguments arguments) throws IOException {
        arguments.add("update");
        if (!this.recursive) {
            arguments.add("-N");
        }
        if (this.rev != null) {
            arguments.add(this.rev);
        }
        if (this.ignoreExternals) {
            arguments.add("--ignore-externals");
        }
        arguments.add("--force");
        for (VCSFileProxy file : this.files) {
            arguments.add(file);
        }
        this.setCommandWorkingDirectory(this.files[0]);
    }

    public long getRevision() {
        return this.revision;
    }

    @Override
    protected void notify(Parser.Line line) {
        if (line.getRevision() != -1L) {
            this.revision = line.getRevision();
        }
    }
}

