/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.commit;

import java.util.ArrayList;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;

public final class ExcludeFromCommitAction
extends ContextAction {
    public static final int UNDEFINED = -1;
    public static final int EXCLUDING = 1;
    public static final int INCLUDING = 2;

    @Override
    protected boolean enable(Node[] nodes) {
        Context cachedContext = this.getCachedContext(nodes);
        FileSystem fileSystem = cachedContext.getFileSystem();
        if (fileSystem == null || !VCSFileProxySupport.isConnectedFileSystem((FileSystem)fileSystem)) {
            return false;
        }
        return this.isCacheReady() && this.getActionStatus(nodes) != -1;
    }

    @Override
    protected int getFileEnabledStatus() {
        return 88532;
    }

    @Override
    protected int getDirectoryEnabledStatus() {
        return 88532;
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        int actionStatus = this.getActionStatus(activatedNodes);
        switch (actionStatus) {
            case -1: 
            case 1: {
                return "popup_commit_exclude";
            }
            case 2: {
                return "popup_commit_include";
            }
        }
        throw new RuntimeException("Invalid action status: " + actionStatus);
    }

    public int getActionStatus(Node[] nodes) {
        VCSFileProxy[] files = this.getCachedContext(nodes).getFiles();
        int status = -1;
        for (int i = 0; i < files.length; ++i) {
            SvnModuleConfig config = SvnModuleConfig.getDefault(VCSFileProxySupport.getFileSystem((VCSFileProxy)files[i]));
            if (config.isExcludedFromCommit(files[i].getPath())) {
                if (status == 1) {
                    return -1;
                }
                status = 2;
                continue;
            }
            if (status == 2) {
                return -1;
            }
            status = 1;
        }
        return status;
    }

    @Override
    public void performContextAction(final Node[] nodes) {
        ContextAction.ProgressSupport support = new ContextAction.ProgressSupport(this, nodes, this.getCachedContext(nodes)){

            @Override
            public void perform() {
                int status = ExcludeFromCommitAction.this.getActionStatus(nodes);
                ArrayList<VCSFileProxy> files = new ArrayList<VCSFileProxy>();
                for (Node node : nodes) {
                    VCSFileProxy f;
                    VCSFileProxy aFile = (VCSFileProxy)node.getLookup().lookup(VCSFileProxy.class);
                    FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
                    if (aFile != null) {
                        files.add(aFile);
                        continue;
                    }
                    if (fo == null || (f = VCSFileProxy.createFileProxy((FileObject)fo)) == null) continue;
                    files.add(f);
                }
                if (files.size() == 0) {
                    return;
                }
                SvnModuleConfig config = SvnModuleConfig.getDefault(VCSFileProxySupport.getFileSystem((VCSFileProxy)((VCSFileProxy)files.get(0))));
                ArrayList<String> paths = new ArrayList<String>(files.size());
                for (VCSFileProxy file : files) {
                    paths.add(file.getPath());
                }
                if (this.isCanceled()) {
                    return;
                }
                if (status == 1) {
                    config.addExclusionPaths(paths);
                } else if (status == 2) {
                    config.removeExclusionPaths(paths);
                }
            }
        };
        support.start(this.createRequestProcessor(nodes));
    }
}

