/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.update;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.commit.ConflictResolvedAction;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.spi.diff.MergeVisualizer;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ResolveConflictsExecutor
extends SvnProgressSupport {
    private static final String TMP_PREFIX = "merge";
    static final String CHANGE_LEFT = "<<<<<<< ";
    static final String CHANGE_RIGHT = ">>>>>>> ";
    static final String CHANGE_DELIMETER = "=======";
    static final String LOCAL_FILE_SUFFIX = ".mine";
    static final String WORKING_FILE_SUFFIX = ".working";
    private String leftFileRevision = null;
    private String rightFileRevision = null;
    private final VCSFileProxy file;
    private static final String NESTED_CONFLICT = "NESTED_CONFLICT";

    public ResolveConflictsExecutor(VCSFileProxy file) {
        super(VCSFileProxySupport.getFileSystem((VCSFileProxy)file));
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exec() {
        assert (SwingUtilities.isEventDispatchThread());
        MergeVisualizer merge = (MergeVisualizer)Lookup.getDefault().lookup(MergeVisualizer.class);
        if (merge == null) {
            throw new IllegalStateException("No Merge engine found.");
        }
        try {
            FileObject fo = this.file.toFileObject();
            if (fo == null) {
                Subversion.LOG.log(Level.WARNING, "can''t resolve conflicts for null fileobject : {0}, exists: {1}", new Object[]{this.file, this.file.exists()});
                return;
            }
            FileLock lock = fo.lock();
            boolean mergeWriterCreated = false;
            try {
                mergeWriterCreated = this.handleMergeFor(this.file, fo, lock, merge);
            }
            finally {
                if (!mergeWriterCreated && lock != null) {
                    lock.releaseLock();
                }
            }
        }
        catch (FileAlreadyLockedException e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Set components = TopComponent.getRegistry().getOpened();
                    for (TopComponent tc : components) {
                        if (tc.getClientProperty((Object)ResolveConflictsExecutor.class.getName()) == null) continue;
                        tc.requestActive();
                    }
                }
            });
        }
        catch (IOException ioex) {
            if (NESTED_CONFLICT.equals(ioex.getMessage())) {
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"MSG_NestedConflicts"), NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"MSG_NestedConflicts_Title"), 2);
                VCSFileProxySupport.openFile((VCSFileProxy)this.file);
            }
            Subversion.LOG.log(Level.SEVERE, null, ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleMergeFor(VCSFileProxy file, FileObject fo, FileLock lock, MergeVisualizer merge) throws IOException {
        String mimeType = fo.getMIMEType();
        String ext = "." + fo.getExt();
        VCSFileProxy f1 = VCSFileProxySupport.createTempFile((VCSFileProxy)file, (String)TMP_PREFIX, (String)ext, (boolean)true);
        VCSFileProxy f2 = VCSFileProxySupport.createTempFile((VCSFileProxy)file, (String)TMP_PREFIX, (String)ext, (boolean)true);
        VCSFileProxy f3 = VCSFileProxySupport.createTempFile((VCSFileProxy)file, (String)TMP_PREFIX, (String)ext, (boolean)true);
        Charset encoding = FileEncodingQuery.getEncoding((FileObject)fo);
        Difference[] diffs = this.copyParts(true, file, f1, true, encoding);
        if (diffs.length == 0) {
            try {
                ConflictResolvedAction.perform(file);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(new Context(file), ex, true, true);
            }
            finally {
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            return false;
        }
        this.copyParts(false, file, f2, false, encoding);
        String originalLeftFileRevision = this.leftFileRevision;
        String originalRightFileRevision = this.rightFileRevision;
        if (this.leftFileRevision != null) {
            this.leftFileRevision = this.leftFileRevision.trim();
        }
        if (this.rightFileRevision != null) {
            this.rightFileRevision = this.rightFileRevision.trim();
        }
        this.leftFileRevision = this.leftFileRevision == null || this.leftFileRevision.equals(LOCAL_FILE_SUFFIX) || this.leftFileRevision.equals(WORKING_FILE_SUFFIX) ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.leftFileRevision);
        this.rightFileRevision = this.rightFileRevision == null || this.rightFileRevision.equals(LOCAL_FILE_SUFFIX) || this.rightFileRevision.equals(WORKING_FILE_SUFFIX) ? NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleWorkingFile") : NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Diff.titleRevision", (Object)this.rightFileRevision);
        VCSFileProxySupport.associateEncoding((VCSFileProxy)file, (VCSFileProxy)f1);
        VCSFileProxySupport.associateEncoding((VCSFileProxy)file, (VCSFileProxy)f2);
        StreamSource s1 = StreamSource.createSource((String)file.getName(), (String)this.leftFileRevision, (String)mimeType, (Reader)new BufferedReader(new InputStreamReader(f1.getInputStream(false), encoding)));
        StreamSource s2 = StreamSource.createSource((String)file.getName(), (String)this.rightFileRevision, (String)mimeType, (Reader)new BufferedReader(new InputStreamReader(f2.getInputStream(false), encoding)));
        MergeResultWriterInfo result = new MergeResultWriterInfo(f1, f2, f3, file, mimeType, originalLeftFileRevision, originalRightFileRevision, fo, lock, encoding);
        try {
            Component c = merge.createView(diffs, s1, s2, (StreamSource)result);
            if (c instanceof TopComponent) {
                ((TopComponent)c).putClientProperty((Object)ResolveConflictsExecutor.class.getName(), (Object)Boolean.TRUE);
            }
        }
        catch (IOException ioex) {
            Subversion.LOG.log(Level.SEVERE, null, ioex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Difference[] copyParts(boolean generateDiffs, VCSFileProxy source, VCSFileProxy dest, boolean leftPart, Charset charset) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(source.getInputStream(false), charset));
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)dest), charset));
        ArrayList<Difference> diffList = null;
        if (generateDiffs) {
            diffList = new ArrayList<Difference>();
        }
        try {
            String line;
            boolean isChangeLeft = false;
            boolean isChangeRight = false;
            int f1l1 = 0;
            int f1l2 = 0;
            int f2l1 = 0;
            int f2l2 = 0;
            StringBuilder text1 = new StringBuilder();
            StringBuilder text2 = new StringBuilder();
            int i = 1;
            int j = 1;
            while ((line = r.readLine()) != null) {
                String lineText;
                if (line.startsWith(CHANGE_LEFT)) {
                    if (isChangeLeft || isChangeRight) {
                        throw new IOException(NESTED_CONFLICT);
                    }
                    if (generateDiffs) {
                        if (this.leftFileRevision == null) {
                            this.leftFileRevision = line.substring(CHANGE_LEFT.length());
                        }
                        f1l1 = i;
                    }
                    isChangeLeft = !isChangeLeft;
                    continue;
                }
                if (line.startsWith(CHANGE_RIGHT)) {
                    if (generateDiffs) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = line.substring(CHANGE_RIGHT.length());
                        }
                        if (isChangeRight) {
                            f2l2 = j - 1;
                            diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                            f2l2 = 0;
                            f2l1 = 0;
                            f1l2 = 0;
                            f1l1 = 0;
                            text1.delete(0, text1.length());
                            text2.delete(0, text2.length());
                        } else {
                            f2l1 = j;
                        }
                    }
                    isChangeRight = !isChangeRight;
                    continue;
                }
                if (isChangeRight && line.indexOf(CHANGE_RIGHT) != -1) {
                    lineText = line.substring(0, line.lastIndexOf(CHANGE_RIGHT));
                    if (generateDiffs) {
                        if (this.rightFileRevision == null) {
                            this.rightFileRevision = line.substring(line.lastIndexOf(CHANGE_RIGHT) + CHANGE_RIGHT.length());
                        }
                        text2.append(lineText);
                        f2l2 = j;
                        diffList.add(f1l1 > f1l2 ? new Difference(1, f1l1 - 1, 0, f2l1, f2l2, text1.toString(), text2.toString()) : (f2l1 > f2l2 ? new Difference(0, f1l1, f1l2, f2l1 - 1, 0, text1.toString(), text2.toString()) : new Difference(2, f1l1, f1l2, f2l1, f2l2, text1.toString(), text2.toString())));
                        f2l2 = 0;
                        f2l1 = 0;
                        f1l2 = 0;
                        f1l1 = 0;
                        text1.delete(0, text1.length());
                        text2.delete(0, text2.length());
                    }
                    if (!leftPart) {
                        w.write(lineText);
                        w.newLine();
                    }
                    isChangeRight = !isChangeRight;
                    continue;
                }
                if (line.equals(CHANGE_DELIMETER)) {
                    if (isChangeLeft) {
                        isChangeLeft = false;
                        isChangeRight = true;
                        f1l2 = i - 1;
                        f2l1 = j;
                        continue;
                    }
                    if (isChangeRight) {
                        isChangeRight = false;
                        isChangeLeft = true;
                        f2l2 = j - 1;
                        f1l1 = i;
                        continue;
                    }
                } else if (line.endsWith(CHANGE_DELIMETER) && !line.endsWith(CHANGE_DELIMETER + CHANGE_DELIMETER.charAt(0))) {
                    lineText = line.substring(0, line.length() - CHANGE_DELIMETER.length()) + "\n";
                    if (isChangeLeft) {
                        text1.append(lineText);
                        if (leftPart) {
                            w.write(lineText);
                            w.newLine();
                        }
                        isChangeLeft = false;
                        isChangeRight = true;
                        f1l2 = i;
                        f2l1 = j;
                        continue;
                    }
                    if (!isChangeRight) continue;
                    text2.append(lineText);
                    if (!leftPart) {
                        w.write(lineText);
                        w.newLine();
                    }
                    isChangeRight = false;
                    isChangeLeft = true;
                    f2l2 = j;
                    f1l1 = i;
                    continue;
                }
                if (!isChangeLeft && !isChangeRight || leftPart == isChangeLeft) {
                    w.write(line);
                    w.newLine();
                }
                if (isChangeLeft) {
                    text1.append(line).append("\n");
                }
                if (isChangeRight) {
                    text2.append(line).append("\n");
                }
                if (!generateDiffs) continue;
                if (isChangeLeft) {
                    ++i;
                    continue;
                }
                if (isChangeRight) {
                    ++j;
                    continue;
                }
                ++i;
                ++j;
            }
        }
        finally {
            try {
                r.close();
            }
            finally {
                w.close();
            }
        }
        if (generateDiffs) {
            return diffList.toArray(new Difference[diffList.size()]);
        }
        return null;
    }

    @Override
    public void perform() {
        this.exec();
    }

    @Override
    public void run() {
        throw new RuntimeException("Not implemented");
    }

    private static class MergeConflictFileWriter
    extends FilterWriter {
        private final Difference[] conflicts;
        private int lineNumber;
        private int currentConflict;
        private final String leftName;
        private final String rightName;
        private final FileObject fo;

        public MergeConflictFileWriter(Writer delegate, FileObject fo, Difference[] conflicts, String leftName, String rightName) throws IOException {
            super(delegate);
            this.conflicts = conflicts;
            this.leftName = leftName;
            this.rightName = rightName;
            this.lineNumber = 1;
            this.currentConflict = 0;
            if (this.lineNumber == conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
            this.fo = fo;
        }

        @Override
        public void write(String str) throws IOException {
            super.write(str);
            this.lineNumber += MergeConflictFileWriter.numChars('\n', str);
            if (this.currentConflict < this.conflicts.length && this.lineNumber >= this.conflicts[this.currentConflict].getFirstStart()) {
                this.writeConflict(this.conflicts[this.currentConflict]);
                ++this.currentConflict;
            }
        }

        private void writeConflict(Difference conflict) throws IOException {
            super.write(ResolveConflictsExecutor.CHANGE_LEFT + this.leftName + "\n");
            super.write(conflict.getFirstText());
            super.write("=======\n");
            super.write(conflict.getSecondText());
            super.write(ResolveConflictsExecutor.CHANGE_RIGHT + this.rightName + "\n");
        }

        private static int numChars(char c, String str) {
            int n = 0;
            int pos = str.indexOf(c);
            while (pos >= 0 && pos < str.length()) {
                ++n;
                pos = str.indexOf(c, pos + 1);
            }
            return n;
        }

        @Override
        public void close() throws IOException {
            super.close();
            if (this.fo != null) {
                this.fo.refresh(true);
            }
        }
    }

    private static class MergeResultWriterInfo
    extends StreamSource {
        private final VCSFileProxy tempf1;
        private final VCSFileProxy tempf2;
        private final VCSFileProxy tempf3;
        private final VCSFileProxy outputFile;
        private VCSFileProxy fileToRepairEntriesOf;
        private final String mimeType;
        private final String leftFileRevision;
        private final String rightFileRevision;
        private FileObject fo;
        private FileLock lock;
        private final Charset encoding;

        public MergeResultWriterInfo(VCSFileProxy tempf1, VCSFileProxy tempf2, VCSFileProxy tempf3, VCSFileProxy outputFile, String mimeType, String leftFileRevision, String rightFileRevision, FileObject fo, FileLock lock, Charset encoding) {
            this.tempf1 = tempf1;
            this.tempf2 = tempf2;
            this.tempf3 = tempf3;
            this.outputFile = outputFile;
            this.mimeType = mimeType;
            this.leftFileRevision = leftFileRevision;
            this.rightFileRevision = rightFileRevision;
            this.fo = fo;
            this.lock = lock;
            if (encoding == null) {
                encoding = FileEncodingQuery.getEncoding((FileObject)tempf1.toFileObject());
            }
            this.encoding = encoding;
        }

        public String getName() {
            return this.outputFile.getName();
        }

        public String getTitle() {
            return NbBundle.getMessage(ResolveConflictsExecutor.class, (String)"Merge.titleResult");
        }

        public String getMIMEType() {
            return this.mimeType;
        }

        public Reader createReader() throws IOException {
            throw new IOException("No reader of merge result");
        }

        public Writer createWriter(Difference[] conflicts) throws IOException {
            OutputStreamWriter w = this.fo != null ? new OutputStreamWriter(this.fo.getOutputStream(this.lock), this.encoding) : new OutputStreamWriter(VCSFileProxySupport.getOutputStream((VCSFileProxy)this.outputFile), this.encoding);
            if (conflicts == null || conflicts.length == 0) {
                this.fileToRepairEntriesOf = this.outputFile;
                return w;
            }
            return new MergeConflictFileWriter(w, this.fo, conflicts, this.leftFileRevision, this.rightFileRevision);
        }

        public void close() {
            VCSFileProxySupport.delete((VCSFileProxy)this.tempf1);
            VCSFileProxySupport.delete((VCSFileProxy)this.tempf2);
            VCSFileProxySupport.delete((VCSFileProxy)this.tempf3);
            if (this.lock != null) {
                this.lock.releaseLock();
                this.lock = null;
            }
            this.fo = null;
            if (this.fileToRepairEntriesOf != null) {
                this.repairEntries(this.fileToRepairEntriesOf);
                this.fileToRepairEntriesOf = null;
            }
        }

        private void repairEntries(VCSFileProxy file) {
            try {
                ConflictResolvedAction.perform(file);
            }
            catch (SVNClientException ex) {
                SvnClientExceptionHandler.notifyException(new Context(file), ex, true, true);
            }
        }
    }
}

