/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.parsing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.modules.cnd.modelui.parsing.ParsingProblemDetectorImpl;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ParsingProblemResolver
extends JPanel {
    private final ParsingProblemDetectorImpl detector;
    private JPanel chartPanel;
    private JTextPane explanation;
    private JScrollPane jScrollPane1;

    public ParsingProblemResolver(ParsingProblemDetectorImpl detector) {
        this.initComponents();
        this.detector = detector;
        if (!ParsingProblemDetectorImpl.TIMING) {
            this.remove(this.chartPanel);
        } else {
            ((ChartPanel)this.chartPanel).setModel(detector);
        }
        this.explanation.setEditorKit(new HTMLEditorKit());
        this.explanation.setBackground(this.getBackground());
        this.explanation.setForeground(this.getForeground());
        this.explanation.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.explanation.setText(NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Explanation"));
    }

    public static void showParsingProblemResolver(final ParsingProblemDetectorImpl detector) {
        ActionListener onClickAction = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                ParsingProblemResolver panel = new ParsingProblemResolver(detector);
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Dialog_Title"), true, new Object[]{DialogDescriptor.CLOSED_OPTION}, DialogDescriptor.CLOSED_OPTION, 0, null, null);
                Dialog dlg = DialogDisplayer.getDefault().createDialog(descriptor);
                try {
                    dlg.setVisible(true);
                }
                catch (Throwable th) {
                    if (!(th.getCause() instanceof InterruptedException)) {
                        throw new RuntimeException(th);
                    }
                    descriptor.setValue(DialogDescriptor.CANCEL_OPTION);
                }
                finally {
                    dlg.dispose();
                }
            }
        };
        String title = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Dialog_Short_Title");
        ImageIcon icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/modelui/parsing/exclamation.gif", (boolean)false);
        Notification notification = NotificationDisplayer.getDefault().notify(title, (Icon)icon, NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Dialog_Action"), onClickAction, NotificationDisplayer.Priority.HIGH);
    }

    private void initComponents() {
        this.chartPanel = new ChartPanel();
        this.jScrollPane1 = new JScrollPane();
        this.explanation = new JTextPane();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 1, 6));
        this.setLayout(new BorderLayout());
        this.chartPanel.setPreferredSize(new Dimension(500, 200));
        GroupLayout chartPanelLayout = new GroupLayout(this.chartPanel);
        this.chartPanel.setLayout(chartPanelLayout);
        chartPanelLayout.setHorizontalGroup(chartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 448, Short.MAX_VALUE));
        chartPanelLayout.setVerticalGroup(chartPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 200, Short.MAX_VALUE));
        this.add((Component)this.chartPanel, "North");
        this.jScrollPane1.setPreferredSize(new Dimension(500, 200));
        this.explanation.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 6));
        this.explanation.setEditable(false);
        this.jScrollPane1.setViewportView(this.explanation);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private static final class ChartPanel
    extends JPanel {
        private ParsingProblemDetectorImpl detector;
        private static final int shift = 10;
        private static final int tick = 3;
        private static final String Y_memory_units = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Y_memory_units");
        private static final String Y_speed_units = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"Y_speed_units");
        private static final String X_units = NbBundle.getMessage(ParsingProblemDetectorImpl.class, (String)"X_units");

        private ChartPanel() {
        }

        private void setModel(ParsingProblemDetectorImpl detector) {
            this.detector = detector;
        }

        @Override
        public void paint(Graphics g) {
            List<ParsingProblemDetectorImpl.Measure> data;
            if (this.detector == null) {
                super.paint(g);
            }
            if ((data = this.detector.getData()).size() < 10) {
                super.paint(g);
            }
            this.paintScale(g);
            this.paintMemory(data, g);
            this.paintSpeed(data, g);
        }

        private void paintScale(Graphics g) {
            int h = this.getHeight();
            int w = this.getWidth();
            g.drawLine(10, h - 10, 10, 7);
            g.drawLine(7, 10, 13, 10);
            g.drawLine(10, h - 10, w - 10 + 3, h - 10);
            g.drawLine(w - 10, h - 10 - 3, w - 10, h - 10 + 3);
        }

        private void paintMemory(List<ParsingProblemDetectorImpl.Measure> data, Graphics g) {
            ParsingProblemDetectorImpl.Measure last = data.get(data.size() - 1);
            int allTime = last.time;
            int h = this.getHeight();
            int w = this.getWidth();
            Color prevColor = g.getColor();
            g.setColor(Color.red);
            int xPrev = (int)((double)data.get((int)0).time / (double)allTime * (double)(w - 20)) + 10;
            int myPrev = (int)((double)data.get((int)0).memory / (double)this.detector.maxMemory * (double)(h - 20)) + 10;
            for (int i = 1; i < data.size(); ++i) {
                ParsingProblemDetectorImpl.Measure m = data.get(i);
                int x = (int)((double)m.time / (double)allTime * (double)(w - 20)) + 10;
                int my = (int)((double)m.memory / (double)this.detector.maxMemory * (double)(h - 20)) + 10;
                g.drawLine(xPrev, h - myPrev, x, h - my);
                myPrev = my;
                xPrev = x;
            }
            FontMetrics fontMetrics = g.getFontMetrics();
            g.drawString("" + this.detector.maxMemory + " " + Y_memory_units, 13, 10 + fontMetrics.getHeight() / 2);
            g.setColor(prevColor);
        }

        private void paintSpeed(List<ParsingProblemDetectorImpl.Measure> data, Graphics g) {
            ParsingProblemDetectorImpl.Measure last = data.get(data.size() - 1);
            int allTime = last.time;
            int allLine = last.lines;
            int h = this.getHeight();
            int w = this.getWidth();
            Color prevColor = g.getColor();
            int fragment = 5;
            int currentPercent = 1;
            int curentTime = 0;
            int curentLines = 0;
            int maxSpeed = 0;
            for (ParsingProblemDetectorImpl.Measure m : data) {
                int p = m.lines * 100 / allLine;
                if (p - currentPercent * fragment < 0) continue;
                int l = m.lines - curentLines;
                curentLines = m.lines;
                int t = m.time - curentTime;
                curentTime = m.time;
                ++currentPercent;
                if (t == 0) continue;
                maxSpeed = Math.max(maxSpeed, l * 1000 / t);
            }
            g.setColor(Color.blue);
            currentPercent = 1;
            curentTime = 0;
            curentLines = 0;
            int xPrev = 10;
            int syPrev = 10;
            for (ParsingProblemDetectorImpl.Measure m : data) {
                int p = m.lines * 100 / allLine;
                if (p - currentPercent * fragment < 0) continue;
                int l = m.lines - curentLines;
                curentLines = m.lines;
                int t = m.time - curentTime;
                curentTime = m.time;
                ++currentPercent;
                if (t == 0) continue;
                int currSpeed = l * 1000 / t;
                int x = (int)((double)m.time / (double)allTime * (double)(w - 20)) + 10;
                int sy = (int)((double)currSpeed / (double)maxSpeed * (double)(h - 20)) + 10;
                g.drawLine(xPrev, h - syPrev, x, h - sy);
                syPrev = sy;
                xPrev = x;
            }
            FontMetrics fontMetrics = g.getFontMetrics();
            g.drawString("" + maxSpeed / 1000 + " " + Y_speed_units, 13, 10 + fontMetrics.getHeight() + fontMetrics.getHeight() / 2);
            g.setColor(prevColor);
            String time = "" + allTime / 1000 + " " + X_units;
            int len = fontMetrics.stringWidth(time);
            g.drawString(time, w - 10 - len, h - 10 - 3);
        }
    }
}

