/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelui.trace;

import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.trace.CodeModelDiagnostic;
import org.netbeans.modules.cnd.modelui.trace.TestProjectActionBase;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class TestFileContainerAction
extends TestProjectActionBase {
    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_TestFileContainerAction");
    }

    @Override
    protected void performAction(Collection<CsmProject> csmProjects) {
        if (csmProjects != null && !csmProjects.isEmpty()) {
            this.testFileContainer(csmProjects);
        }
    }

    public boolean isEnabled() {
        return true;
    }

    private void testFileContainer(Collection<CsmProject> projects) {
        for (CsmProject p : projects) {
            this.testFileContainer(p);
        }
    }

    private void testFileContainer(CsmProject project) {
        InputOutput io = IOProvider.getDefault().getIO("file container for " + project.getName(), false);
        io.select();
        OutputWriter out = io.getOut();
        CodeModelDiagnostic.dumpFileContainer((CsmProject)project, (OutputWriter)out);
        for (CsmProject lib : project.getLibraries()) {
            CodeModelDiagnostic.dumpFileContainer((CsmProject)lib, (OutputWriter)out);
        }
        out.close();
    }
}

