/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.clank;

import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.ClankDriver;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.SystemMacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;

public final class MacroReference
extends OffsetableBase
implements CsmReference {
    private final CsmMacro referencedMacro;

    static MacroReference createMacroReference(FileImpl curFile, int startOffset, int endOffset, FileImpl startFile, ClankDriver.ClankMacroDirective directive) {
        SystemMacroImpl referencedMacro;
        CharSequence macroName = directive.getMacroName();
        if (CharSequenceUtilities.equals((CharSequence)ClankDriver.ClankMacroDirective.BUILD_IN_FILE, (Object)directive.getFile())) {
            CharSequence body = MacroReference.findBody(startFile, macroName);
            if (body == null) {
                body = CharSequences.comparator().compare("__FILE__", macroName) == 0 ? curFile.getAbsolutePath() : (CharSequences.comparator().compare("__LINE__", macroName) == 0 ? "" + curFile.getLineColumn(startOffset)[0] : (CharSequences.comparator().compare("__DATE__", macroName) == 0 ? "" : (CharSequences.comparator().compare("__TIME__", macroName) == 0 ? "" : (CharSequences.comparator().compare("__FUNCTION__", macroName) == 0 ? "" : ""))));
            }
            referencedMacro = SystemMacroImpl.create(macroName, body, directive.getParameters(), startFile, MacroReference.findType(startFile, macroName));
        } else {
            CsmFile targetFile = MacroReference.getTargetFile(startFile, directive.getFile());
            if (targetFile == null) {
                if (curFile.isValid() && CsmModelAccessor.isModelAlive() && (TraceFlags.REPORT_PARSING_ERRORS || CndUtils.isUnitTestMode())) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)("Can not resolve file by path in macro directive: [" + directive + "] used at [" + startOffset + "-" + endOffset + "] in file [" + curFile + " valid=" + curFile.isValid() + "] included from [" + startFile + " valid=" + startFile.isValid() + "]"));
                }
                return null;
            }
            referencedMacro = MacroImpl.create(macroName, directive.getParameters(), "", targetFile, directive.getDirectiveStartOffset(), directive.getDirectiveEndOffset(), CsmMacro.Kind.DEFINED);
        }
        return new MacroReference(curFile, startOffset, endOffset, referencedMacro);
    }

    public static CsmMacro.Kind findType(FileImpl startFile, CharSequence macroName) {
        CsmMacro.Kind res = CsmMacro.Kind.COMPILER_PREDEFINED;
        NativeFileItem item = startFile.getNativeFileItem();
        if (item != null) {
            for (String m : item.getUserMacroDefinitions()) {
                if (!CharSequenceUtilities.startsWith((CharSequence)m, (CharSequence)macroName)) continue;
                res = CsmMacro.Kind.USER_SPECIFIED;
                break;
            }
        }
        return res;
    }

    public static CharSequence findBody(FileImpl startFile, CharSequence macroName) {
        CharSequence res = null;
        NativeFileItem item = startFile.getNativeFileItem();
        if (item != null) {
            for (String m : item.getSystemMacroDefinitions()) {
                res = MacroReference.extractBody(macroName, m, res);
            }
            for (String m : item.getUserMacroDefinitions()) {
                res = MacroReference.extractBody(macroName, m, res);
            }
        }
        return res;
    }

    private static CharSequence extractBody(CharSequence macroName, String candidate, CharSequence res) {
        if (CharSequenceUtilities.startsWith((CharSequence)candidate, (CharSequence)macroName)) {
            boolean parmList = false;
            for (int i = macroName.length(); i < candidate.length(); ++i) {
                char c = candidate.charAt(i);
                if (c == '(') {
                    parmList = true;
                    continue;
                }
                if (c == ')') {
                    parmList = false;
                    continue;
                }
                if (parmList) continue;
                if (c == '=') {
                    res = candidate.substring(i + 1);
                    break;
                }
                if (c != ' ') break;
            }
        }
        return res;
    }

    private MacroReference(FileImpl curFile, int startOffset, int endOffset, CsmMacro referencedMacro) {
        super(curFile, startOffset, endOffset);
        this.referencedMacro = referencedMacro;
    }

    public CsmObject getReferencedObject() {
        return this.referencedMacro;
    }

    public CsmObject getOwner() {
        return null;
    }

    public CsmReferenceKind getKind() {
        return CsmReferenceKind.DIRECT_USAGE;
    }

    @Override
    public CharSequence getText() {
        return this.referencedMacro.getName();
    }

    public CsmObject getClosestTopLevelObject() {
        return this.getContainingFile();
    }

    static CsmFile getTargetFile(FileImpl current, CharSequence macroContainerFile) {
        CsmFile target = null;
        if (current != null && macroContainerFile.length() > 0) {
            FileSystem fs;
            ProjectBase currentPrj = (ProjectBase)current.getProject();
            ProjectBase targetPrj = currentPrj.findFileProject(macroContainerFile, true);
            if (targetPrj != null) {
                target = targetPrj.findFile(macroContainerFile, true, false);
                fs = targetPrj.getFileSystem();
            } else {
                fs = currentPrj.getFileSystem();
            }
            if (target == null) {
                target = CsmModelAccessor.getModel().findFile(new FSPath(fs, macroContainerFile.toString()), false, false);
            }
        }
        return target;
    }
}

