/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.spi;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.spi.CndTextIndexFilter;
import org.netbeans.modules.cnd.indexing.api.CndTextIndex;
import org.netbeans.modules.cnd.indexing.api.CndTextIndexKey;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.impl.services.FileInfoQueryImpl;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTTokenStreamProducer;
import org.netbeans.modules.cnd.modelimpl.parser.clank.ClankTokenStreamProducer;
import org.netbeans.modules.cnd.support.Interrupter;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;

public abstract class TokenStreamProducer {
    private PreprocHandler curPreprocHandler;
    private PreprocHandler.State curPreprocHandlerStartState;
    private FileImpl startFile;
    private String language = "Gnu C++ Language";
    private String languageFlavor = "";
    private final FileImpl fileImpl;
    private final FileContent fileContent;
    private boolean allowToCacheOnRelease;
    private CodePatch codePatch;
    private final boolean fromEnsureParsed;

    protected TokenStreamProducer(FileImpl fileImpl, FileContent newFileContent, boolean fromEnsureParsed) {
        assert (fileImpl != null) : "null file is not allowed";
        assert (newFileContent != null) : "null file content is not allowed";
        this.fileImpl = fileImpl;
        this.fileContent = newFileContent;
        this.fromEnsureParsed = fromEnsureParsed;
    }

    public static TokenStreamProducer create(FileImpl file, boolean emptyFileContent, boolean fromEnsureParsed) {
        FileContent newFileContent = FileContent.getHardReferenceBasedCopy(file.getCurrentFileContent(), emptyFileContent);
        if (fromEnsureParsed) {
            TokenStreamProducer.indexFileContent(file);
        }
        if (APTTraceFlags.USE_CLANK) {
            return ClankTokenStreamProducer.createImpl(file, newFileContent, fromEnsureParsed);
        }
        return APTTokenStreamProducer.createImpl(file, newFileContent, fromEnsureParsed);
    }

    public abstract TokenStream getTokenStreamOfIncludedFile(PreprocHandler.State var1, CsmInclude var2, Interrupter var3);

    public abstract TokenStream getTokenStreamForParsingAndCaching(Interrupter var1);

    public abstract TokenStream getTokenStreamForParsing(String var1, Interrupter var2);

    public abstract TokenStream getTokenStreamForCaching(Interrupter var1);

    public abstract FilePreprocessorConditionState release();

    public void prepare(PreprocHandler handler, String language, String languageFlavor, boolean allowToCacheOnRelease) {
        assert (handler != null) : "null preprocHandler is not allowed";
        this.curPreprocHandler = handler;
        this.curPreprocHandlerStartState = handler.getState();
        this.startFile = Utils.getStartFile(handler.getState());
        assert (language != null) : "null language is not allowed";
        this.language = language;
        assert (languageFlavor != null) : "null language flavor is not allowed";
        this.languageFlavor = languageFlavor;
        this.allowToCacheOnRelease = allowToCacheOnRelease;
    }

    public PreprocHandler getCurrentPreprocHandler() {
        return this.curPreprocHandler;
    }

    public PreprocHandler.State getPreprocHandlerStartState() {
        return this.curPreprocHandlerStartState;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getLanguageFlavor() {
        return this.languageFlavor;
    }

    public FileImpl getInterestedFile() {
        return this.fileImpl;
    }

    protected FileImpl getStartFile() {
        if (this.startFile != null) {
            return this.startFile;
        }
        return this.fileImpl;
    }

    public FileContent getFileContent() {
        assert (this.fileContent != null);
        return this.fileContent;
    }

    protected final boolean isAllowedToCacheOnRelease() {
        return this.allowToCacheOnRelease;
    }

    protected final boolean isFromEnsureParsed() {
        return this.fromEnsureParsed;
    }

    protected CodePatch getCodePatch() {
        return this.codePatch;
    }

    protected void resetHandler(PreprocHandler ppHandler) {
        this.curPreprocHandler = ppHandler;
        this.curPreprocHandlerStartState = ppHandler.getState();
    }

    public void setCodePatch(CodePatch codePatch) {
        this.codePatch = codePatch;
    }

    private static void indexFileContent(FileImpl file) {
        TokenSequence<?> tsToIndex = TokenStreamProducer.createFileTokenSequence(file);
        if (tsToIndex == null) {
            assert (!file.isValid()) : "must have token stream for valid files";
            return;
        }
        CndTextIndexFilter[] extraIndexFilters = TokenStreamProducer.getExtraTextIndexFilters(file);
        assert (extraIndexFilters != null);
        HashSet<CharSequence> ids = new HashSet<CharSequence>(1024);
        TokenStreamProducer.indexFileTokens(tsToIndex, extraIndexFilters, ids);
        CndTextIndex.put((CndTextIndexKey)file.getTextIndexKey(), ids);
    }

    private static TokenSequence<?> createFileTokenSequence(FileImpl file) {
        Set<TokenId> mergedSkippedTokens;
        Language<TokenId> language;
        char[] charBuffer;
        FileBuffer buffer = file.getBuffer();
        if (buffer == null) {
            return null;
        }
        try {
            charBuffer = buffer.getCharBuffer();
        }
        catch (IOException ex) {
            return null;
        }
        if ("Fortran Language".equals(file.getFileLanguage())) {
            language = FortranSkippedTokensPool.LANGUAGE;
            mergedSkippedTokens = FortranSkippedTokensPool.SKIP_TOKENS;
        } else {
            language = CppSkippedTokensPool.LANGUAGE;
            mergedSkippedTokens = CppSkippedTokensPool.SKIP_TOKENS;
        }
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)new CharBufferChars(charBuffer), (boolean)false, language, mergedSkippedTokens, null);
        return hi.tokenSequence();
    }

    private static void indexFileTokens(TokenSequence<?> expTS, CndTextIndexFilter[] indexFilters, Set<CharSequence> ids) {
        if (expTS != null) {
            expTS.moveStart();
            while (expTS.moveNext()) {
                Token expToken = expTS.token();
                if (expToken.id() == CppTokenId.PREPROCESSOR_DIRECTIVE) {
                    TokenStreamProducer.indexFileTokens(expTS.embedded(), indexFilters, ids);
                    continue;
                }
                String primaryCategory = expToken.id().primaryCategory();
                if ("identifier".equals(primaryCategory) || "preprocessor-identifier".equals(primaryCategory) || "keyword".equals(primaryCategory)) {
                    ids.add(expToken.text().toString());
                }
                if (indexFilters.length <= 0 || !"string".equals(primaryCategory)) continue;
                for (CndTextIndexFilter filter : indexFilters) {
                    CharSequence indexText = filter.getStringIndexText(expToken.text());
                    if (indexText == null) continue;
                    ids.add(indexText.toString());
                }
            }
        }
    }

    private static CndTextIndexFilter[] getExtraTextIndexFilters(FileImpl file) {
        Lookup.Provider project;
        Collection<Object> extraIndexFilters = Collections.emptyList();
        Object pp = file.getProject().getPlatformProject();
        if (pp instanceof NativeProject && (project = ((NativeProject)pp).getProject()) != null) {
            extraIndexFilters = project.getLookup().lookupAll(CndTextIndexFilter.class);
        }
        CndTextIndexFilter[] indexFilters = new CndTextIndexFilter[extraIndexFilters.size()];
        int i = 0;
        Iterator iterator = extraIndexFilters.iterator();
        while (iterator.hasNext()) {
            CndTextIndexFilter f;
            indexFilters[i] = f = (CndTextIndexFilter)iterator.next();
            ++i;
        }
        return indexFilters;
    }

    public static PPIncludeHandler.IncludeInfo createIncludeInfo(CsmInclude include) {
        FileImpl includedFile = (FileImpl)include.getIncludeFile();
        if (includedFile == null) {
            return null;
        }
        FileSystem fileSystem = includedFile.getFileSystem();
        if (fileSystem == null) {
            return null;
        }
        CharSequence includedAbsPath = includedFile.getAbsolutePath();
        int includeDirFileIndex = FileInfoQueryImpl.getIncludeDirectiveIndex(include);
        if (includeDirFileIndex < 0) {
            return null;
        }
        return new IncludeInfoImpl(include, fileSystem, includedAbsPath, includeDirFileIndex);
    }

    private static final class IncludeInfoImpl
    implements PPIncludeHandler.IncludeInfo {
        private final int line;
        private final CsmInclude include;
        private final FileSystem fs;
        private final CharSequence path;
        private final int includedDirectiveIndex;

        private IncludeInfoImpl(CsmInclude include, FileSystem fs, CharSequence path, int includedDirectiveIndex) {
            this.line = include.getStartPosition().getLine();
            this.include = include;
            this.fs = fs;
            this.path = path;
            this.includedDirectiveIndex = includedDirectiveIndex;
        }

        public CharSequence getIncludedPath() {
            return this.path;
        }

        public FileSystem getFileSystem() {
            return this.fs;
        }

        public int getIncludeDirectiveLine() {
            return this.line;
        }

        public int getIncludeDirectiveOffset() {
            return this.include.getStartOffset();
        }

        public int getResolvedDirectoryIndex() {
            return 0;
        }

        public String toString() {
            return "restore " + this.include + " #" + this.includedDirectiveIndex + " from line " + this.line + " in file " + this.include.getContainingFile();
        }

        public int getIncludeDirectiveIndex() {
            return this.includedDirectiveIndex;
        }
    }

    private static final class CharBufferChars
    implements CharSequence {
        private final char[] buffer;
        private final int firstIndex;
        private final int length;

        public CharBufferChars(char[] charBuffer) {
            this(charBuffer, 0, charBuffer.length);
        }

        private CharBufferChars(char[] charBuffer, int firstInclusiveIndex, int lastExclusiveIndex) {
            assert (charBuffer != null);
            this.buffer = charBuffer;
            this.firstIndex = firstInclusiveIndex;
            this.length = lastExclusiveIndex - firstInclusiveIndex;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public char charAt(int index) {
            return this.buffer[index];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CharBufferChars(this.buffer, start, end);
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Arrays.hashCode(this.buffer);
            hash = 97 * hash + this.firstIndex;
            hash = 97 * hash + this.length;
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CharBufferChars other = (CharBufferChars)obj;
            if (this.firstIndex != other.firstIndex) {
                return false;
            }
            if (this.length != other.length) {
                return false;
            }
            return Arrays.equals(this.buffer, other.buffer);
        }

        @Override
        public String toString() {
            return new String(this.buffer, this.firstIndex, this.length);
        }
    }

    private static final class FortranSkippedTokensPool {
        static final Set<TokenId> SKIP_TOKENS;
        static final Language<TokenId> LANGUAGE;

        private FortranSkippedTokensPool() {
        }

        static {
            LANGUAGE = FortranTokenId.languageFortran();
            Set skipNumTokens = LANGUAGE.tokenCategoryMembers("number");
            Set skipWSTokens = LANGUAGE.tokenCategoryMembers("whitespace");
            Set skipCommentTokens = LANGUAGE.tokenCategoryMembers("comment");
            Set skipSeparatorTokens = LANGUAGE.tokenCategoryMembers("special");
            Set skipOperatorTokens = LANGUAGE.tokenCategoryMembers("operator");
            Set skipKwdOperatorTokens = LANGUAGE.tokenCategoryMembers("keyword-operator");
            SKIP_TOKENS = LANGUAGE.merge((Collection)skipNumTokens, (Collection)LANGUAGE.merge((Collection)skipWSTokens, (Collection)LANGUAGE.merge((Collection)skipCommentTokens, (Collection)LANGUAGE.merge((Collection)skipSeparatorTokens, (Collection)LANGUAGE.merge((Collection)skipOperatorTokens, (Collection)skipKwdOperatorTokens)))));
        }
    }

    private static final class CppSkippedTokensPool {
        static final Set<TokenId> SKIP_TOKENS;
        static final Language<TokenId> LANGUAGE;

        private CppSkippedTokensPool() {
        }

        static {
            LANGUAGE = CppTokenId.languageCpp();
            Set skipNumTokens = LANGUAGE.tokenCategoryMembers("number");
            Set skipWSTokens = LANGUAGE.tokenCategoryMembers("whitespace");
            Set skipCommentTokens = LANGUAGE.tokenCategoryMembers("comment");
            Set skipSeparatorTokens = LANGUAGE.tokenCategoryMembers("separator");
            Set skipOperatorTokens = LANGUAGE.tokenCategoryMembers("operator");
            SKIP_TOKENS = LANGUAGE.merge((Collection)skipNumTokens, (Collection)LANGUAGE.merge((Collection)skipWSTokens, (Collection)LANGUAGE.merge((Collection)skipCommentTokens, (Collection)LANGUAGE.merge((Collection)skipSeparatorTokens, (Collection)skipOperatorTokens))));
        }
    }

    public static final class CodePatch {
        private final int startOffset;
        private final int endOffset;
        private final String patch;

        public CodePatch(int startOffset, int endOffset, String patch) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.patch = patch;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }

        public String getPatch() {
            return this.patch;
        }
    }
}

