/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.api.project.NativeProjectSettings;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.modelimpl.accessors.CsmCorePackageAccessor;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBufferFile;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.memory.LowMemoryEvent;
import org.netbeans.modules.cnd.modelimpl.platform.CsmEventDispatcher;
import org.netbeans.modules.cnd.modelimpl.platform.ExternalUpdateListener;
import org.netbeans.modules.cnd.modelimpl.platform.FileBufferDoc;
import org.netbeans.modules.cnd.modelimpl.spi.LowMemoryAlerter;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.SuspendableFileChangeListener;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class ModelSupport
implements PropertyChangeListener {
    private static final AtomicBoolean hasOpenedProjects = new AtomicBoolean(false);
    private static final ModelSupport instance = new ModelSupport();
    private volatile ModelImpl theModel;
    private final Set<Lookup.Provider> openedProjects = new HashSet<Lookup.Provider>();
    final ModifiedObjectsChangeListener modifiedListener = TraceFlags.USE_PARSER_API ? null : new ModifiedObjectsChangeListener();
    private SuspendableFileChangeListener fileChangeListener;
    private static final boolean TRACE_STARTUP = Boolean.getBoolean("cnd.modelsupport.startup.trace");
    private volatile boolean postponeParse = false;
    private final RequestProcessor.Task openProjectsTask = new RequestProcessor("ModelSupport processor", 1).create(new Runnable(){

        @Override
        public void run() {
            ModelSupport.this.openProjectsIfNeeded();
        }
    });
    private final Map<DataObject, Collection<BufAndProj>> buffers = new ConcurrentHashMap<DataObject, Collection<BufAndProj>>();

    private ModelSupport() {
    }

    public static ModelSupport instance() {
        return instance;
    }

    public static int getTabSize() {
        return 8;
    }

    public ModelImpl getModel() {
        return this.theModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setModel(ModelImpl model) {
        this.theModel = model;
        ModelSupport modelSupport = this;
        synchronized (modelSupport) {
            if (TraceFlags.MERGE_EVENTS) {
                if (model == null) {
                    CsmEventDispatcher.getInstance().shutdown();
                } else {
                    CsmEventDispatcher.getInstance().startup();
                }
            } else {
                if (this.fileChangeListener != null) {
                    CndFileSystemProvider.removeFileChangeListener((FileChangeListener)this.fileChangeListener);
                    this.fileChangeListener = null;
                }
                if (model != null) {
                    boolean remoteOnly = CndTraceFlags.USE_INDEXING_API;
                    this.fileChangeListener = new SuspendableFileChangeListener((FileChangeListener)new ExternalUpdateListener(this), remoteOnly);
                    CndFileSystemProvider.addFileChangeListener((FileChangeListener)this.fileChangeListener);
                }
            }
        }
    }

    private static boolean getBoolean(String name, boolean result) {
        String text = System.getProperty(name);
        if (text != null) {
            result = Boolean.parseBoolean(text);
        }
        return result;
    }

    public static boolean isStandalone() {
        if ("true".equals(System.getProperty("cnd.command.line.utility"))) {
            return true;
        }
        if (ModelSupport.getBoolean("java.awt.headless", false)) {
            return true;
        }
        return !ModelSupport.class.getClassLoader().getClass().getName().startsWith("org.netbeans.");
    }

    public void startup() {
        if (!TraceFlags.USE_PARSER_API) {
            this.modifiedListener.clean();
            DataObject.getRegistry().addChangeListener((ChangeListener)this.modifiedListener);
        }
        if (!ModelSupport.isStandalone()) {
            this.openedProjects.clear();
            hasOpenedProjects.set(false);
            if (TRACE_STARTUP) {
                System.out.println("Model support: Inited");
            }
            if (TopComponent.getRegistry().getOpened().size() > 0) {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Open projects in Init");
                }
                this.postponeParse = false;
                NativeProjectRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
                this.openProjectsTask.schedule(0);
            } else {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Postpone open projects");
                }
                this.postponeParse = true;
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        if (TRACE_STARTUP) {
                            System.out.println("Model support: invoked after ready UI");
                        }
                        ModelSupport.this.postponeParse = false;
                        NativeProjectRegistry.getDefault().addPropertyChangeListener((PropertyChangeListener)ModelSupport.this);
                        ModelSupport.this.openProjectsTask.schedule(0);
                    }
                });
            }
        }
    }

    public boolean hasOpenedProjects() {
        return hasOpenedProjects.get();
    }

    public void notifyClosing() {
        ModelImpl model;
        if (!TraceFlags.USE_PARSER_API) {
            DataObject.getRegistry().removeChangeListener((ChangeListener)this.modifiedListener);
            this.modifiedListener.clean();
        }
        if ((model = this.theModel) != null) {
            CsmCorePackageAccessor.get().notifyClosing(model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ModelImpl model;
        if (!TraceFlags.USE_PARSER_API) {
            DataObject.getRegistry().removeChangeListener((ChangeListener)this.modifiedListener);
            this.modifiedListener.clean();
        }
        if ((model = this.theModel) != null) {
            CsmCorePackageAccessor.get().notifyClosing(model);
            Set<Lookup.Provider> set = this.openedProjects;
            synchronized (set) {
                while (!this.openedProjects.isEmpty()) {
                    try {
                        this.openedProjects.wait();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            hasOpenedProjects.set(false);
            model.shutdown();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        try {
            if (TRACE_STARTUP) {
                System.out.println("Model support event:" + evt.getPropertyName() + " postponeParse=" + this.postponeParse);
            }
            if ((evt.getPropertyName().equals("openNativeProject") || evt.getPropertyName().equals("closeNativeProject") || evt.getPropertyName().equals("deleteNativeProject")) && !this.postponeParse) {
                if (TRACE_STARTUP) {
                    System.out.println("Model support: Open projects on OpenProjects.PROPERTY_OPEN_PROJECTS");
                }
                this.openProjectsTask.schedule(0);
                this.closeProjectsIfNeeded(evt);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openProjectsIfNeeded() {
        Set<Lookup.Provider> set = this.openedProjects;
        synchronized (set) {
            Collection projects = NativeProjectRegistry.getDefault().getOpenProjects();
            if (TRACE_STARTUP) {
                System.out.println("Model support: openProjects size=" + projects.size() + " modelState=" + CsmModelAccessor.getModelState());
            }
            if (TRACE_STARTUP) {
                System.out.println("Model support: openProjects new=" + projects.size() + " now=" + this.openedProjects.size());
            }
            for (NativeProject project : projects) {
                Lookup.Provider makeProject = project.getProject();
                if (this.openedProjects.contains(makeProject)) continue;
                this.addProject(makeProject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeProjectsIfNeeded(PropertyChangeEvent evt) {
        Set<Lookup.Provider> set = this.openedProjects;
        synchronized (set) {
            Collection projects = NativeProjectRegistry.getDefault().getOpenProjects();
            if (TRACE_STARTUP) {
                System.out.println("Model support: closeProjects size=" + projects.size() + " modelState=" + CsmModelAccessor.getModelState());
            }
            if (TRACE_STARTUP) {
                System.out.println("Model support: closeProjects new=" + projects.size() + " now=" + this.openedProjects.size());
            }
            HashSet<Lookup.Provider> nowOpened = new HashSet<Lookup.Provider>();
            for (NativeProject project : projects) {
                Lookup.Provider makeProject = project.getProject();
                nowOpened.add(makeProject);
            }
            HashSet<Lookup.Provider> toClose = new HashSet<Lookup.Provider>();
            for (Lookup.Provider project : this.openedProjects) {
                if (nowOpened.contains(project)) continue;
                toClose.add(project);
            }
            for (Lookup.Provider project : toClose) {
                if (evt.getPropertyName().equals("deleteNativeProject")) {
                    this.closeProject(project, true);
                    continue;
                }
                this.closeProject(project, false);
            }
            hasOpenedProjects.set(!this.openedProjects.isEmpty());
            this.openedProjects.notifyAll();
        }
    }

    public static void trace(NativeFileItem nativeFile) {
        try {
            Diagnostic.trace("  native file item" + nativeFile.getAbsolutePath());
            Diagnostic.trace("    user includes: " + nativeFile.getUserIncludePaths());
            Diagnostic.trace("    user macros: " + nativeFile.getUserMacroDefinitions());
            Diagnostic.trace("    system includes: " + nativeFile.getSystemIncludePaths());
            Diagnostic.trace("    system macros: " + nativeFile.getSystemMacroDefinitions());
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public static void dumpNativeProject(NativeProject nativeProject) {
        System.err.println("\n\n\nDumping project " + nativeProject.getProjectDisplayName());
        System.err.println("\nSystem include paths");
        Iterator it = nativeProject.getSystemIncludePaths().iterator();
        while (it.hasNext()) {
            System.err.println("    " + ((IncludePath)it.next()).getFSPath().getPath());
        }
        System.err.println("\nUser include paths");
        it = nativeProject.getUserIncludePaths().iterator();
        while (it.hasNext()) {
            System.err.println("    " + ((IncludePath)it.next()).getFSPath().getPath());
        }
        System.err.println("\nSystem macros");
        it = nativeProject.getSystemMacroDefinitions().iterator();
        while (it.hasNext()) {
            System.err.println("    " + (String)it.next());
        }
        System.err.println("\nUser macros");
        it = nativeProject.getUserMacroDefinitions().iterator();
        while (it.hasNext()) {
            System.err.println("    " + (String)it.next());
        }
        ArrayList<NativeFileItem> sources = new ArrayList<NativeFileItem>();
        ArrayList<NativeFileItem> headers = new ArrayList<NativeFileItem>();
        for (NativeFileItem item : nativeProject.getAllFiles()) {
            if (item.isExcluded()) continue;
            switch (item.getLanguage()) {
                case C: 
                case CPP: 
                case FORTRAN: {
                    sources.add(item);
                    break;
                }
                case C_HEADER: {
                    headers.add(item);
                    break;
                }
            }
        }
        System.err.println("\nSources: (" + sources.size() + " files )");
        for (NativeFileItem elem : sources) {
            System.err.println(elem.getAbsolutePath());
        }
        System.err.println("\nHeaders: (" + headers.size() + " files )");
        for (NativeFileItem elem : headers) {
            System.err.println(elem.getAbsolutePath());
        }
        System.err.println("End of project dump\n\n\n");
    }

    public static NativeProject getNativeProject(Object platformProject) {
        NativeProject nativeProject;
        NativeProject nativeProject2 = nativeProject = platformProject instanceof NativeProject ? (NativeProject)platformProject : null;
        if (platformProject instanceof Project) {
            Project project = (Project)platformProject;
            nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
        }
        return nativeProject;
    }

    private String toString(Lookup.Provider project) {
        StringBuilder sb = new StringBuilder();
        ProjectInformation pi = ProjectUtils.getInformation((Project)((Project)project));
        if (pi != null) {
            sb.append(" Name=").append(pi.getName());
            sb.append(" DisplayName=").append(pi.getDisplayName());
        }
        return sb.toString();
    }

    private void addProject(final Lookup.Provider project) {
        NativeProject nativeProject;
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("### ModelSupport.addProject: " + this.toString(project));
        }
        if ((nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
            CsmModelAccessor.getModel();
            final ModelImpl model = this.theModel;
            if (model == null) {
                return;
            }
            this.openedProjects.add(project);
            hasOpenedProjects.set(true);
            if (TraceFlags.DEBUG) {
                this.dumpProjectFiles(nativeProject);
            }
            String taskName = NbBundle.getMessage(this.getClass(), (String)"MSG_CodeAssistanceInitializationTask", (Object)nativeProject.getProjectDisplayName());
            NamedRunnable task = new NamedRunnable(taskName){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void runImpl() {
                    if (!CsmModelAccessor.isModelAlive()) {
                        return;
                    }
                    ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.getName());
                    handle.start();
                    try {
                        NativeProjectSettings settings = (NativeProjectSettings)project.getLookup().lookup(NativeProjectSettings.class);
                        boolean enableModel = settings == null ? true : settings.isCodeAssistanceEnabled();
                        model.addProject(nativeProject, nativeProject.getProjectDisplayName(), enableModel);
                    }
                    finally {
                        handle.finish();
                    }
                }
            };
            nativeProject.runOnProjectReadiness(task);
        }
    }

    private void dumpProjectFiles(NativeProject nativeProject) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("+++ Sources:");
            ArrayList<NativeFileItem> sources = new ArrayList<NativeFileItem>();
            ArrayList<NativeFileItem> headers = new ArrayList<NativeFileItem>();
            for (NativeFileItem item : nativeProject.getAllFiles()) {
                if (item.isExcluded()) continue;
                switch (item.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: {
                        sources.add(item);
                        break;
                    }
                    case C_HEADER: {
                        headers.add(item);
                        break;
                    }
                }
            }
            for (NativeFileItem elem : sources) {
                ModelSupport.trace(elem);
            }
            Diagnostic.trace("+++ Headers:");
            for (NativeFileItem elem : headers) {
                ModelSupport.trace(elem);
            }
        }
    }

    private void closeProject(Lookup.Provider project, boolean isDeleted) {
        ModelImpl model;
        assert (Thread.holdsLock(this.openedProjects));
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("### ModelSupport.closeProject: " + this.toString(project));
        }
        if ((model = this.theModel) == null) {
            return;
        }
        NativeProject nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class);
        if (nativeProject != null) {
            model.closeProject(nativeProject, isDeleted);
        }
        this.openedProjects.remove(project);
    }

    private static FileBuffer createFileBuffer(DataObject dao) {
        StyledDocument doc;
        EditorCookie editor;
        FileObject fo = dao.getPrimaryFile();
        if (fo.isValid() && dao.isModified() && (editor = (EditorCookie)dao.getLookup().lookup(EditorCookie.class)) != null && (doc = editor.getDocument()) != null) {
            return new FileBufferDoc(fo, doc);
        }
        return new FileBufferFile(fo);
    }

    public static FileBuffer createFileBuffer(FileObject fo) {
        FileSystem fs;
        Parameters.notNull((CharSequence)"null file object", (Object)fo);
        if (fo.isValid()) {
            try {
                StyledDocument doc;
                EditorCookie editor;
                DataObject dao = DataObject.find((FileObject)fo);
                if (dao.isModified() && (editor = (EditorCookie)dao.getLookup().lookup(EditorCookie.class)) != null && (doc = editor.getDocument()) != null) {
                    return new FileBufferDoc(fo, doc);
                }
            }
            catch (DataObjectNotFoundException dao) {
                // empty catch block
            }
            return new FileBufferFile(fo);
        }
        try {
            fs = fo.getFileSystem();
        }
        catch (FileStateInvalidException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            fs = InvalidFileObjectSupport.getDummyFileSystem();
        }
        return new FileBufferFile(InvalidFileObjectSupport.getInvalidFileObject((FileSystem)fs, (CharSequence)fo.getPath()));
    }

    public void onMemoryLow(LowMemoryEvent event, boolean fatal) {
        LowMemoryAlerter alerter = (LowMemoryAlerter)Lookup.getDefault().lookup(LowMemoryAlerter.class);
        if (alerter != null) {
            alerter.alert(event, fatal);
        }
    }

    Collection<APTFileBuffer> getUnsavedBuffers() {
        HashSet<APTFileBuffer> res = new HashSet<APTFileBuffer>();
        for (Collection<BufAndProj> coll : this.buffers.values()) {
            for (BufAndProj bnp : coll) {
                res.add(bnp.buffer);
            }
        }
        return res;
    }

    public static void traceDataObjectRegistryStateChanged(ChangeEvent e) {
        Diagnostic.trace("state of registry changed:");
        Diagnostic.indent();
        if (e != null) {
            DataObject[] objs = DataObject.getRegistry().getModified();
            if (objs.length == 0) {
                Diagnostic.trace("all objects are saved");
            } else {
                Diagnostic.trace("set of edited objects:");
                for (int i = 0; i < objs.length; ++i) {
                    DataObject curObj = objs[i];
                    Diagnostic.trace("object " + i + ":" + curObj.getName());
                    Diagnostic.indent();
                    Diagnostic.trace("with file: " + curObj.getPrimaryFile());
                    NativeFileItemSet set = (NativeFileItemSet)curObj.getLookup().lookup(NativeFileItemSet.class);
                    if (set == null) {
                        Diagnostic.trace("NativeFileItemSet == null");
                    } else {
                        Diagnostic.trace("NativeFileItemSet:");
                        for (NativeFileItem item : set.getItems()) {
                            Diagnostic.trace("\t" + item.getNativeProject().getProjectDisplayName());
                        }
                    }
                    EditorCookie editor = (EditorCookie)curObj.getLookup().lookup(EditorCookie.class);
                    Diagnostic.trace("has editor support: " + editor);
                    StyledDocument doc = editor != null ? editor.getDocument() : null;
                    Diagnostic.trace("with document: " + doc);
                    Diagnostic.unindent();
                }
            }
        } else {
            Diagnostic.trace("no additional info from event object");
        }
        Diagnostic.unindent();
    }

    public void suspendDeleteEvents() {
        if (!TraceFlags.MERGE_EVENTS) {
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                ExternalUpdateListener.LOG.info("External updates: suspendDeleteEvents");
            }
            if (this.fileChangeListener != null) {
                this.fileChangeListener.suspendRemoves();
            }
        }
    }

    public void resumeDeleteEvents() {
        if (!TraceFlags.MERGE_EVENTS) {
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                ExternalUpdateListener.LOG.info("External updates: resumeDeleteEvents");
            }
            if (this.fileChangeListener != null) {
                this.fileChangeListener.resumeRemoves();
            }
        }
    }

    private class ModifiedObjectsChangeListener
    implements ChangeListener {
        private ModifiedObjectsChangeListener() {
        }

        private Collection<BufAndProj> getBufNP(DataObject dao) {
            Collection bufNPcoll = (Collection)ModelSupport.this.buffers.get(dao);
            return bufNPcoll == null ? Collections.emptyList() : bufNPcoll;
        }

        private void addBufNP(DataObject dao, BufAndProj bufNP) {
            ArrayList<BufAndProj> bufNPcoll = (ArrayList<BufAndProj>)ModelSupport.this.buffers.get(dao);
            if (bufNPcoll == null) {
                bufNPcoll = new ArrayList<BufAndProj>();
                ModelSupport.this.buffers.put(dao, bufNPcoll);
            }
            bufNPcoll.add(bufNP);
        }

        private void editStart(DataObject curObj) {
            block6: {
                StyledDocument doc;
                NativeFileItemSet set;
                ModelImpl model;
                block7: {
                    EditorCookie editor;
                    StyledDocument doc2;
                    model = ModelSupport.this.theModel;
                    if (model == null) {
                        return;
                    }
                    if (!curObj.isValid()) {
                        return;
                    }
                    set = (NativeFileItemSet)curObj.getLookup().lookup(NativeFileItemSet.class);
                    if (set == null) {
                        set = this.findCanonicalSet(curObj);
                    }
                    if (set == null) break block6;
                    if (!set.isEmpty()) break block7;
                    if (CndUtils.isDebugMode() || CndUtils.isUnitTestMode()) {
                        CsmFile csmFile = CsmModelAccessor.getModel().findFile(FSPath.toFSPath((FileObject)curObj.getPrimaryFile()), false, false);
                        CndUtils.assertTrueInConsole((csmFile == null ? 1 : 0) != 0, (String)"WARNING: can not switch buffer due to empty NativeFileItemSet for being edited ", (Object)csmFile);
                    }
                    StyledDocument styledDocument = doc2 = (editor = (EditorCookie)curObj.getLookup().lookup(EditorCookie.class)) != null ? editor.getDocument() : null;
                    if (doc2 == null || doc2.getProperty("cnd.refactoring.modification.event") == Boolean.TRUE) break block6;
                    FileObject primaryFile = curObj.getPrimaryFile();
                    long lastModified = primaryFile.lastModified().getTime();
                    FileBufferDoc buffer = new FileBufferDoc(primaryFile, doc2);
                    ProjectBase csmProject = (ProjectBase)CsmUtilities.getCsmProject((Document)doc2);
                    if (csmProject == null) break block6;
                    this.addBufNP(curObj, new BufAndProj(buffer, csmProject, lastModified));
                    csmProject.onFileEditStart(buffer, null);
                    break block6;
                }
                EditorCookie editor = (EditorCookie)curObj.getLookup().lookup(EditorCookie.class);
                StyledDocument styledDocument = doc = editor != null ? editor.getDocument() : null;
                if (doc != null && doc.getProperty("cnd.refactoring.modification.event") != Boolean.TRUE) {
                    FileObject primaryFile = curObj.getPrimaryFile();
                    long lastModified = primaryFile.lastModified().getTime();
                    FileBufferDoc buffer = new FileBufferDoc(primaryFile, doc);
                    for (NativeFileItem nativeFile : set.getItems()) {
                        ProjectBase csmProject = model.getProject(nativeFile.getNativeProject());
                        if (csmProject == null) continue;
                        this.addBufNP(curObj, new BufAndProj(buffer, csmProject, lastModified));
                        csmProject.onFileEditStart(buffer, nativeFile);
                    }
                }
            }
        }

        private boolean isCndDataObject(FileObject fo) {
            String type = fo.getMIMEType();
            return MIMENames.isFortranOrHeaderOrCppOrC((String)type);
        }

        private NativeFileItemSet findCanonicalSet(DataObject curObj) {
            FileObject fo = curObj.getPrimaryFile();
            if (fo != null && this.isCndDataObject(fo)) {
                try {
                    fo = CndFileUtils.getCanonicalFileObject((FileObject)fo);
                    curObj = DataObject.find((FileObject)fo);
                    return (NativeFileItemSet)curObj.getLookup().lookup(NativeFileItemSet.class);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (TraceFlags.DEBUG) {
                ModelSupport.traceDataObjectRegistryStateChanged(e);
            }
            if (e != null) {
                Object[] objs = DataObject.getRegistry().getModified();
                HashSet<DataObject> toDelete = new HashSet<DataObject>();
                for (DataObject dao : ModelSupport.this.buffers.keySet()) {
                    if (this.contains(objs, dao)) continue;
                    for (BufAndProj bufNP : this.getBufNP(dao)) {
                        if (bufNP != null) {
                            FileBuffer fileBuffer = ModelSupport.createFileBuffer(dao);
                            long lastModified = fileBuffer.lastModified();
                            bufNP.project.onFileEditEnd(fileBuffer, null, bufNP.lastModified == lastModified);
                            continue;
                        }
                        System.err.println("no buffer for " + dao);
                    }
                    toDelete.add(dao);
                }
                Iterator<Object> iter = toDelete.iterator();
                while (iter.hasNext()) {
                    ModelSupport.this.buffers.remove(iter.next());
                }
                for (int i = 0; i < objs.length; ++i) {
                    if (ModelSupport.this.buffers.containsKey(objs[i])) continue;
                    this.editStart((DataObject)objs[i]);
                }
            }
        }

        private boolean contains(Object[] objs, Object o) {
            for (int i = 0; i < objs.length; ++i) {
                if (!objs[i].equals(o)) continue;
                return true;
            }
            return false;
        }

        private void clean() {
            ModelSupport.this.buffers.clear();
        }
    }

    private static final class BufAndProj {
        public final FileBuffer buffer;
        public final ProjectBase project;
        public final long lastModified;

        public BufAndProj(FileBuffer buffer, ProjectBase project, long lastModified) {
            assert (buffer != null) : "null buffer";
            this.buffer = buffer;
            assert (project != null) : "null project";
            this.project = project;
            this.lastModified = lastModified;
        }
    }
}

