/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.util.NbBundle;

public class BrokenLinks {
    public static List<BrokenLink> getBrokenLinks(Project project) throws MissingResourceException {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        MakeConfiguration activeConfiguration;
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        ArrayList<BrokenLink> errs = new ArrayList<BrokenLink>();
        if (pdp.gotDescriptor() && (activeConfiguration = (makeConfigurationDescriptor = pdp.getConfigurationDescriptor()).getActiveConfiguration()) != null) {
            CompilerSet2Configuration csconf = activeConfiguration.getCompilerSet();
            CompilerSet cs = csconf.getCompilerSet();
            String csname = csconf.getOption();
            if (cs == null || cs.getDirectory() == null || cs.getDirectory().isEmpty()) {
                errs.add(new BrokenToolCollection(project, csname));
            }
        }
        return errs;
    }

    private static final class BrokenToolCollection
    implements BrokenLink {
        private final String name;
        private final List<Solution> solutions = new ArrayList<Solution>();

        private BrokenToolCollection(Project project, String name) {
            this.name = name;
            this.solutions.add(new ChangeProjectProperties(project, name));
            this.solutions.add(new AddToolCollection(name));
        }

        @Override
        public String getProblem() {
            return NbBundle.getMessage(BrokenLinks.class, (String)"Link_Problem_UnknownCompiler", (Object)this.name);
        }

        @Override
        public List<Solution> getSolutions() {
            return this.solutions;
        }
    }

    private static final class AddToolCollection
    implements Solution {
        private final String name;

        private AddToolCollection(String name) {
            this.name = name;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(BrokenLinks.class, (String)"Link_Solution_UnknownCompiler2", (Object)this.name);
        }

        @Override
        public Runnable resolve() {
            return () -> OptionsDisplayer.getDefault().open("CPlusPlus/ToolsTab");
        }
    }

    private static final class ChangeProjectProperties
    implements Solution {
        private final Project project;
        private final String name;

        private ChangeProjectProperties(Project project, String name) {
            this.project = project;
            this.name = name;
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(BrokenLinks.class, (String)"Link_Solution_UnknownCompiler1", (Object)this.name);
        }

        @Override
        public Runnable resolve() {
            return () -> {
                MakeCustomizerProvider cp = (MakeCustomizerProvider)this.project.getLookup().lookup(MakeCustomizerProvider.class);
                if (cp == null) {
                    return;
                }
                cp.showCustomizer("Build");
            };
        }
    }

    public static interface Solution {
        public String getDescription();

        public Runnable resolve();
    }

    public static interface BrokenLink {
        public String getProblem();

        public List<Solution> getSolutions();
    }
}

