/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.TempEnv;
import org.netbeans.modules.cnd.makeproject.api.configurations.CodeAssistanceConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.BrokenReferencesSupport;
import org.netbeans.modules.cnd.makeproject.ui.ResolveEnvVarPanel;
import org.netbeans.modules.cnd.makeproject.ui.ResolveReferencePanel;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ConnectionNotifier;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public final class EnvProjectProblemsProvider {
    private final MakeProject project;
    private final AtomicReference<UnsetEnvVar> lastUnsetVar = new AtomicReference();
    private ExecutionEnvironment listeningEnv = null;
    private final Object listeningEnvLock = new Object();

    public EnvProjectProblemsProvider(MakeProject project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<? extends ProjectProblemsProvider.ProjectProblem> getEnvProblems() {
        UnsetEnvVar unset = this.getUndefinedEnvVars();
        this.lastUnsetVar.set(unset);
        if (unset != null && !unset.getUndefinedEnvVars().isEmpty()) {
            ProjectProblemsProvider.ProjectProblem error = ProjectProblemsProvider.ProjectProblem.createError((String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"env_var_resolve_name"), (String)NbBundle.getMessage(ResolveReferencePanel.class, (String)"env_var_resolve_description"), (ProjectProblemResolver)new EnvResolverImpl(this.project, unset));
            ExecutionEnvironment env = unset.getExecutionEnvironment();
            if (env.isRemote()) {
                Object object = this.listeningEnvLock;
                synchronized (object) {
                    if (!env.equals((Object)this.listeningEnv)) {
                        this.listeningEnv = env;
                        ConnectionNotifier.addTask((ExecutionEnvironment)env, (ConnectionNotifier.NamedRunnable)new ConnListener(this.project, this.lastUnsetVar));
                    }
                }
            }
            return Collections.singleton(error);
        }
        return Collections.emptySet();
    }

    private UnsetEnvVar getUndefinedEnvVars() {
        VectorConfiguration codeAssisyancVars;
        CodeAssistanceConfiguration codeAssistanceConfiguration;
        MakeConfigurationDescriptor configurationDescriptor;
        MakeConfiguration activeConfiguration;
        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (cdp.gotDescriptor() && (activeConfiguration = (configurationDescriptor = cdp.getConfigurationDescriptor()).getActiveConfiguration()) != null && (codeAssistanceConfiguration = activeConfiguration.getCodeAssistanceConfiguration()) != null && (codeAssisyancVars = codeAssistanceConfiguration.getEnvironmentVariables()) != null && !codeAssisyancVars.getValue().isEmpty()) {
            ExecutionEnvironment ee = activeConfiguration.getDevelopmentHost().getExecutionEnvironment();
            HostInfo hostInfo = null;
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)ee)) {
                try {
                    hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ee);
                }
                catch (IOException | ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            ArrayList<String> res = new ArrayList<String>();
            for (String var : codeAssisyancVars.getValue()) {
                String value = hostInfo == null ? null : (String)hostInfo.getEnvironment().get(var);
                if (value != null || TempEnv.getInstance((ExecutionEnvironment)ee).isTemporaryEnvSet(var)) continue;
                res.add(var);
            }
            return res.isEmpty() ? null : new UnsetEnvVar(res, ee);
        }
        return null;
    }

    private static class ConnListener
    extends ConnectionNotifier.NamedRunnable {
        private final WeakReference<MakeProject> projectRef;
        private final AtomicReference<UnsetEnvVar> unsetRef;

        public ConnListener(MakeProject project, AtomicReference<UnsetEnvVar> unset) {
            super(NbBundle.getMessage(ConnListener.class, (String)"EnvResolver_connection_text", (Object)ConnListener.getExecEnv(unset)));
            this.unsetRef = unset;
            this.projectRef = new WeakReference<MakeProject>(project);
        }

        private static ExecutionEnvironment getExecEnv(AtomicReference<UnsetEnvVar> unsetRef) {
            UnsetEnvVar unset = unsetRef.get();
            return unset == null ? ExecutionEnvironmentFactory.getLocal() : unset.getExecutionEnvironment();
        }

        protected void runImpl() {
            NativeProject nativeProject;
            MakeProject project = (MakeProject)this.projectRef.get();
            if (project == null) {
                return;
            }
            if (!OpenProjects.getDefault().isProjectOpen((Project)project)) {
                return;
            }
            UnsetEnvVar unset = this.unsetRef.get();
            if (unset == null) {
                return;
            }
            ExecutionEnvironment execEnv = unset.getExecutionEnvironment();
            if (!HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)execEnv)) {
                CndUtils.assertTrueInConsole((boolean)false, (String)"Host unavailable?!");
                return;
            }
            HostInfo hostInfo = null;
            try {
                hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
            }
            catch (IOException | ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (hostInfo == null) {
                return;
            }
            Map envMap = hostInfo.getEnvironment();
            boolean changed = false;
            for (String var : unset.getUndefinedEnvVars()) {
                String tempEnv;
                String value = (String)envMap.get(var);
                if (value == null || value.equals(tempEnv = TempEnv.getInstance((ExecutionEnvironment)execEnv).getTemporaryEnv(var))) continue;
                changed = true;
                TempEnv.getInstance((ExecutionEnvironment)execEnv).setTemporaryEnv(var, value);
            }
            if (changed && (nativeProject = (NativeProject)project.getLookup().lookup(NativeProject.class)) != null) {
                nativeProject.fireFilesPropertiesChanged();
            }
            BrokenReferencesSupport.updateProblems((Project)project);
        }
    }

    private static class EnvResolverImpl
    extends BrokenReferencesSupport.BaseProjectProblemResolver {
        private final UnsetEnvVar unset;

        private EnvResolverImpl(MakeProject project, UnsetEnvVar unset) {
            super(project);
            this.unset = unset;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            this.unset.edit.clear();
            ResolveEnvVarPanel panel = new ResolveEnvVarPanel(this.unset);
            DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(ResolveEnvVarPanel.class, (String)"env_var_fix_title"));
            dd.setOptionType(2);
            if (NotifyDescriptor.OK_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)dd))) {
                boolean success = true;
                boolean changed = false;
                for (String var : this.unset.getUndefinedEnvVars()) {
                    String val = (String)this.unset.edit.get(var);
                    if (val != null && !val.trim().isEmpty()) {
                        ExecutionEnvironment env = this.unset.getExecutionEnvironment();
                        String oldVal = TempEnv.getInstance((ExecutionEnvironment)env).getTemporaryEnv(var);
                        String newVal = val.trim();
                        TempEnv.getInstance((ExecutionEnvironment)env).setTemporaryEnv(var, newVal);
                        if (oldVal != null && oldVal.trim().equals(newVal)) continue;
                        changed = true;
                        continue;
                    }
                    success = false;
                }
                if (success) {
                    NativeProject nativeProject;
                    this.updateProblems();
                    if (changed && (nativeProject = (NativeProject)this.getProject().getLookup().lookup(NativeProject.class)) != null) {
                        nativeProject.fireFilesPropertiesChanged();
                    }
                    return new BrokenReferencesSupport.Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED));
                }
            }
            return new BrokenReferencesSupport.Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }

        public int hashCode() {
            return this.getProject().hashCode() + EnvResolverImpl.class.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EnvResolverImpl other = (EnvResolverImpl)obj;
            return this.getProject().equals(other.getProject());
        }
    }

    public static final class UnsetEnvVar {
        private final Collection<String> undefinedEnvVars;
        private final Map<String, String> edit = new HashMap<String, String>();
        private final ExecutionEnvironment ee;

        private UnsetEnvVar(Collection<String> undefinedEnvVars, ExecutionEnvironment ee) {
            this.undefinedEnvVars = undefinedEnvVars;
            this.ee = ee;
        }

        public Collection<String> getUndefinedEnvVars() {
            return this.undefinedEnvVars;
        }

        public ExecutionEnvironment getExecutionEnvironment() {
            return this.ee;
        }

        public void editValue(String key, String val) {
            this.edit.put(key, val);
        }
    }
}

