/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.MakeCustomizerProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectLookupProvider;
import org.netbeans.modules.cnd.makeproject.api.MakeSharabilityQuery;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeCustomizer;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MakeCustomizerProviderImpl
implements MakeCustomizerProvider,
CustomizerProvider {
    private final MakeProject project;
    private static final int OPTION_OK = 0;
    private static final int OPTION_CANCEL = 1;
    private static final int OPTION_APPLY = 2;
    public static final String COMMAND_OK = "OK";
    public static final String COMMAND_CANCEL = "CANCEL";
    public static final String COMMAND_APPLY = "APPLY";
    private DialogDescriptor dialogDescriptor;
    private final ConfigurationDescriptorProvider projectDescriptorProvider;
    private String currentCommand;
    private final Map<MakeContext.Kind, String> lastCurrentNodeName = new EnumMap<MakeContext.Kind, String>(MakeContext.Kind.class);
    private final Set<ActionListener> actionListenerList = new HashSet<ActionListener>();
    private static final RequestProcessor RP_SAVE = new RequestProcessor("MakeCustomizerProviderSave", 1);

    public MakeCustomizerProviderImpl(MakeProject project) {
        this.project = project;
        this.projectDescriptorProvider = project.getConfigurationDescriptorProvider();
    }

    public void showCustomizer() {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Project), null, null);
    }

    public void showCustomizer(Item item) {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Item), Arrays.asList(item), null);
    }

    public void showCustomizer(Folder folder) {
        this.showCustomizer(this.lastCurrentNodeName.get((Object)MakeContext.Kind.Folder), null, Arrays.asList(folder));
    }

    public void showCustomizer(String preselectedNodeName) {
        this.showCustomizer(preselectedNodeName, null, null);
    }

    public void showCustomizer(String preselectedNodeName, List<Item> items, List<Folder> folders) {
        if (!this.projectDescriptorProvider.gotDescriptor() || this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().size() == 0) {
            return;
        }
        this.showCustomizerWorker(preselectedNodeName, items, folders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCustomizerWorker(String preselectedNodeName, List<Item> items, List<Folder> folders) {
        String dialogTitle;
        String name;
        StringBuilder sb;
        if (folders != null) {
            for (Folder folder : folders) {
                if (folder == null) continue;
                Configuration[] configurations = this.projectDescriptorProvider.getConfigurationDescriptor().getConfs().toArray();
                for (int i2 = 0; i2 < configurations.length; ++i2) {
                    folder.getFolderConfiguration(configurations[i2]);
                }
            }
        }
        this.projectDescriptorProvider.getConfigurationDescriptor().refreshRequiredLanguages();
        Object[] options = new JButton[]{new JButton(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"LBL_Customizer_Ok_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"LBL_Customizer_Cancel_Option")), new JButton(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"LBL_Customizer_Apply_Option"))};
        options[0].setActionCommand(COMMAND_OK);
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"ACSD_Customizer_Ok_Option"));
        options[1].setActionCommand(COMMAND_CANCEL);
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"ACSD_Customizer_Cancel_Option"));
        options[2].setActionCommand(COMMAND_APPLY);
        options[2].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"ACSD_Customizer_Apply_Option"));
        options[0].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"AD_MakeCustomizerProviderOk"));
        options[1].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"AD_MakeCustomizerProviderCancel"));
        options[2].getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"AD_MakeCustomizerProviderApply"));
        options[2].setMnemonic(NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"MNE_Customizer_Apply_Option").charAt(0));
        ConfigurationDescriptor clonedProjectdescriptor = this.projectDescriptorProvider.getConfigurationDescriptor().cloneProjectDescriptor();
        ArrayList<JButton> controls = new ArrayList<JButton>();
        controls.add(options[0]);
        MakeCustomizer innerPane = new MakeCustomizer((Project)this.project, preselectedNodeName, clonedProjectdescriptor, items, folders, Collections.unmodifiableCollection(controls));
        OptionListener optionsListener = new OptionListener((Project)this.project, (ConfigurationDescriptor)this.projectDescriptorProvider.getConfigurationDescriptor(), clonedProjectdescriptor, innerPane, folders, items);
        options[0].addActionListener(optionsListener);
        options[1].addActionListener(optionsListener);
        options[2].addActionListener(optionsListener);
        if (items != null && !items.isEmpty()) {
            sb = new StringBuilder();
            items.forEach(i -> sb.append(i.getName()).append(", "));
            name = sb.toString().substring(0, sb.length() - 2);
            dialogTitle = NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"LBL_File_Customizer_Title", (Object)name);
        } else if (folders != null && !folders.isEmpty()) {
            sb = new StringBuilder();
            folders.forEach(f -> sb.append(f.getName()).append(", "));
            name = sb.toString().substring(0, sb.length() - 2);
            dialogTitle = NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"LBL_Folder_Customizer_Title", (Object)name);
        } else {
            dialogTitle = NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)"LBL_Project_Customizer_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName());
        }
        this.dialogDescriptor = new DialogDescriptor((Object)innerPane, dialogTitle, true, options, (Object)options[0], 0, null, null);
        this.dialogDescriptor.setClosingOptions(new Object[]{options[0], options[1]});
        innerPane.setDialogDescriptor(this.dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        this.currentCommand = COMMAND_CANCEL;
        try {
            dialog.setVisible(true);
        }
        catch (Throwable th) {
            if (!(th.getCause() instanceof InterruptedException)) {
                throw new RuntimeException(th);
            }
            this.dialogDescriptor.setValue(DialogDescriptor.CANCEL_OPTION);
        }
        finally {
            dialog.dispose();
        }
        MakeContext lastContext = innerPane.getLastContext();
        String nodeName = innerPane.getCurrentNodeName();
        if (lastContext != null) {
            this.lastCurrentNodeName.put(lastContext.getKind(), nodeName);
        }
        if (this.currentCommand.equals(COMMAND_CANCEL)) {
            this.fireActionEvent(new ActionEvent(this.project, 0, this.currentCommand));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActionListener(ActionListener cl) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.add(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActionListener(ActionListener cl) {
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            this.actionListenerList.remove(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireActionEvent(ActionEvent e) {
        Iterator<ActionListener> it;
        Set<ActionListener> set = this.actionListenerList;
        synchronized (set) {
            it = new HashSet<ActionListener>(this.actionListenerList).iterator();
        }
        while (it.hasNext()) {
            it.next().actionPerformed(e);
        }
    }

    public String getLastCurrentNodeName(MakeContext.Kind kind) {
        return this.lastCurrentNodeName.get((Object)kind);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(MakeCustomizerProviderImpl.class, (String)s);
    }

    private final class OptionListener
    implements ActionListener {
        private final Project project;
        private final ConfigurationDescriptor projectDescriptor;
        private final ConfigurationDescriptor clonedProjectdescriptor;
        private final MakeCustomizer makeCustomizer;
        private final List<Folder> folders;
        private final List<Item> items;

        OptionListener(Project project, ConfigurationDescriptor projectDescriptor, ConfigurationDescriptor clonedProjectdescriptor, MakeCustomizer makeCustomizer, List<Folder> folders, List<Item> items) {
            this.project = project;
            this.projectDescriptor = projectDescriptor;
            this.clonedProjectdescriptor = clonedProjectdescriptor;
            this.makeCustomizer = makeCustomizer;
            this.folders = folders;
            this.items = items;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MakeCustomizerProviderImpl.this.currentCommand = e.getActionCommand();
            if (MakeCustomizerProviderImpl.this.currentCommand.equals(MakeCustomizerProviderImpl.COMMAND_OK) || MakeCustomizerProviderImpl.this.currentCommand.equals(MakeCustomizerProviderImpl.COMMAND_APPLY)) {
                this.makeCustomizer.save();
                RP_SAVE.post(() -> {
                    int currentVersion;
                    int previousVersion = this.projectDescriptor.getVersion();
                    if (previousVersion < (currentVersion = 100)) {
                        boolean issueRequiredProjectBuildWarning = false;
                        if (previousVersion < 76) {
                            block0: for (Configuration configuration : this.projectDescriptor.getConfs().getConfigurations()) {
                                MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
                                if (!makeConfiguration.isMakefileConfiguration()) continue;
                                List projectLinkItems = makeConfiguration.getRequiredProjectsConfiguration().getValue();
                                for (LibraryItem.ProjectItem projectItem : projectLinkItems) {
                                    if (!projectItem.getMakeArtifact().getBuild()) continue;
                                    issueRequiredProjectBuildWarning = true;
                                    continue block0;
                                }
                            }
                        }
                        String txt = issueRequiredProjectBuildWarning ? MakeCustomizerProviderImpl.getString("UPGRADE_RQ_TXT") : MakeCustomizerProviderImpl.getString("UPGRADE_TXT");
                        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)txt, MakeCustomizerProviderImpl.getString("UPGRADE_DIALOG_TITLE"), 0);
                        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.YES_OPTION) {
                            return;
                        }
                        this.projectDescriptor.setVersion(currentVersion);
                    }
                    ConfigurationDescriptorProvider.Delta delta = null;
                    if (this.folders == null && this.items == null) {
                        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                        delta = (ConfigurationDescriptorProvider.Delta)cdp.startModifications();
                    }
                    List oldSourceRoots = ((MakeConfigurationDescriptor)this.projectDescriptor).getSourceRoots();
                    List newSourceRoots = ((MakeConfigurationDescriptor)this.clonedProjectdescriptor).getSourceRoots();
                    List oldTestRoots = ((MakeConfigurationDescriptor)this.projectDescriptor).getTestRoots();
                    List newTestRoots = ((MakeConfigurationDescriptor)this.clonedProjectdescriptor).getTestRoots();
                    Configuration oldActive = this.projectDescriptor.getConfs().getActive();
                    if (oldActive != null) {
                        oldActive = oldActive.cloneConf();
                    }
                    Configuration[] oldConf = this.projectDescriptor.getConfs().toArray();
                    Configuration newActive = this.clonedProjectdescriptor.getConfs().getActive();
                    Configuration[] newConf = this.clonedProjectdescriptor.getConfs().toArray();
                    this.projectDescriptor.assign(this.clonedProjectdescriptor);
                    this.projectDescriptor.getConfs().fireChangedConfigurations(oldConf, newConf);
                    this.projectDescriptor.setModified();
                    this.projectDescriptor.save();
                    MakeSharabilityQuery query = (MakeSharabilityQuery)this.project.getLookup().lookup(MakeSharabilityQuery.class);
                    if (query != null) {
                        query.update();
                    }
                    if (this.folders == null && this.items == null) {
                        ConfigurationDescriptorProvider cdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
                        cdp.endModifications((ConfigurationDescriptorProvider.SnapShot)delta, true, null);
                    } else {
                        if (this.folders != null) {
                            this.folders.forEach(folder -> ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedItems(this.project, folder, null));
                        }
                        if (this.items != null) {
                            this.items.forEach(item -> ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedItems(this.project, null, item));
                        }
                    }
                    ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedSourceRoots(oldSourceRoots, newSourceRoots);
                    ((MakeConfigurationDescriptor)this.projectDescriptor).checkForChangedTestRoots(oldTestRoots, newTestRoots);
                    ((MakeConfigurationDescriptor)this.projectDescriptor).checkConfigurations(oldActive, newActive);
                });
            }
            if (!MakeCustomizerProviderImpl.this.currentCommand.equals(MakeCustomizerProviderImpl.COMMAND_CANCEL)) {
                MakeCustomizerProviderImpl.this.fireActionEvent(new ActionEvent(this.project, 0, MakeCustomizerProviderImpl.this.currentCommand));
            }
            if (MakeCustomizerProviderImpl.this.currentCommand.equals(MakeCustomizerProviderImpl.COMMAND_APPLY)) {
                this.makeCustomizer.refresh();
            }
        }
    }

    public static class MakeCustomizerProviderFactory
    implements MakeProjectLookupProvider {
        public void addLookup(MakeProject owner, ArrayList<Object> ic) {
            ic.add(new MakeCustomizerProviderImpl(owner));
        }
    }
}

