/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import org.netbeans.modules.cnd.makeproject.ui.BrokenLinks;
import org.openide.util.NbBundle;

public class ResolveReferencePanel
extends JPanel
implements ActionListener {
    private final List<BrokenLinks.BrokenLink> brokenLinks;

    public ResolveReferencePanel(List<BrokenLinks.BrokenLink> brokenLinks) {
        this.initComponents();
        this.brokenLinks = brokenLinks;
        this.initUI();
    }

    private void initUI() {
        int iy = 0;
        for (BrokenLinks.BrokenLink error : this.brokenLinks) {
            JLabel problem = new JLabel(NbBundle.getBundle(ResolveReferencePanel.class).getString("Link_Problem_Text"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = iy++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(6, 4, 0, 0);
            this.add((Component)problem, gridBagConstraints);
            JTextArea problemText = new JTextArea();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = iy++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)problemText, gridBagConstraints);
            problemText.setText(error.getProblem());
            problemText.setBackground(this.getBackground());
            problemText.setEditable(false);
            problemText.setOpaque(false);
            JSeparator separator = new JSeparator();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = iy++;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            this.add((Component)separator, gridBagConstraints);
            JLabel solutions = new JLabel(NbBundle.getBundle(ResolveReferencePanel.class).getString("Link_Solution_Text"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = iy++;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(0, 4, 0, 0);
            this.add((Component)solutions, gridBagConstraints);
            int i = 1;
            for (BrokenLinks.Solution solution : error.getSolutions()) {
                StringBuilder buf = new StringBuilder();
                buf.append(i);
                buf.append(". ");
                buf.append(solution.getDescription());
                JTextArea solutionText = new JTextArea();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = iy;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(4, 4, 0, 0);
                this.add((Component)solutionText, gridBagConstraints);
                solutionText.setText(buf.toString());
                solutionText.setBackground(this.getBackground());
                solutionText.setEditable(false);
                solutionText.setOpaque(false);
                JButton button = new JButton(NbBundle.getBundle(ResolveReferencePanel.class).getString("Link_Resolve_Text"));
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridy = iy++;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(4, 4, 0, 4);
                this.add((Component)button, gridBagConstraints);
                if (solution.resolve() == null) {
                    button.setEnabled(false);
                } else {
                    button.putClientProperty("Solution", solution);
                    button.addActionListener(this);
                }
                ++i;
                separator = new JSeparator();
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = iy++;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                this.add((Component)separator, gridBagConstraints);
            }
        }
    }

    private void initComponents() {
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() instanceof JButton) {
            JButton button = (JButton)ae.getSource();
            BrokenLinks.Solution solution = (BrokenLinks.Solution)button.getClientProperty("Solution");
            solution.resolve().run();
            button.setEnabled(false);
        }
    }
}

