/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.ui.RemoteFileChooserUtil;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.uiapi.ConfirmSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class SelectExecutablePanel
extends JPanel
implements ConfirmSupport.SelectExecutable {
    private final JList exeList;
    private final FileFilterFactory.AbstractFileAndFileObjectFilter elfExecutableFileFilter = FileFilterFactory.getElfExecutableFileFilter();
    private final FileFilterFactory.AbstractFileAndFileObjectFilter exeExecutableFileFilter = FileFilterFactory.getPeExecutableFileFilter();
    private final FileFilterFactory.AbstractFileAndFileObjectFilter machOExecutableFileFilter = FileFilterFactory.getMacOSXExecutableFileFilter();
    private final DocumentListener documentListener;
    private DialogDescriptor dialogDescriptor;
    private final MakeConfiguration conf;
    private final FileObject buildWorkingDirFO;
    private final PathMap mapper;
    private static final RequestProcessor RP = new RequestProcessor("SelectExecutable", 1);
    private final AtomicBoolean canceled = new AtomicBoolean(false);
    private final Map<String, FileObject> searchResult = new TreeMap<String, FileObject>();
    private final String wd;
    private boolean resetList = false;
    private JLabel ExecutableListLabel;
    private JButton browseButton;
    private JLabel errorLabel;
    private JLabel executableLabel;
    private JScrollPane executableList;
    private JTextField executableTextField;
    private JTextArea instructionsTextArea;
    private JList list;
    private JLabel progress;

    public SelectExecutablePanel(ProjectActionEvent pae) {
        String aWd;
        this.conf = pae.getConfiguration();
        this.initComponents();
        this.instructionsTextArea.setBackground(this.getBackground());
        this.mapper = RemoteSyncSupport.getPathMap((Lookup.Provider)pae.getProject());
        String wd = this.conf.getMakefileConfiguration().getAbsBuildCommandWorkingDir();
        if (this.mapper != null && (aWd = this.mapper.getRemotePath(this.conf.getMakefileConfiguration().getAbsBuildCommandWorkingDir(), true)) != null) {
            wd = aWd;
        }
        this.wd = wd;
        this.buildWorkingDirFO = RemoteFileUtil.getFileObject((String)wd, (ExecutionEnvironment)this.conf.getDevelopmentHost().getExecutionEnvironment());
        this.exeList = new JList();
        this.executableList.setViewportView(this.exeList);
        this.exeList.addListSelectionListener(new MyListSelectionListener());
        this.documentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SelectExecutablePanel.this.validateExe();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SelectExecutablePanel.this.validateExe();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SelectExecutablePanel.this.validateExe();
            }
        };
        this.executableTextField.getDocument().addDocumentListener(this.documentListener);
        this.setPreferredSize(new Dimension(600, 300));
        this.validateExe();
        this.progress.setText(NbBundle.getMessage(SelectExecutablePanel.class, (String)"Search_In_Progress"));
        this.progress.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/exclamation.gif", (boolean)false));
        RP.post(() -> {
            this.findAllExecutables(this.buildWorkingDirFO);
            SwingUtilities.invokeLater(() -> this.progress.setVisible(false));
        });
        this.addHierarchyListener(e -> {
            if (e.getChangeFlags() == 4L && !e.getChanged().isVisible()) {
                this.canceled.set(true);
            }
        });
    }

    public void setDialogDescriptor(DialogDescriptor dialogDescriptor) {
        this.dialogDescriptor = dialogDescriptor;
        this.validateExe();
    }

    private void validateExe() {
        String errorText = null;
        if (this.executableTextField.getText().length() == 0) {
            errorText = SelectExecutablePanel.getString("NO_EXE_ERROR");
        } else {
            String executablePath = this.executableTextField.getText();
            FileObject exe = null;
            if (!CndPathUtilities.isPathAbsolute((CharSequence)executablePath)) {
                if (this.buildWorkingDirFO != null) {
                    exe = this.buildWorkingDirFO.getFileObject(executablePath);
                }
            } else {
                executablePath = CndFileUtils.normalizeAbsolutePath((String)executablePath);
                exe = RemoteFileUtil.getFileObject((String)executablePath, (ExecutionEnvironment)this.conf.getDevelopmentHost().getExecutionEnvironment());
            }
            if (!(CndPathUtilities.isPathAbsolute((CharSequence)executablePath) || this.buildWorkingDirFO != null && this.buildWorkingDirFO.isValid())) {
                errorText = NbBundle.getMessage(SelectExecutablePanel.class, (String)"WRONG_WORKING_DIR", (Object)this.wd);
            } else if (exe == null || !exe.isValid()) {
                errorText = SelectExecutablePanel.getString("EXE_DOESNT_EXISTS");
            } else if (exe.isFolder() || !this.elfExecutableFileFilter.accept(exe) && !this.exeExecutableFileFilter.accept(exe) && !this.machOExecutableFileFilter.accept(exe)) {
                errorText = SelectExecutablePanel.getString("FILE_NOT_AN_EXECUTABLE");
            }
        }
        if (errorText != null) {
            this.errorLabel.setText(errorText);
            if (this.dialogDescriptor != null) {
                this.dialogDescriptor.setValid(false);
            }
        } else {
            this.errorLabel.setText(" ");
            if (this.dialogDescriptor != null) {
                this.dialogDescriptor.setValid(true);
            }
        }
    }

    public String getExecutable() {
        String path = this.executableTextField.getText();
        if (this.mapper != null) {
            path = this.mapper.getLocalPath(path);
        }
        return path;
    }

    private void findAllExecutables(FileObject root) {
        if (root == null || !root.isValid() || !root.isFolder()) {
            return;
        }
        this.addExecutables(root);
    }

    private void addExecutables(FileObject dir) {
        ArrayList<FileObject> downPrev = new ArrayList<FileObject>();
        downPrev.add(dir);
        while (!downPrev.isEmpty()) {
            ArrayList<FileObject> downNext = new ArrayList<FileObject>();
            for (FileObject folder : downPrev) {
                if (this.canceled.get()) {
                    return;
                }
                folder.refresh();
                FileObject[] files = folder.getChildren();
                if (files == null) continue;
                for (int i = 0; i < files.length; ++i) {
                    if (this.canceled.get()) {
                        return;
                    }
                    if (files[i].isFolder()) {
                        String aName = files[i].getName();
                        if (aName.equals("SCCS") || aName.equals("CVS") || aName.equals(".hg") || aName.equals("SunWS_cache") || aName.equals(".svn")) continue;
                        downNext.add(files[i]);
                        continue;
                    }
                    if (FileFilterFactory.getAllFileFilter().accept(files[i])) continue;
                    if (this.conf.getDevelopmentHost().getBuildPlatform() == 3) {
                        if (!this.exeExecutableFileFilter.accept(files[i])) continue;
                        this.searchResult.put(files[i].getPath(), files[i]);
                        this.updateList();
                        continue;
                    }
                    if (this.conf.getDevelopmentHost().getBuildPlatform() == 4) {
                        if (!this.machOExecutableFileFilter.accept(files[i])) continue;
                        this.searchResult.put(files[i].getPath(), files[i]);
                        this.updateList();
                        continue;
                    }
                    if (!this.elfExecutableFileFilter.accept(files[i])) continue;
                    this.searchResult.put(files[i].getPath(), files[i]);
                    this.updateList();
                }
            }
            downPrev = downNext;
        }
    }

    private void updateList() {
        ArrayList<String> keySet = new ArrayList<String>(this.searchResult.keySet());
        SwingUtilities.invokeLater(() -> {
            DefaultListModel<String> model = new DefaultListModel<String>();
            Object selected = this.exeList.getSelectedValue();
            String first = null;
            for (String path : keySet) {
                if (first == null) {
                    first = path;
                }
                model.addElement(path);
            }
            this.resetList = true;
            this.exeList.setModel(model);
            if (selected != null) {
                this.exeList.setSelectedValue(selected, true);
            }
            this.resetList = false;
            if (selected == null && this.executableTextField.getText().isEmpty()) {
                this.exeList.setSelectedValue(first, true);
            }
        });
    }

    private void initComponents() {
        this.instructionsTextArea = new JTextArea();
        this.ExecutableListLabel = new JLabel();
        this.executableList = new JScrollPane();
        this.list = new JList();
        this.executableLabel = new JLabel();
        this.executableTextField = new JTextField();
        this.browseButton = new JButton();
        this.errorLabel = new JLabel();
        this.progress = new JLabel();
        this.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/Bundle");
        this.instructionsTextArea.setText(bundle.getString("GUIDANCE_TEXT"));
        this.instructionsTextArea.setWrapStyleWord(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.ExecutableListLabel.setLabelFor(this.executableList);
        Mnemonics.setLocalizedText((JLabel)this.ExecutableListLabel, (String)bundle.getString("LIST_LABEL_TEXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.add((Component)this.ExecutableListLabel, gridBagConstraints);
        this.executableList.setViewportView(this.list);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 12);
        this.add((Component)this.executableList, gridBagConstraints);
        this.executableLabel.setLabelFor(this.executableTextField);
        Mnemonics.setLocalizedText((JLabel)this.executableLabel, (String)bundle.getString("EXECUTABLE_TEXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 12, 0, 12);
        this.add((Component)this.executableLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.add((Component)this.executableTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)bundle.getString("BROWSE_BUTTON_TEXT"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectExecutablePanel.this.browseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 12);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.errorLabel.setForeground(new Color(255, 51, 51));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 0);
        this.add((Component)this.errorLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 12, 0, 0);
        this.add((Component)this.progress, gridBagConstraints);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        String chooser_key = "SelectExecutablePanel";
        String seed = this.executableTextField.getText().length() > 0 ? this.executableTextField.getText() : (RemoteFileChooserUtil.getCurrentChooserFile((String)"SelectExecutablePanel", (ExecutionEnvironment)this.conf.getDevelopmentHost().getExecutionEnvironment()) != null ? RemoteFileChooserUtil.getCurrentChooserFile((String)"SelectExecutablePanel", (ExecutionEnvironment)this.conf.getDevelopmentHost().getExecutionEnvironment()) : System.getProperty("user.home"));
        FileFilter[] filters = this.conf.getDevelopmentHost().getBuildPlatform() == 3 ? new FileFilter[]{FileFilterFactory.getPeExecutableFileFilter()} : (this.conf.getDevelopmentHost().getBuildPlatform() == 4 ? new FileFilter[]{FileFilterFactory.getMacOSXExecutableFileFilter()} : new FileFilter[]{FileFilterFactory.getElfExecutableFileFilter()});
        JFileChooser fileChooser = RemoteFileChooserUtil.createFileChooser((ExecutionEnvironment)this.conf.getDevelopmentHost().getExecutionEnvironment(), (String)SelectExecutablePanel.getString("CHOOSER_TITLE_TXT"), (String)SelectExecutablePanel.getString("CHOOSER_BUTTON_TXT"), (int)0, (FileFilter[])filters, (String)seed, (boolean)false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        String path = CndPathUtilities.normalizeSlashes((String)selectedFile.getPath());
        RemoteFileChooserUtil.setCurrentChooserFile((String)"SelectExecutablePanel", (String)selectedFile.getParentFile().getPath(), (ExecutionEnvironment)this.conf.getDevelopmentHost().getExecutionEnvironment());
        this.executableTextField.setText(path);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(SelectExecutablePanel.class, (String)s);
    }

    private final class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int i;
            if (SelectExecutablePanel.this.resetList) {
                return;
            }
            if (!e.getValueIsAdjusting() && (i = SelectExecutablePanel.this.exeList.getSelectedIndex()) >= 0) {
                SelectExecutablePanel.this.executableTextField.setText((String)SelectExecutablePanel.this.exeList.getSelectedValue());
                SelectExecutablePanel.this.validateExe();
            }
        }
    }

    public static final class ConfirmExtensionsUiFactoryImpl
    implements ConfirmSupport.SelectExecutableFactory {
        public ConfirmSupport.SelectExecutable create(ProjectActionEvent pae) {
            SelectExecutablePanel panel = new SelectExecutablePanel(pae);
            DialogDescriptor descriptor = new DialogDescriptor((Object)panel, SelectExecutablePanel.getString("SELECT_EXECUTABLE"));
            panel.setDialogDescriptor(descriptor);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                return panel;
            }
            return null;
        }
    }
}

