/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.utils;

import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.makeproject.api.TempEnv;
import org.netbeans.modules.cnd.utils.ui.EditableComboBox;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.util.Exceptions;

public final class ExpandableEditableComboBox
extends EditableComboBox {
    private MacroConverter converter;

    public void setEnv(ExecutionEnvironment env) {
        this.converter = new MacroConverter(env);
    }

    public String getText() {
        String res = super.getText();
        if (this.converter != null) {
            res = this.converter.expand(res);
        }
        return res;
    }

    private static final class MacroConverter {
        private final MacroExpanderFactory.MacroExpander expander;
        private final Map<String, String> envVariables = new HashMap<String, String>();
        private String homeDir;

        public MacroConverter(ExecutionEnvironment env) {
            if (HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)env);
                    this.envVariables.putAll(hostInfo.getEnvironment());
                    this.homeDir = hostInfo.getUserDir();
                }
                catch (IOException | ConnectionManager.CancellationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            TempEnv.getInstance((ExecutionEnvironment)env).addTemporaryEnv(this.envVariables);
            this.expander = this.envVariables == null ? null : MacroExpanderFactory.getExpander((ExecutionEnvironment)env, (boolean)false);
        }

        public String expand(String in) {
            try {
                if (in.startsWith("~") && this.homeDir != null) {
                    in = this.homeDir + in.substring(1);
                }
                return this.expander != null ? this.expander.expandMacros(in, this.envVariables) : in;
            }
            catch (ParseException parseException) {
                return in;
            }
        }
    }
}

