/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.csl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ElementFilter;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.openide.util.ImageUtilities;

public final class NavigatorScanner {
    private static final Logger LOGGER = Logger.getLogger(NavigatorScanner.class.getName());
    private static final String FONT_GRAY_COLOR = "<font color=\"#999999\">";
    private static final String CLOSE_FONT = "</font>";
    private static ImageIcon interfaceIcon = null;
    private static ImageIcon traitIcon = null;
    private static boolean isLogged = false;
    private final FileScope fileScope;
    private final Set<TypeElement> deprecatedTypes;

    public static NavigatorScanner create(Model model, boolean resolveDeprecatedElements) {
        return new NavigatorScanner(model, resolveDeprecatedElements);
    }

    private NavigatorScanner(Model model, boolean resolveDeprecatedElements) {
        this.fileScope = model.getFileScope();
        if (resolveDeprecatedElements) {
            if (!isLogged) {
                LOGGER.info("Resolving of deprecated elements in Navigator scanner - IDE will be possibly slow!");
                isLogged = true;
            }
            this.deprecatedTypes = ElementFilter.forDeprecated(true).filter(model.getIndexScope().getIndex().getTypes(NameKind.empty()));
        } else {
            this.deprecatedTypes = Collections.emptySet();
        }
    }

    public List<? extends StructureItem> scan() {
        ArrayList<StructureItem> items = new ArrayList<StructureItem>();
        this.processNamespaces(items, this.fileScope.getDeclaredNamespaces());
        return items;
    }

    private void processNamespaces(List<StructureItem> items, Collection<? extends NamespaceScope> declaredNamespaces) {
        for (NamespaceScope namespaceScope : declaredNamespaces) {
            ArrayList<StructureItem> namespaceChildren;
            ArrayList<StructureItem> arrayList = namespaceChildren = namespaceScope.isDefaultNamespace() ? items : new ArrayList<StructureItem>();
            if (!namespaceScope.isDefaultNamespace()) {
                items.add(new PHPNamespaceStructureItem(namespaceScope, namespaceChildren));
            }
            Collection<? extends UseScope> declaredUses = namespaceScope.getAllDeclaredSingleUses();
            for (UseScope useScope : declaredUses) {
                namespaceChildren.add(new PHPUseStructureItem(useScope));
            }
            Collection<? extends FunctionScope> declaredFunctions = namespaceScope.getDeclaredFunctions();
            for (FunctionScope fnc : declaredFunctions) {
                if (fnc.isAnonymous()) continue;
                ArrayList arrayList2 = new ArrayList();
                namespaceChildren.add(new PHPFunctionStructureItem(fnc, arrayList2));
            }
            Collection<? extends ConstantElement> collection = namespaceScope.getDeclaredConstants();
            for (ConstantElement constantElement : collection) {
                namespaceChildren.add(new PHPConstantStructureItem(constantElement, "const"));
            }
            this.processTypes(items, namespaceChildren, namespaceScope.getDeclaredTypes());
        }
    }

    private void processTypes(List<StructureItem> items, List<StructureItem> namespaceChildren, Collection<? extends TypeScope> declaredTypes) {
        for (TypeScope typeScope : declaredTypes) {
            Collection<? extends FieldElement> declaredFields;
            ArrayList<PHPStructureItem> children = new ArrayList<PHPStructureItem>();
            if (typeScope instanceof ClassScope) {
                namespaceChildren.add(new PHPClassStructureItem((ClassScope)typeScope, children));
            } else if (typeScope instanceof InterfaceScope) {
                namespaceChildren.add(new PHPInterfaceStructureItem((InterfaceScope)typeScope, children));
            } else if (typeScope instanceof TraitScope) {
                namespaceChildren.add(new PHPTraitStructureItem((TraitScope)typeScope, children));
            }
            Collection<? extends MethodScope> declaredMethods = typeScope.getDeclaredMethods();
            for (MethodScope methodScope : declaredMethods) {
                if (methodScope.getName() == null || methodScope.getName().isEmpty()) continue;
                ArrayList variables = new ArrayList();
                if (methodScope.isConstructor()) {
                    children.add(new PHPConstructorStructureItem(methodScope, variables));
                    continue;
                }
                children.add(new PHPMethodStructureItem(methodScope, variables));
            }
            Collection<? extends ClassConstantElement> declaredClsConstants = typeScope.getDeclaredConstants();
            for (ClassConstantElement classConstant : declaredClsConstants) {
                children.add(new PHPConstantStructureItem(classConstant, "con"));
            }
            if (typeScope instanceof ClassScope) {
                ClassScope classScope = (ClassScope)typeScope;
                declaredFields = classScope.getDeclaredFields();
                for (FieldElement fieldElement : declaredFields) {
                    children.add(new PHPFieldStructureItem(fieldElement));
                }
            }
            if (!(typeScope instanceof TraitScope)) continue;
            TraitScope traitScope = (TraitScope)typeScope;
            declaredFields = traitScope.getDeclaredFields();
            for (FieldElement fieldElement : declaredFields) {
                children.add(new PHPFieldStructureItem(fieldElement));
            }
        }
    }

    private boolean isDeprecatedType(String type, ModelElement modelElement) {
        boolean result = false;
        QualifiedName fullyQualifiedName = VariousUtils.getFullyQualifiedName(QualifiedName.create(type), modelElement.getOffset(), modelElement.getInScope());
        for (TypeElement typeElement : this.deprecatedTypes) {
            if (!typeElement.getFullyQualifiedName().equals(fullyQualifiedName)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected void appendName(ModelElement modelElement, HtmlFormatter formatter) {
        String name = modelElement.getName();
        if (CodeUtils.isSyntheticTypeName(name)) {
            name = "{}";
        }
        if (modelElement.isDeprecated()) {
            formatter.deprecated(true);
            formatter.appendText(name);
            formatter.deprecated(false);
        } else {
            formatter.appendText(name);
        }
    }

    private class PHPConstructorStructureItem
    extends PHPStructureItem {
        public PHPConstructorStructureItem(MethodScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "con");
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.CONSTRUCTOR;
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), formatter);
            return formatter.getText();
        }
    }

    private class PHPTraitStructureItem
    extends PHPStructureItem {
        private static final String PHP_TRAIT_ICON = "org/netbeans/modules/php/editor/resources/trait.png";
        private final Collection<? extends TraitScope> usedTraits;

        public PHPTraitStructureItem(ModelElement elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
            this.usedTraits = this.getTraitScope().getTraits();
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (traitIcon == null) {
                traitIcon = new ImageIcon(ImageUtilities.loadImage((String)PHP_TRAIT_ICON));
            }
            return traitIcon;
        }

        private TraitScope getTraitScope() {
            return (TraitScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            NavigatorScanner.this.appendName(this.getTraitScope(), formatter);
            if (this.usedTraits != null && this.usedTraits.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">#");
                this.appendUsedTraits(this.usedTraits, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPInterfaceStructureItem
    extends PHPStructureItem {
        private static final String PHP_INTERFACE_ICON = "org/netbeans/modules/php/editor/resources/interface.png";
        private final Collection<? extends InterfaceScope> interfaces;

        public PHPInterfaceStructureItem(InterfaceScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
            this.interfaces = this.getInterfaceScope().getSuperInterfaceScopes();
        }

        @Override
        public ImageIcon getCustomIcon() {
            if (interfaceIcon == null) {
                interfaceIcon = new ImageIcon(ImageUtilities.loadImage((String)PHP_INTERFACE_ICON));
            }
            return interfaceIcon;
        }

        private InterfaceScope getInterfaceScope() {
            return (InterfaceScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            NavigatorScanner.this.appendName(this.getInterfaceScope(), formatter);
            if (this.interfaces != null && this.interfaces.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">::");
                this.appendInterfaces(this.interfaces, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPMethodStructureItem
    extends PHPStructureItem {
        public PHPMethodStructureItem(MethodScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "fn");
        }

        public MethodScope getMethodScope() {
            return (MethodScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getMethodScope(), formatter);
            return formatter.getText();
        }
    }

    private class PHPFunctionStructureItem
    extends PHPStructureItem {
        public PHPFunctionStructureItem(FunctionScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "fn");
        }

        public FunctionScope getFunctionScope() {
            return (FunctionScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            this.appendFunctionDescription(this.getFunctionScope(), formatter);
            return formatter.getText();
        }
    }

    private class PHPConstantStructureItem
    extends PHPStructureItem {
        public PHPConstantStructureItem(ConstantElement elementHandle, String prefix) {
            super(elementHandle, null, prefix);
        }

        public ConstantElement getConstant() {
            return (ConstantElement)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            ConstantElement constant;
            String value;
            formatter.reset();
            if (this.getConstant().isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(this.getName());
            if (this.getConstant().isDeprecated()) {
                formatter.deprecated(false);
            }
            if ((value = (constant = this.getConstant()).getValue()) != null) {
                formatter.appendText(" ");
                formatter.appendHtml(NavigatorScanner.FONT_GRAY_COLOR);
                formatter.appendText(value);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPClassStructureItem
    extends PHPStructureItem {
        private final String superClassName;
        private final Collection<? extends InterfaceScope> interfaces;
        private final Collection<? extends TraitScope> usedTraits;

        public PHPClassStructureItem(ClassScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "cl");
            this.superClassName = ModelUtils.getFirst(this.getClassScope().getSuperClassNames());
            this.interfaces = this.getClassScope().getSuperInterfaceScopes();
            this.usedTraits = this.getClassScope().getTraits();
        }

        private ClassScope getClassScope() {
            return (ClassScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            NavigatorScanner.this.appendName(this.getClassScope(), formatter);
            if (this.superClassName != null) {
                formatter.appendHtml("<font color=\"#999999\">::");
                formatter.appendText(this.superClassName);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            if (this.interfaces != null && this.interfaces.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">:");
                this.appendInterfaces(this.interfaces, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            if (this.usedTraits != null && this.usedTraits.size() > 0) {
                formatter.appendHtml("<font color=\"#999999\">#");
                this.appendUsedTraits(this.usedTraits, formatter);
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private class PHPUseStructureItem
    extends PHPStructureItem {
        public PHPUseStructureItem(UseScope elementHandle) {
            super(elementHandle, null, "aaaa_use");
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            UseScope useElement = (UseScope)this.getElementHandle();
            String name = this.getName();
            boolean deprecatedType = NavigatorScanner.this.isDeprecatedType(name, useElement);
            if (deprecatedType) {
                formatter.deprecated(true);
            }
            formatter.appendText(name);
            AliasedName aliasedName = useElement.getAliasedName();
            if (aliasedName != null) {
                formatter.appendText(" as ");
                formatter.appendText(aliasedName.getAliasName());
            }
            if (deprecatedType) {
                formatter.deprecated(false);
            }
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.RULE;
        }
    }

    private class PHPNamespaceStructureItem
    extends PHPStructureItem {
        public PHPNamespaceStructureItem(NamespaceScope elementHandle, List<? extends StructureItem> children) {
            super(elementHandle, children, "namespace");
        }

        public NamespaceScope getNamespaceScope() {
            return (NamespaceScope)this.getModelElement();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.reset();
            if (this.getNamespaceScope().isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(this.getName());
            if (this.getNamespaceScope().isDeprecated()) {
                formatter.deprecated(false);
            }
            return formatter.getText();
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.MODULE;
        }
    }

    private class PHPSimpleStructureItem
    extends PHPStructureItem {
        private String simpleText;

        public PHPSimpleStructureItem(ModelElement elementHandle, String prefix) {
            super(elementHandle, null, prefix);
            this.simpleText = elementHandle.getName();
        }

        public String getHtml(HtmlFormatter formatter) {
            formatter.appendText(this.simpleText);
            return formatter.getText();
        }
    }

    private class PHPFieldStructureItem
    extends PHPSimpleStructureItem {
        public PHPFieldStructureItem(FieldElement elementHandle) {
            super(elementHandle, "field");
        }

        public FieldElement getField() {
            return (FieldElement)this.getElementHandle();
        }

        @Override
        public String getHtml(HtmlFormatter formatter) {
            Collection<? extends String> types;
            FieldElement field = this.getField();
            if (field.isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(field.getName());
            if (field.isDeprecated()) {
                formatter.deprecated(false);
            }
            if (!(types = field.getDefaultTypeNames()).isEmpty()) {
                formatter.appendHtml("<font color=\"#999999\">:");
                int i = 0;
                for (String string : types) {
                    boolean deprecatedType;
                    if (++i > 1) {
                        formatter.appendText(", ");
                    }
                    if (deprecatedType = NavigatorScanner.this.isDeprecatedType(string, field)) {
                        formatter.deprecated(true);
                    }
                    formatter.appendText(string);
                    if (!deprecatedType) continue;
                    formatter.deprecated(false);
                }
                formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
            }
            return formatter.getText();
        }
    }

    private abstract class PHPStructureItem
    implements StructureItem {
        private final ModelElement modelElement;
        private final List<? extends StructureItem> children;
        private final String sortPrefix;

        public PHPStructureItem(ModelElement elementHandle, List<? extends StructureItem> children, String sortPrefix) {
            this.modelElement = elementHandle;
            this.sortPrefix = sortPrefix;
            this.children = children != null ? children : Collections.emptyList();
        }

        public boolean equals(Object obj) {
            PHPStructureItem item;
            boolean thesame = false;
            if (obj instanceof PHPStructureItem && (item = (PHPStructureItem)obj).getName() != null && this.getName() != null) {
                thesame = item.modelElement.getName().equals(this.modelElement.getName()) && item.modelElement.getOffset() == this.modelElement.getOffset();
            }
            return thesame;
        }

        public int hashCode() {
            int hashCode = 11;
            if (this.getName() != null) {
                hashCode = 31 * this.getName().hashCode() + hashCode;
            }
            hashCode = (int)(31L * this.getPosition() + (long)hashCode);
            return hashCode;
        }

        public String getName() {
            return this.modelElement.getName();
        }

        public String getSortText() {
            return this.sortPrefix + this.modelElement.getName();
        }

        public ElementHandle getElementHandle() {
            return this.modelElement.getPHPElement();
        }

        public ModelElement getModelElement() {
            return this.modelElement;
        }

        public ElementKind getKind() {
            return this.modelElement.getPHPElement().getKind();
        }

        public Set<Modifier> getModifiers() {
            return this.modelElement.getPHPElement().getModifiers();
        }

        public boolean isLeaf() {
            return this.children.isEmpty();
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.modelElement.getOffset();
        }

        public long getEndPosition() {
            OffsetRange blockRange;
            if (this.modelElement instanceof Scope && (blockRange = ((Scope)this.modelElement).getBlockRange()) != null) {
                return blockRange.getEnd();
            }
            return this.modelElement.getNameRange().getEnd();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }

        protected void appendInterfaces(Collection<? extends InterfaceScope> interfaes, HtmlFormatter formatter) {
            boolean first = true;
            for (InterfaceScope interfaceScope : interfaes) {
                if (interfaceScope == null) continue;
                if (!first) {
                    formatter.appendText(", ");
                } else {
                    first = false;
                }
                NavigatorScanner.this.appendName(interfaceScope, formatter);
            }
        }

        protected void appendUsedTraits(Collection<? extends TraitScope> usedTraits, HtmlFormatter formatter) {
            boolean first = true;
            for (TraitScope traitScope : usedTraits) {
                if (!first) {
                    formatter.appendText(", ");
                } else {
                    first = false;
                }
                NavigatorScanner.this.appendName(traitScope, formatter);
            }
        }

        protected void appendFunctionDescription(FunctionScope function, HtmlFormatter formatter) {
            formatter.reset();
            if (function == null) {
                return;
            }
            if (function.isDeprecated()) {
                formatter.deprecated(true);
            }
            formatter.appendText(function.getName());
            if (function.isDeprecated()) {
                formatter.deprecated(false);
            }
            formatter.appendText("(");
            List<? extends ParameterElement> parameters = function.getParameters();
            if (parameters != null && parameters.size() > 0) {
                this.processParameters(function, formatter, parameters);
            }
            formatter.appendText(")");
            Collection<? extends String> returnTypes = function.getReturnTypeNames();
            if (!returnTypes.isEmpty()) {
                this.processReturnTypes(function, formatter, returnTypes);
            }
        }

        private void processParameters(FunctionScope function, HtmlFormatter formatter, List<? extends ParameterElement> parameters) {
            boolean first = true;
            for (ParameterElement parameterElement : parameters) {
                String name = parameterElement.getName();
                Set<TypeResolver> types = parameterElement.getTypes();
                if (name == null) continue;
                if (!first) {
                    formatter.appendText(", ");
                }
                if (!types.isEmpty()) {
                    formatter.appendHtml(NavigatorScanner.FONT_GRAY_COLOR);
                    int i = 0;
                    for (TypeResolver typeResolver : types) {
                        boolean deprecatedType;
                        QualifiedName typeName;
                        ++i;
                        if (!typeResolver.isResolved() || (typeName = typeResolver.getTypeName(false)) == null) continue;
                        if (i > 1) {
                            formatter.appendText("|");
                        }
                        if (deprecatedType = NavigatorScanner.this.isDeprecatedType(typeName.toString(), function)) {
                            formatter.deprecated(true);
                        }
                        formatter.appendText(typeName.toString());
                        if (!deprecatedType) continue;
                        formatter.deprecated(false);
                    }
                    formatter.appendText(" ");
                    formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
                }
                formatter.appendText(name);
                first = false;
            }
        }

        private void processReturnTypes(FunctionScope function, HtmlFormatter formatter, Collection<? extends String> returnTypes) {
            formatter.appendHtml("<font color=\"#999999\">:");
            int i = 0;
            for (String string : returnTypes) {
                boolean deprecatedType;
                if (++i > 1) {
                    formatter.appendText(", ");
                }
                if (deprecatedType = NavigatorScanner.this.isDeprecatedType(string.toString(), function)) {
                    formatter.deprecated(true);
                }
                formatter.appendText(string);
                if (!deprecatedType) continue;
                formatter.deprecated(false);
            }
            formatter.appendHtml(NavigatorScanner.CLOSE_FONT);
        }
    }
}

