/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.netbeans.lib.profiler.heap.HprofByteBuffer;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.LoadClass;
import org.netbeans.lib.profiler.heap.StackFrame;
import org.netbeans.lib.profiler.heap.TagBounds;

class StackFrameSegment
extends TagBounds {
    private static final int FRAME_DIV = 512;
    HprofHeap hprofHeap;
    final int methodIDOffset;
    final int stackFrameIDOffset;
    final int lengthOffset;
    final int sourceIDOffset;
    final int methodSignatureIDOffset;
    final int timeOffset;
    final int classSerialNumberOffset;
    final int lineNumberOffset;
    private Map idToFrame;
    private Map classCache = Collections.synchronizedMap(new LoadClassCache());

    StackFrameSegment(HprofHeap heap, long start, long end) {
        super(5, start, end);
        int idSize = heap.dumpBuffer.getIDSize();
        this.hprofHeap = heap;
        this.timeOffset = 1;
        this.lengthOffset = this.timeOffset + 4;
        this.stackFrameIDOffset = this.lengthOffset + 4;
        this.methodIDOffset = this.stackFrameIDOffset + idSize;
        this.methodSignatureIDOffset = this.methodIDOffset + idSize;
        this.sourceIDOffset = this.methodSignatureIDOffset + idSize;
        this.classSerialNumberOffset = this.sourceIDOffset + idSize;
        this.lineNumberOffset = this.classSerialNumberOffset + 4;
    }

    StackFrame getStackFrameByID(long stackFrameID) {
        this.initIdToFrame();
        Long initialOffset = (Long)this.idToFrame.get(new Long(stackFrameID / 512L));
        if (initialOffset == null) {
            initialOffset = new Long(this.startOffset);
        }
        long[] offset = new long[]{initialOffset};
        while (offset[0] < this.endOffset) {
            long start = offset[0];
            long frameID = this.readStackFrameTag(offset);
            if (frameID != stackFrameID) continue;
            return new StackFrame(this, start);
        }
        return null;
    }

    private HprofByteBuffer getDumpBuffer() {
        return this.hprofHeap.dumpBuffer;
    }

    private long readStackFrameTag(long[] offset) {
        long start = offset[0];
        if (this.hprofHeap.readTag(offset) != 4) {
            return 0L;
        }
        return this.getDumpBuffer().getID(start + (long)this.stackFrameIDOffset);
    }

    private synchronized void initIdToFrame() {
        if (this.idToFrame == null) {
            long[] offset = new long[]{this.startOffset};
            this.idToFrame = new HashMap();
            while (offset[0] < this.endOffset) {
                long start = offset[0];
                long frameID = this.readStackFrameTag(offset);
                Long frameIDMask = new Long(frameID / 512L);
                Long minOffset = (Long)this.idToFrame.get(frameIDMask);
                if (minOffset != null && minOffset <= start) continue;
                this.idToFrame.put(frameIDMask, new Long(start));
            }
        }
    }

    String getClassNameBySerialNumber(int classSerialNumber) {
        Integer classSerialNumberObj = classSerialNumber;
        String className = (String)this.classCache.get(classSerialNumberObj);
        if (className == null) {
            LoadClass loadClass = this.hprofHeap.getLoadClassSegment().getClassBySerialNumber(classSerialNumber);
            className = loadClass != null ? loadClass.getName() : "N/A";
            this.classCache.put(classSerialNumberObj, className);
        }
        return className;
    }

    private static class LoadClassCache
    extends LinkedHashMap {
        private static final int SIZE = 1000;

        LoadClassCache() {
            super(1000, 0.75f, true);
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 1000;
        }
    }
}

