/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import org.apache.tomcat.core.Request;

public class RequestUtil {
    private static final Locale loc = Locale.US;
    private static final TimeZone zone = TimeZone.getTimeZone("GMT");
    private static final String rfc1123Pattern = "EEE, dd MMM yyyyy HH:mm:ss z";
    private static final String rfc1036Pattern = "EEEEEEEEE, dd-MMM-yy HH:mm:ss z";
    private static final String asctimePattern = "EEE MMM d HH:mm:ss yyyyy";
    private static final SimpleDateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyyy HH:mm:ss z", loc);
    private static final SimpleDateFormat rfc1036Format = new SimpleDateFormat("EEEEEEEEE, dd-MMM-yy HH:mm:ss z", loc);
    private static final SimpleDateFormat asctimeFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyyy", loc);

    public static final String URLDecode(String str) throws NumberFormatException, StringIndexOutOfBoundsException {
        if (str == null) {
            return null;
        }
        StringBuffer dec = new StringBuffer();
        int strPos = 0;
        int strLen = str.length();
        dec.ensureCapacity(str.length());
        while (strPos < strLen) {
            int laPos = strPos;
            while (laPos < strLen) {
                char laChar = str.charAt(laPos);
                if (laChar == '+' || laChar == '%') break;
                ++laPos;
            }
            if (laPos > strPos) {
                dec.append(str.substring(strPos, laPos));
                strPos = laPos;
            }
            if (strPos >= strLen) break;
            char metaChar = str.charAt(strPos);
            if (metaChar == '+') {
                dec.append(' ');
                ++strPos;
                continue;
            }
            if (metaChar != '%') continue;
            dec.append((char)Integer.parseInt(str.substring(strPos + 1, strPos + 3), 16));
            strPos += 3;
        }
        return dec.toString();
    }

    public static void extractLocales(Hashtable languages, Vector q, Vector l) {
        Enumeration e = q.elements();
        while (e.hasMoreElements()) {
            Vector v = (Vector)languages.get(((Double)e.nextElement()).toString());
            Enumeration le = v.elements();
            while (le.hasMoreElements()) {
                String language = (String)le.nextElement();
                String country = "";
                int countryIndex = language.indexOf("-");
                if (countryIndex > -1) {
                    country = language.substring(countryIndex + 1).trim();
                    language = language.substring(0, countryIndex).trim();
                }
                l.addElement(new Locale(language, country));
            }
        }
    }

    public static String getCharsetFromContentType(String type) {
        if (type == null) {
            return null;
        }
        int semi = type.indexOf(";");
        if (semi == -1) {
            return null;
        }
        String afterSemi = type.substring(semi + 1);
        int charsetLocation = afterSemi.indexOf("charset=");
        if (charsetLocation == -1) {
            return null;
        }
        String afterCharset = afterSemi.substring(charsetLocation + 8);
        String encoding = afterCharset.trim();
        return encoding;
    }

    public static Locale getLocale(Request req) {
        String acceptLanguage = req.getHeader("Accept-Language");
        if (acceptLanguage == null) {
            return Locale.getDefault();
        }
        Hashtable languages = new Hashtable();
        Vector quality = new Vector();
        RequestUtil.processAcceptLanguage(acceptLanguage, languages, quality);
        if (languages.size() == 0) {
            return Locale.getDefault();
        }
        Vector l = new Vector();
        RequestUtil.extractLocales(languages, quality, l);
        return (Locale)l.elementAt(0);
    }

    public static Enumeration getLocales(HttpServletRequest req) {
        String acceptLanguage = req.getHeader("Accept-Language");
        if (acceptLanguage == null) {
            Vector<Locale> v = new Vector<Locale>();
            v.addElement(Locale.getDefault());
            return v.elements();
        }
        Hashtable languages = new Hashtable();
        Vector quality = new Vector();
        RequestUtil.processAcceptLanguage(acceptLanguage, languages, quality);
        if (languages.size() == 0) {
            Vector<Locale> v = new Vector<Locale>();
            v.addElement(Locale.getDefault());
            return v.elements();
        }
        Vector l = new Vector();
        RequestUtil.extractLocales(languages, quality, l);
        return l.elements();
    }

    public static BufferedReader getReader(Request request) throws IOException {
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = "8859_1";
        }
        InputStreamReader r = new InputStreamReader((InputStream)request.getInputStream(), encoding);
        return new BufferedReader(r);
    }

    public static Hashtable mergeParameters(Hashtable one, Hashtable two) {
        if (one.size() == 0) {
            return two;
        }
        if (two.size() == 0) {
            return one;
        }
        Hashtable combined = (Hashtable)one.clone();
        Enumeration e = two.keys();
        while (e.hasMoreElements()) {
            String[] combinedValue;
            String name = (String)e.nextElement();
            String[] oneValue = (String[])one.get(name);
            String[] twoValue = (String[])two.get(name);
            if (oneValue == null) {
                combinedValue = twoValue;
            } else {
                combinedValue = new String[oneValue.length + twoValue.length];
                System.arraycopy(oneValue, 0, combinedValue, 0, oneValue.length);
                System.arraycopy(twoValue, 0, combinedValue, oneValue.length, twoValue.length);
            }
            combined.put(name, combinedValue);
        }
        return combined;
    }

    public static void processAcceptLanguage(String acceptLanguage, Hashtable languages, Vector q) {
        StringTokenizer languageTokenizer = new StringTokenizer(acceptLanguage, ",");
        while (languageTokenizer.hasMoreTokens()) {
            Vector v;
            String language = languageTokenizer.nextToken().trim();
            int qValueIndex = language.indexOf(59);
            int qIndex = language.indexOf(113);
            int equalIndex = language.indexOf(61);
            Double qValue = new Double(1.0);
            if (qValueIndex > -1 && qValueIndex < qIndex && qIndex < equalIndex) {
                String qValueStr = language.substring(qValueIndex + 1);
                language = language.substring(0, qValueIndex);
                qValueStr = qValueStr.trim().toLowerCase();
                qValueIndex = qValueStr.indexOf(61);
                qValue = new Double(0.0);
                if (qValueStr.startsWith("q") && qValueIndex > -1) {
                    qValueStr = qValueStr.substring(qValueIndex + 1);
                    try {
                        qValue = new Double(qValueStr.trim());
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            if (language.equals("*")) continue;
            String key = qValue.toString();
            if (languages.containsKey(key)) {
                v = (Vector)languages.get(key);
            } else {
                v = new Vector();
                q.addElement(qValue);
            }
            v.addElement(language);
            languages.put(key, v);
        }
    }

    public static void processCookies(Request request, Vector cookies) {
        String cookieString = request.getHeader("cookie");
        if (cookieString != null) {
            StringTokenizer tok = new StringTokenizer(cookieString, ";", false);
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int i = token.indexOf("=");
                if (i <= -1) continue;
                String name = token.substring(0, i).trim();
                String value = token.substring(i + 1, token.length()).trim();
                value = RequestUtil.stripQuote(value);
                Cookie cookie = new Cookie(name, value);
                cookies.addElement(cookie);
            }
        }
    }

    public static void processFormData(String data, Hashtable parameters) {
        if (data == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(data, "&", false);
        while (tok.hasMoreTokens()) {
            String[] values;
            String pair = tok.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) continue;
            String key = RequestUtil.unUrlDecode(pair.substring(0, pos));
            String value = RequestUtil.unUrlDecode(pair.substring(pos + 1, pair.length()));
            if (parameters.containsKey(key)) {
                String[] oldValues = (String[])parameters.get(key);
                values = new String[oldValues.length + 1];
                int i = 0;
                while (i < oldValues.length) {
                    values[i] = oldValues[i];
                    ++i;
                }
                values[oldValues.length] = value;
            } else {
                values = new String[]{value};
            }
            parameters.put(key, values);
        }
    }

    public static int readData(InputStream in, byte[] buf, int length) {
        int read = 0;
        try {
            while ((read += in.read(buf, read, length - read)) < length && read != -1) {
            }
        }
        catch (IOException iOException) {}
        return read;
    }

    public static Hashtable readFormData(Request request) {
        String contentType = request.getContentType();
        if (contentType != null) {
            if (contentType.indexOf(";") > 0) {
                contentType = contentType.substring(0, contentType.indexOf(";"));
            }
            contentType = contentType.toLowerCase().trim();
        }
        int contentLength = request.getContentLength();
        if (contentType != null && contentType.startsWith("application/x-www-form-urlencoded")) {
            try {
                ServletInputStream is = request.getFacade().getInputStream();
                Hashtable postParameters = HttpUtils.parsePostData((int)contentLength, (ServletInputStream)is);
                return postParameters;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private static String stripQuote(String value) {
        if (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'")) {
            try {
                return value.substring(1, value.length() - 1);
            }
            catch (Exception exception) {
            }
        }
        return value;
    }

    public static long toDate(String dateString) {
        Date date = null;
        try {
            date = rfc1123Format.parse(dateString);
        }
        catch (ParseException parseException) {}
        if (date == null) {
            try {
                date = rfc1036Format.parse(dateString);
            }
            catch (ParseException parseException) {}
        }
        if (date == null) {
            try {
                date = asctimeFormat.parse(dateString);
            }
            catch (ParseException parseException) {}
        }
        if (date == null) {
            return -1L;
        }
        return date.getTime();
    }

    public static String unUrlDecode(String data) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < data.length()) {
            char c = data.charAt(i);
            switch (c) {
                case '+': {
                    buf.append(' ');
                    break;
                }
                case '%': {
                    try {
                        buf.append((char)Integer.parseInt(data.substring(i + 1, i + 3), 16));
                        i += 2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String msg = "Decode error ";
                        throw new IllegalArgumentException(msg);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        String rest = data.substring(i);
                        buf.append(rest);
                        if (rest.length() != 2) break;
                        ++i;
                        break;
                    }
                }
                default: {
                    buf.append(c);
                    break;
                }
            }
            ++i;
        }
        return buf.toString();
    }
}

