/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.builds;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.builds.TargetEditor;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.settings.MakeSettings;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class MakeExecSupport
extends ExecutionSupport {
    private Sheet.Set sheetSet;
    public static final String PROP_BUILD_DIRECTORY = "buildDirectory";
    public static final String PROP_MAKE_COMMAND = "makeCommand";
    public static final String PROP_MAKE_OPTIONS = "makeOptions";
    public static final String PROP_MAKE_TARGETS = "makeTargets";
    private static final String PROP_ENVIRONMENT = "environment";
    private PropertySupport<String> buildDirectoryProperty = null;
    private PropertySupport<String> makeCommandProperty = null;
    private PropertySupport<String> makeOptionsProperty = null;
    private PropertySupport<String> makeTargetsProperty = null;
    private PropertySupport<String> makeEnvironmentProperty = null;
    private static final ResourceBundle bundle = NbBundle.getBundle(MakeExecSupport.class);

    public MakeExecSupport(MultiDataObject.Entry entry) {
        super(entry);
    }

    public FileObject getFileObject() {
        return this.getEntry().getFile();
    }

    public void createProperties() {
        if (this.buildDirectoryProperty == null) {
            this.buildDirectoryProperty = this.createBuildDirectoryProperty();
            this.makeCommandProperty = this.createMakeCommandProperty();
            this.makeOptionsProperty = this.createMakeOptionsProperty();
            this.makeTargetsProperty = this.createMakeTargetsProperty();
            this.makeEnvironmentProperty = this.createEnvironmentProperty(PROP_ENVIRONMENT, MakeExecSupport.getString("PROP_MAKE_ENVIRONMENT"), MakeExecSupport.getString("HINT_MAKE_ENVIRONMENT"));
        }
    }

    @Override
    public void addProperties(Sheet.Set set) {
        this.createProperties();
        this.sheetSet = set;
        set.put(this.buildDirectoryProperty);
        set.put(this.makeCommandProperty);
        set.put(this.makeOptionsProperty);
        set.put(this.makeTargetsProperty);
        set.put(this.makeEnvironmentProperty);
    }

    private PropertySupport<String> createBuildDirectoryProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_BUILD_DIRECTORY, String.class, MakeExecSupport.getString("PROP_BUILD_DIRECTORY"), MakeExecSupport.getString("HINT_BUILD_DIRECTORY")){

            public String getValue() {
                return MakeExecSupport.this.getBuildDirectory();
            }

            public void setValue(String val) {
                MakeExecSupport.this.setBuildDirectory(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getBuildDirectory() {
        String dir = (String)this.getEntry().getFile().getAttribute(PROP_BUILD_DIRECTORY);
        if (dir == null) {
            dir = MakeSettings.getDefault().getDefaultBuildDirectory();
            this.setBuildDirectory(dir);
        }
        return dir;
    }

    public void setBuildDirectory(String dir) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_BUILD_DIRECTORY, (Object)dir);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createMakeCommandProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_MAKE_COMMAND, String.class, MakeExecSupport.getString("PROP_MAKE_COMMAND"), MakeExecSupport.getString("HINT_MAKE_COMMAND")){

            public String getValue() {
                return MakeExecSupport.this.getMakeCommand();
            }

            public void setValue(String val) {
                MakeExecSupport.this.setMakeCommand(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getMakeCommand() {
        String make = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_COMMAND);
        if (make == null || make.equals("")) {
            make = MakeSettings.getDefault().getDefaultMakeCommand();
            this.setMakeCommand(make);
        }
        return make;
    }

    public void setMakeCommand(String make) {
        block2: {
            try {
                this.getEntry().getFile().setAttribute(PROP_MAKE_COMMAND, (Object)make);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createMakeOptionsProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_MAKE_OPTIONS, String.class, MakeExecSupport.getString("PROP_MAKE_OPTIONS"), MakeExecSupport.getString("HINT_MAKE_OPTIONS")){

            public String getValue() {
                return MakeExecSupport.this.getMakeOptions(false);
            }

            public void setValue(String val) {
                MakeExecSupport.this.setMakeOptions(val);
            }

            public boolean supportsDefaultValue() {
                return true;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }
        };
    }

    public String getMakeOptions() {
        return this.getMakeOptions(false);
    }

    public String getMakeOptions(boolean useCustomizer) {
        StringBuilder options = new StringBuilder(256);
        String savedOptions = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_OPTIONS);
        if (savedOptions == null) {
            savedOptions = "";
            this.setMakeOptions(savedOptions);
        }
        options.append(savedOptions);
        return options.toString();
    }

    public void setMakeOptions(String options) {
        block2: {
            FileObject fo = this.getEntry().getFile();
            try {
                fo.setAttribute(PROP_MAKE_OPTIONS, (Object)options);
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block2;
                ex.printStackTrace();
            }
        }
    }

    private PropertySupport<String> createMakeTargetsProperty() {
        return new PropertySupport.ReadWrite<String>(PROP_MAKE_TARGETS, String.class, MakeExecSupport.getString("PROP_MAKE_TARGETS"), MakeExecSupport.getString("HINT_MAKE_TARGETS")){

            public String getValue() {
                return MakeExecSupport.this.getMakeTargets();
            }

            public void setValue(String val) {
                MakeExecSupport.this.setMakeTargets(val);
            }

            public boolean supportsDefaultValue() {
                return false;
            }

            public void restoreDefaultValue() {
                this.setValue(null);
            }

            public boolean canWrite() {
                return MakeExecSupport.this.getEntry().getFile().getParent().canWrite();
            }

            public PropertyEditor getPropertyEditor() {
                return new TargetsPropertyEditor((PropertySupport<String>)this);
            }
        };
    }

    public String getMakeTargets() {
        String target = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_TARGETS);
        if (target == null) {
            target = "";
            this.setMakeTargets(target);
        }
        return target;
    }

    private String[] tokenizeTargets(String targets) {
        StringTokenizer st = new StringTokenizer(targets, ";:,");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            int n = 0;
            String t = st.nextToken();
            while (n < t.length() && Character.isWhitespace(t.charAt(n)) && ++n < t.length()) {
            }
            if (n >= t.length()) continue;
            if (n > 0) {
                v.add(t.substring(n));
                continue;
            }
            v.add(t);
        }
        String[] ret = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            ret[i] = (String)v.get(i);
        }
        return ret;
    }

    public String[] getMakeTargetsArray() {
        return this.tokenizeTargets(this.getMakeTargets());
    }

    public void setMakeTargets(String targetlist) {
        block3: {
            FileObject fo = this.getEntry().getFile();
            try {
                fo.setAttribute(PROP_MAKE_TARGETS, (Object)targetlist);
                if (this.sheetSet != null) {
                    this.sheetSet.remove(PROP_MAKE_TARGETS);
                    this.sheetSet.put(this.makeTargetsProperty);
                }
            }
            catch (IOException ex) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) break block3;
                ex.printStackTrace();
            }
        }
    }

    public void addMakeTargets(String newtargets) {
        String targets = (String)this.getEntry().getFile().getAttribute(PROP_MAKE_TARGETS);
        if (newtargets == null || newtargets.length() == 0) {
            return;
        }
        if (targets == null) {
            targets = "";
        }
        targets = targets.length() == 0 ? newtargets : targets + ", " + newtargets;
        this.setMakeTargets(targets);
    }

    private static String getString(String prop) {
        return bundle.getString(prop);
    }

    class TargetsPropertyEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertySupport<String> prop = null;
        private PropertyEnv env;

        TargetsPropertyEditor(PropertySupport<String> prop) {
            this.prop = prop;
        }

        @Override
        public Component getCustomEditor() {
            String val;
            try {
                val = (String)this.prop.getValue();
            }
            catch (Exception e) {
                val = "";
            }
            return new TargetEditor(MakeExecSupport.this.tokenizeTargets(val), this, this.env);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }
}

