/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remotefs.versioning.api;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.remotefs.versioning.api.ExportDiffPanel;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public abstract class ExportDiffSupport {
    private AbstractExportDiffPanel panel;
    private DialogDescriptor dd;
    private final Preferences preferences;
    private Dialog dialog;
    private ExportDiffProvider exportDiffProvider;
    private final VCSFileProxy[] files;

    public ExportDiffSupport(VCSFileProxy[] files, Preferences preferences) {
        this.preferences = preferences;
        this.files = files;
    }

    protected void createComplexDialog(AbstractExportDiffPanel insidePanel) {
        this.dd = new DialogDescriptor((Object)insidePanel, NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
    }

    protected AbstractExportDiffPanel createSimpleDialog(String currentFilePath) {
        VCSFileProxy to = VCSFileProxySupport.getResource(this.files[0], currentFilePath);
        this.dd = new DialogDescriptor((Object)this.createFileChooser(to), NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
        this.dd.setOptions(new Object[0]);
        this.panel = new ExportDiffPanel(new JPanel());
        this.panel.setOutputFileText("");
        return this.panel;
    }

    protected DialogDescriptor getDialogDescriptor() {
        return this.dd;
    }

    private void initializePanels() {
        this.exportDiffProvider = (ExportDiffProvider)Lookup.getDefault().lookup(ExportDiffProvider.class);
        String currentFilePath = this.preferences.get("ExportDiff.saveFolder", System.getProperty("user.home"));
        if (this.exportDiffProvider == null) {
            this.panel = this.createSimpleDialog(currentFilePath);
            this.dd = this.getDialogDescriptor();
        } else {
            this.exportDiffProvider.setContext(this.files);
            ExportDiffPanel edPanel = new ExportDiffPanel(this.exportDiffProvider.createComponent());
            edPanel.setOutputFileText(currentFilePath);
            this.exportDiffProvider.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("ExportDiff.data.changed")) {
                        ExportDiffSupport.this.validate();
                    }
                }
            });
            edPanel.asFileRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDiffSupport.this.validate();
                }
            });
            edPanel.attachRadioButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExportDiffSupport.this.validate();
                }
            });
            this.panel = edPanel;
            this.createComplexDialog(this.panel);
            this.dd = this.getDialogDescriptor();
        }
        this.panel.addOutputFileTextDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ExportDiffSupport.this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ExportDiffSupport.this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ExportDiffSupport.this.validate();
            }
        });
        this.panel.addBrowseActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String file = ExportDiffSupport.this.panel.getOutputFileText().trim();
                if (file.isEmpty()) {
                    file = "/";
                }
                ExportDiffSupport.this.onChooseFile(VCSFileProxySupport.getResource(ExportDiffSupport.this.files[0], file));
            }
        });
    }

    private void validate() {
        assert (this.panel != null);
        if (this.exportDiffProvider == null || this.panel.isFileOutputSelected()) {
            String path = this.panel.getOutputFileText().trim();
            if (path.isEmpty() || !path.startsWith("/")) {
                this.dd.setValid(false);
            } else {
                VCSFileProxy f = VCSFileProxySupport.getResource(this.files[0], path);
                this.dd.setValid(!f.isDirectory());
            }
        } else {
            this.dd.setValid(this.exportDiffProvider.isValid());
        }
    }

    public void export() {
        this.initializePanels();
        this.validate();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.dd);
        this.dialog.setVisible(true);
        if (this.dd.getValue() == DialogDescriptor.OK_OPTION) {
            if (this.exportDiffProvider == null || ((ExportDiffPanel)this.panel).asFileRadioButton.isSelected()) {
                final VCSFileProxy toFile = VCSFileProxySupport.getResource(this.files[0], this.panel.getOutputFileText());
                Utils.createTask((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ExportDiffSupport.this.writeDiffFile(toFile.normalizeFile());
                    }
                }).schedule(0);
            } else {
                final RequestProcessor.Task[] t = new RequestProcessor.Task[1];
                Cancellable c = new Cancellable(){

                    public boolean cancel() {
                        if (t[0] != null) {
                            return t[0].cancel();
                        }
                        return true;
                    }
                };
                final ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.getMessage("CTL_Attaching"), (Cancellable)c);
                handle.start();
                t[0] = Utils.createTask((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            VCSFileProxy toFile;
                            try {
                                toFile = ExportDiffSupport.this.createTempFile();
                            }
                            catch (IOException ex) {
                                handle.finish();
                                return;
                            }
                            ExportDiffSupport.this.writeDiffFile(toFile);
                            if (toFile.exists()) {
                                ExportDiffSupport.this.exportDiffProvider.handleDiffFile(toFile);
                            }
                        }
                        finally {
                            handle.finish();
                        }
                    }
                });
                t[0].schedule(0);
            }
        }
    }

    protected VCSFileProxy createTempFile() throws IOException {
        return VCSFileProxySupport.createTempFile(this.files[0], "vcs-diff", ".patch", true);
    }

    protected String getMessage(String resourceName) {
        return NbBundle.getMessage(ExportDiffSupport.class, (String)resourceName);
    }

    protected FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith("diff") || f.getName().endsWith("patch") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(ExportDiffSupport.class, (String)"BK3002");
            }
        };
    }

    protected VCSFileProxy getTargetFile(VCSFileProxy target) {
        String name = target.getName();
        boolean requiredExt = false;
        requiredExt |= name.endsWith(".diff");
        requiredExt |= name.endsWith(".dif");
        if (!(requiredExt |= name.endsWith(".patch"))) {
            VCSFileProxy parent = target.getParentFile();
            target = VCSFileProxy.createFileProxy((VCSFileProxy)parent, (String)(name + ".patch"));
        }
        return target;
    }

    public abstract void writeDiffFile(VCSFileProxy var1);

    private void onChooseFile(VCSFileProxy currentDir) {
        JFileChooser chooser = this.createFileChooser(currentDir);
        DialogDescriptor chooseFileDescriptor = new DialogDescriptor((Object)chooser, this.getMessage("CTL_Export_Title"));
        chooseFileDescriptor.setOptions(new Object[0]);
        this.dialog = DialogDisplayer.getDefault().createDialog(chooseFileDescriptor);
        this.dialog.setVisible(true);
    }

    private JFileChooser createFileChooser(VCSFileProxy curentDir) {
        final JFileChooser chooser = VCSFileProxySupport.createFileChooser(curentDir);
        chooser.setDialogTitle(NbBundle.getMessage(ExportDiffSupport.class, (String)"CTL_Export_Title"));
        chooser.setMultiSelectionEnabled(false);
        FileFilter[] old = chooser.getChoosableFileFilters();
        for (int i = 0; i < old.length; ++i) {
            FileFilter fileFilter = old[i];
            chooser.removeChoosableFileFilter(fileFilter);
        }
        chooser.addChoosableFileFilter(this.getFileFilter());
        chooser.setDialogType(1);
        chooser.setApproveButtonMnemonic(NbBundle.getMessage(ExportDiffSupport.class, (String)"MNE_Export_ExportAction").charAt(0));
        chooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    VCSFileProxy destination = VCSFileProxySupport.getSelectedFile(chooser);
                    if ((destination = ExportDiffSupport.this.getTargetFile(destination)).exists()) {
                        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ExportDiffSupport.class, (String)"BK3005", (Object)destination.getPath()));
                        nd.setOptionType(0);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                        if (!nd.getValue().equals(NotifyDescriptor.OK_OPTION)) {
                            return;
                        }
                    }
                    ExportDiffSupport.this.preferences.put("ExportDiff.saveFolder", destination.getParentFile().getPath());
                    ExportDiffSupport.this.panel.setOutputFileText(destination.getPath());
                } else {
                    ExportDiffSupport.this.dd.setValue(null);
                }
                if (ExportDiffSupport.this.dialog != null) {
                    ExportDiffSupport.this.dialog.dispose();
                }
            }
        });
        return chooser;
    }

    public static abstract class AbstractExportDiffPanel
    extends JPanel {
        public abstract String getOutputFileText();

        public abstract void setOutputFileText(String var1);

        public abstract void addOutputFileTextDocumentListener(DocumentListener var1);

        public abstract void addBrowseActionListener(ActionListener var1);

        public boolean isFileOutputSelected() {
            return true;
        }
    }

    public static abstract class ExportDiffProvider {
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private static final String EVENT_DATA_CHANGED = "ExportDiff.data.changed";

        protected abstract void setContext(VCSFileProxy[] var1);

        public abstract void handleDiffFile(VCSFileProxy var1);

        public abstract JComponent createComponent();

        public abstract boolean isValid();

        protected void fireDataChanged() {
            this.support.firePropertyChange(EVENT_DATA_CHANGED, null, null);
        }

        public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }
    }
}

