/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.filesystems.FileObject;

public class GitRepositories {
    private static GitRepositories instance;
    private final Set<VCSFileProxy> repositories = new HashSet<VCSFileProxy>();
    private final Set<VCSFileProxy> closed = new HashSet<VCSFileProxy>(5);
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    public static final String PROP_REPOSITORIES = "GitRemoteRepositories.repositories";

    public static synchronized GitRepositories getInstance() {
        if (instance == null) {
            instance = new GitRepositories();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(VCSFileProxy repository, boolean byUser) {
        boolean added;
        if (!byUser && this.closed.contains(repository)) {
            return;
        }
        try {
            if (VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)VCSFileProxy.createFileProxy((FileObject)VCSFileProxySupport.getFileSystem((VCSFileProxy)repository).getTempFolder()), (VCSFileProxy)repository)) {
                return;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        HashSet<VCSFileProxy> oldValues = null;
        HashSet<VCSFileProxy> newValues = null;
        Set<VCSFileProxy> set = this.repositories;
        synchronized (set) {
            added = this.repositories.add(repository);
            if (added) {
                newValues = new HashSet<VCSFileProxy>(this.repositories);
            }
        }
        if (added) {
            this.closed.remove(repository);
            oldValues = new HashSet<VCSFileProxy>(newValues);
            oldValues.remove(repository);
            this.support.firePropertyChange(PROP_REPOSITORIES, oldValues, newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(VCSFileProxy repository, boolean byUser) {
        boolean removed;
        HashSet<VCSFileProxy> oldValues = null;
        HashSet<VCSFileProxy> newValues = null;
        Set<VCSFileProxy> set = this.repositories;
        synchronized (set) {
            removed = this.repositories.remove(repository);
            if (removed) {
                newValues = new HashSet<VCSFileProxy>(this.repositories);
                if (byUser) {
                    this.closed.add(repository);
                }
            }
        }
        if (removed) {
            oldValues = new HashSet<VCSFileProxy>(newValues);
            oldValues.add(repository);
            this.support.firePropertyChange(PROP_REPOSITORIES, oldValues, newValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VCSFileProxy> getKnownRepositories() {
        Set<VCSFileProxy> set = this.repositories;
        synchronized (set) {
            return new HashSet<VCSFileProxy>(this.repositories);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener list) {
        this.support.addPropertyChangeListener(list);
    }

    public void removePropertyChangeListener(PropertyChangeListener list) {
        this.support.removePropertyChangeListener(list);
    }
}

