/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.SearchCriteria;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.NbBundle;

public class HistoryRegistry {
    private static HistoryRegistry instance;
    private static final Logger LOG;
    private final Map<VCSFileProxy, List<GitRevisionInfo>> logs = Collections.synchronizedMap(new HashMap());
    private final Map<VCSFileProxy, Map<String, List<GitRevisionInfo.GitFileInfo>>> changesets = new HashMap<VCSFileProxy, Map<String, List<GitRevisionInfo.GitFileInfo>>>();

    public static synchronized HistoryRegistry getInstance() {
        if (instance == null) {
            instance = new HistoryRegistry();
        }
        return instance;
    }

    private HistoryRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GitRevisionInfo[] getLogs(VCSFileProxy repository, VCSFileProxy[] files, Date from, Date to, ProgressMonitor pm) throws GitException {
        GitClient client = Git.getInstance().getClient(repository);
        SearchCriteria crit = new SearchCriteria();
        crit.setFrom(from);
        crit.setTo(to);
        crit.setRevisionTo("HEAD");
        crit.setFiles(files);
        crit.setFollowRenames(true);
        crit.setIncludeMerges(false);
        try {
            GitRevisionInfo[] history = client.log(crit, false, pm);
            if (!pm.isCanceled() && history.length > 0) {
                for (GitRevisionInfo gitRevisionInfo : files) {
                    this.logs.put((VCSFileProxy)gitRevisionInfo, Arrays.asList(history));
                }
            }
            GitRevisionInfo[] gitRevisionInfoArray = history;
            return gitRevisionInfoArray;
        }
        finally {
            client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VCSFileProxy getHistoryFile(final VCSFileProxy repository, final VCSFileProxy originalFile, final String revision, final boolean dryTry) {
        VCSFileProxy vCSFileProxy;
        block8: {
            String originalPath;
            long t;
            block6: {
                block7: {
                    t = System.currentTimeMillis();
                    originalPath = GitUtils.getRelativePath(repository, originalFile);
                    try {
                        final List<GitRevisionInfo> history = this.logs.get(originalFile);
                        final String path = originalPath;
                        Map<String, List<GitRevisionInfo.GitFileInfo>> fileChangesets = this.changesets.get(originalFile);
                        if (fileChangesets == null) {
                            fileChangesets = new HashMap<String, List<GitRevisionInfo.GitFileInfo>>();
                            this.changesets.put(originalFile, fileChangesets);
                        }
                        final Map<String, List<GitRevisionInfo.GitFileInfo>> fcs = fileChangesets;
                        final String[] ret = new String[]{null};
                        if (history != null) {
                            GitProgressSupport support = new GitProgressSupport(){

                                @Override
                                protected void perform() {
                                    ret[0] = HistoryRegistry.this.getRepositoryPathIntern(history, revision, fcs, repository, originalFile, path, dryTry, this.getProgressHandle(), this.getProgressMonitor());
                                }
                            };
                            support.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(HistoryRegistry.class, (String)"LBL_LookingUp")).waitFinished();
                        }
                        if (ret[0] == null || ret[0].equals(originalPath)) break block6;
                        vCSFileProxy = VCSFileProxy.createFileProxy((VCSFileProxy)repository, (String)ret[0]);
                        if (!LOG.isLoggable(Level.FINE)) break block7;
                    }
                    catch (Throwable throwable) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
                        }
                        throw throwable;
                    }
                    LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
                }
                return vCSFileProxy;
            }
            vCSFileProxy = null;
            if (!LOG.isLoggable(Level.FINE)) break block8;
            LOG.log(Level.FINE, " resolving historyFile for {0} took {1}", new Object[]{originalPath, System.currentTimeMillis() - t});
        }
        return vCSFileProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRepositoryPathIntern(List<GitRevisionInfo> history, String revision, Map<String, List<GitRevisionInfo.GitFileInfo>> fileChangesets, VCSFileProxy repository, VCSFileProxy originalFile, String path, boolean dryTry, ProgressHandle progressHandle, ProgressMonitor pm) {
        GitRevisionInfo lm;
        String historyRevision;
        int count = 0;
        String historyPath = path;
        Iterator<GitRevisionInfo> it = history.iterator();
        while (it.hasNext() && !revision.equals(it.next().getRevision())) {
            ++count;
        }
        progressHandle.switchToDeterminate(count);
        block6: for (int i = 0; i < history.size() && !pm.isCanceled() && !(historyRevision = (lm = history.get(i)).getRevision()).equals(revision); ++i) {
            progressHandle.progress(NbBundle.getMessage(HistoryRegistry.class, (String)"LBL_LookingUpAtRevision", (Object)originalFile.getName(), (Object)historyRevision), i);
            List<Object> changePaths = fileChangesets.get(historyRevision);
            if (changePaths == null && !dryTry) {
                long t1 = System.currentTimeMillis();
                Map cps = null;
                GitClient client = null;
                try {
                    client = Git.getInstance().getClient(repository);
                    GitRevisionInfo lms = client.log(historyRevision, pm);
                    assert (lms != null);
                    cps = lms.getModifiedFiles();
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                changePaths = cps == null ? Collections.emptyList() : new ArrayList(cps.values());
                fileChangesets.put(historyRevision, changePaths);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, " loading changePaths for {0} took {1}", new Object[]{historyRevision, System.currentTimeMillis() - t1});
                }
            }
            if (changePaths == null) continue;
            for (GitRevisionInfo.GitFileInfo cp : changePaths) {
                String copy = cp.getOriginalPath();
                if (copy == null || !historyPath.equals(cp.getRelativePath())) continue;
                historyPath = copy;
                continue block6;
            }
        }
        return pm.isCanceled() ? path : historyPath;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.mercurial.HistoryRegistry");
    }
}

