/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.branch;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class DeleteBranchAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(DeleteBranchAction.class.getName());

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        throw new UnsupportedOperationException();
    }

    public void deleteBranch(VCSFileProxy repository, final String branchName) {
        NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteBranchAction.class, (String)"MSG_DeleteBranchAction.confirmation", (Object)branchName), NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction.confirmation"), 2, 3);
        if (NotifyDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)nd)) {
            GitProgressSupport supp = new GitProgressSupport(){

                @Override
                protected void perform() {
                    try {
                        boolean cont;
                        GitClient client = this.getClient();
                        boolean forceDelete = false;
                        do {
                            try {
                                if (LOG.isLoggable(Level.FINE)) {
                                    LOG.log(Level.FINE, "Deleting a branch: {0}/{1}", new Object[]{branchName, forceDelete});
                                }
                                client.deleteBranch(branchName, forceDelete, this.getProgressMonitor());
                                cont = false;
                            }
                            catch (GitException.NotMergedException ex) {
                                cont = forceDelete = this.handleException(ex);
                            }
                        } while (cont);
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                }

                private boolean handleException(GitException.NotMergedException ex) {
                    NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(DeleteBranchAction.class, (String)"MSG_DeleteBranchAction.notMerged", (Object)ex.getUnmergedRevision()), NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction.notMerged"), 0, 3);
                    return NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            };
            supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(DeleteBranchAction.class, (String)"LBL_DeleteBranchAction.progressName", (Object)branchName));
        }
    }
}

