/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Color;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class SectionPanel
extends JPanel {
    final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    final boolean isNimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());
    final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private JPanel actionsPanel;
    private final JPanel dummyContentPanel = new JPanel();
    private JPanel headerPanel;
    private JLabel jLabel1;
    private JLabel lblTitle;
    private JComponent content = this.dummyContentPanel;

    public SectionPanel() {
        this.initComponents();
        Color c = this.getHeaderBackground();
        this.headerPanel.setBackground(c);
    }

    public void setLabel(String label) {
        this.lblTitle.setText(label);
    }

    public String getLabel() {
        return this.lblTitle.getText();
    }

    public void setContent(JComponent content) {
        ((GroupLayout)this.getLayout()).replace(this.content, content);
        this.content = content;
    }

    public JLabel getLabelComponent() {
        return this.lblTitle;
    }

    public void setActions(Action[] sectionActions) {
        ActionsBuilder builder = new ActionsBuilder(this.actionsPanel);
        for (Action action : sectionActions) {
            builder.addAction(action);
        }
        builder.finish();
    }

    private Color getHeaderBackground() {
        if (this.isAqua) {
            Color defBk = UIManager.getColor("NbExplorerView.background");
            if (null == defBk) {
                defBk = Color.gray;
            }
            return new Color(defBk.getRed() - 10, defBk.getGreen() - 10, defBk.getBlue() - 10);
        }
        if (this.isGTK || this.isNimbus) {
            return new Color(UIManager.getColor("Menu.background").getRGB());
        }
        return UIManager.getColor("PropSheet.setBackground");
    }

    private void initComponents() {
        this.headerPanel = new JPanel();
        this.actionsPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.lblTitle = new JLabel();
        GroupLayout dummyContentPanelLayout = new GroupLayout(this.dummyContentPanel);
        this.dummyContentPanel.setLayout(dummyContentPanelLayout);
        dummyContentPanelLayout.setHorizontalGroup(dummyContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 371, Short.MAX_VALUE));
        dummyContentPanelLayout.setVerticalGroup(dummyContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.headerPanel.setBackground(this.getHeaderBackground());
        this.actionsPanel.setOpaque(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)" ");
        GroupLayout actionsPanelLayout = new GroupLayout(this.actionsPanel);
        this.actionsPanel.setLayout(actionsPanelLayout);
        actionsPanelLayout.setHorizontalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1));
        actionsPanelLayout.setVerticalGroup(actionsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(actionsPanelLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jLabel1)));
        Mnemonics.setLocalizedText((JLabel)this.lblTitle, (String)NbBundle.getBundle((String)"org.netbeans.modules.bugtracking.commons.Bundle2", (Locale)Locale.getDefault(), (ClassLoader)SectionPanel.class.getClassLoader()).getString("SectionPanel.title"));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.lblTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.actionsPanel, -2, -1, -2).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.actionsPanel, -1, -1, Short.MAX_VALUE).addComponent(this.lblTitle))));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.dummyContentPanel, -1, -1, Short.MAX_VALUE)).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.headerPanel, -2, -1, -2).addGap(9, 9, 9).addComponent(this.dummyContentPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private static class ActionsBuilder {
        private final GroupLayout.SequentialGroup horizontalSeqGroup;
        private final GroupLayout.ParallelGroup verticalParallelGroup;
        private boolean notEmpty = false;

        public ActionsBuilder(JPanel panel) {
            panel.removeAll();
            GroupLayout layout = (GroupLayout)panel.getLayout();
            this.horizontalSeqGroup = layout.createSequentialGroup();
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.horizontalSeqGroup));
            this.verticalParallelGroup = layout.createParallelGroup(GroupLayout.Alignment.BASELINE);
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(this.verticalParallelGroup));
        }

        private void addAction(Action action) {
            String name = (String)action.getValue("Name");
            LinkButton btn = new LinkButton(name);
            btn.addActionListener(action);
            if (this.notEmpty) {
                JLabel separator = new JLabel();
                separator.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0), BorderFactory.createLineBorder(Color.BLACK, 1)));
                this.horizontalSeqGroup.addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(separator).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED);
                this.verticalParallelGroup.addComponent(separator, -1, -1, Short.MAX_VALUE);
            }
            this.horizontalSeqGroup.addComponent(btn, -2, -1, -2);
            this.verticalParallelGroup.addComponent(btn, -2, -1, -2);
            this.notEmpty = true;
        }

        private void finish() {
            this.horizontalSeqGroup.addContainerGap(-1, Short.MAX_VALUE);
        }
    }
}

