/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.j2ee;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.modules.form.ComponentChooserEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.PropertyModifier;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.editors.EnumEditor;
import org.netbeans.modules.form.j2ee.J2EEUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class J2EEPropertyModifier
implements PropertyModifier {
    public boolean modifyProperties(RADComponent metacomp, List<RADProperty> prefProps, List<RADProperty> normalProps, List<RADProperty> expertProps) {
        String className = metacomp.getBeanClass().getName();
        if (className.equals("javax.persistence.EntityManager")) {
            prefProps.clear();
            normalProps.clear();
            expertProps.clear();
            try {
                normalProps.add(new PUProperty(metacomp));
                expertProps.add(new FlushModeProperty(metacomp));
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            return true;
        }
        if (className.equals("javax.persistence.Query")) {
            prefProps.clear();
            normalProps.clear();
            expertProps.clear();
            try {
                prefProps.add(new QueryProperty(metacomp));
                expertProps.add(new EMProperty(metacomp));
                expertProps.add(new FirstResultProperty(metacomp));
                expertProps.add(new MaxResultsProperty(metacomp));
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            return true;
        }
        if (className.equals("java.util.List")) {
            prefProps.clear();
            normalProps.clear();
            expertProps.clear();
            try {
                prefProps.add(new QueryBeanProperty(metacomp, true));
                expertProps.add(new ModifiableWrapperProperty(metacomp));
                expertProps.add(new ObservableProperty(metacomp));
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            return true;
        }
        for (Annotation annotation : metacomp.getBeanClass().getAnnotations()) {
            if (!"javax.persistence.Entity".equals(annotation.annotationType().getName())) continue;
            expertProps.addAll(normalProps);
            normalProps.clear();
            normalProps.addAll(prefProps);
            prefProps.clear();
            try {
                prefProps.add(new QueryBeanProperty(metacomp, false));
            }
            catch (Exception ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            return true;
        }
        return false;
    }

    static class FakePropertyDescriptor
    extends PropertyDescriptor {
        private Class propType;

        FakePropertyDescriptor(String name, Class type) throws IntrospectionException {
            super(name, null, null);
            this.propType = type;
        }

        public Class getPropertyType() {
            return this.propType;
        }
    }

    public static class BeanChooserEditor
    extends ComponentChooserEditor {
        private String beanClassName;
        private String displayName;

        BeanChooserEditor(String beanClassName, String displayName) {
            this.beanClassName = beanClassName;
            this.displayName = displayName;
        }

        protected boolean acceptBean(RADComponent comp) {
            return this.beanClassName.equals(comp.getBeanClass().getName());
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String[] getTags() {
            String[] superTags = super.getTags();
            LinkedList<String> tags = new LinkedList<String>();
            tags.addAll(Arrays.asList(superTags));
            String none = this.noneString();
            tags.remove(none);
            return tags.toArray(new String[tags.size()]);
        }
    }

    static class ModifiableWrapperProperty
    extends RADProperty {
        ModifiableWrapperProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("modifiableWrapper", (Class)Boolean.TYPE));
            this.setAccessType(3);
            this.setShortDescription(NbBundle.getMessage(ModifiableWrapperProperty.class, (String)"HINT_ModifiableWrapper"));
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            return Boolean.FALSE;
        }
    }

    static class ObservableProperty
    extends RADProperty {
        ObservableProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("observable", (Class)Boolean.TYPE));
            this.setAccessType(3);
            this.setShortDescription(NbBundle.getMessage(ObservableProperty.class, (String)"HINT_ObservableProperty"));
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            return Boolean.FALSE;
        }
    }

    static class MaxResultsProperty
    extends RADProperty {
        MaxResultsProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("maxResults", (Class)Integer.TYPE));
            this.setAccessType(3);
            this.setShortDescription(NbBundle.getMessage(MaxResultsProperty.class, (String)"HINT_MaxResultsProperty"));
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            return -1;
        }
    }

    static class FirstResultProperty
    extends RADProperty {
        FirstResultProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("firstResult", (Class)Integer.TYPE));
            this.setAccessType(3);
            this.setShortDescription(NbBundle.getMessage(FirstResultProperty.class, (String)"HINT_FirstResultProperty"));
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            return 0;
        }
    }

    static class QueryProperty
    extends RADProperty {
        QueryProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("query", (Class)String.class));
            this.setAccessType(3);
            try {
                this.setValue("");
            }
            catch (Exception ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            this.setShortDescription(NbBundle.getMessage(QueryProperty.class, (String)"HINT_QueryProperty"));
        }

        public boolean supportsDefaultValue() {
            return false;
        }
    }

    static class QueryBeanProperty
    extends RADProperty {
        private boolean isList;

        QueryBeanProperty(RADComponent comp, boolean isList) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("query", (Class)Object.class));
            this.isList = isList;
            this.setAccessType(3);
            this.setShortDescription(NbBundle.getMessage(QueryBeanProperty.class, (String)"HINT_QueryBeanProperty"));
        }

        public void setValue(Object value) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            super.setValue(value);
            if (!this.isList) {
                RADComponent comp = this.getRADComponent();
                StringBuilder sb = new StringBuilder();
                sb.append('(').append(comp.getBeanClass().getName()).append(')');
                String initString = this.getJavaInitializationString();
                if ("null".equals("" + initString)) {
                    sb.append("((javax.persistence.Query)null)");
                } else {
                    sb.append(initString);
                }
                sb.append(".getSingleResult()");
                if (comp.getFormModel().isFormLoaded()) {
                    comp.getSyntheticProperty("creationCodeCustom").setValue((Object)sb.toString());
                }
            }
        }

        public boolean supportsDefaultValue() {
            return false;
        }

        public PropertyEditor getExpliciteEditor() {
            return new QueryEditor();
        }

        public static class QueryEditor
        extends BeanChooserEditor {
            public QueryEditor() {
                super("javax.persistence.Query", NbBundle.getBundle(QueryEditor.class).getString("CTL_QueryChooser"));
            }
        }
    }

    static class EMProperty
    extends RADProperty {
        EMProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("entityManager", (Class)Object.class));
            this.setAccessType(3);
            this.setShortDescription(NbBundle.getMessage(EMProperty.class, (String)"HINT_EntityManagerProperty"));
        }

        public boolean supportsDefaultValue() {
            return false;
        }

        public PropertyEditor getExpliciteEditor() {
            return new EntityManagerEditor();
        }

        public static class EntityManagerEditor
        extends BeanChooserEditor {
            public EntityManagerEditor() {
                super("javax.persistence.EntityManager", NbBundle.getBundle(EntityManagerEditor.class).getString("CTL_EntityManagerChooser"));
            }
        }
    }

    static class FlushModeProperty
    extends RADProperty {
        FlushModeProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("flushModeType", (Class)Object.class){

                @Override
                public Method getWriteMethod() {
                    Method m = null;
                    try {
                        m = FlushModeProperty.class.getMethod("setFlushMode", Object.class);
                    }
                    catch (Exception ex) {
                        Logger.getLogger(this.getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
                    }
                    return m;
                }
            });
            this.setAccessType(3);
            this.setShortDescription(NbBundle.getMessage(FlushModeProperty.class, (String)"HINT_FlushMode"));
        }

        public void setFlushMode(Object flushMode) {
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public Object getDefaultValue() {
            return null;
        }

        public PropertyEditor getExpliciteEditor() {
            Object[] enumValues = new Object[9];
            enumValues[0] = NbBundle.getMessage(FlushModeProperty.class, (String)"LBL_FlushModeType.DEFAULT");
            enumValues[3] = NbBundle.getMessage(FlushModeProperty.class, (String)"LBL_FlushModeType.AUTO");
            enumValues[6] = NbBundle.getMessage(FlushModeProperty.class, (String)"LBL_FlushModeType.COMMIT");
            enumValues[1] = null;
            enumValues[4] = "FlushModeType.AUTO";
            enumValues[7] = "FlushModeType.COMMIT";
            enumValues[2] = "";
            enumValues[5] = "javax.persistence.FlushModeType.AUTO";
            enumValues[8] = "javax.persistence.FlushModeType.COMMIT";
            return new EnumEditor(enumValues);
        }
    }

    static class PUProperty
    extends RADProperty {
        PUProperty(RADComponent comp) throws IntrospectionException {
            super(comp, (PropertyDescriptor)new FakePropertyDescriptor("persistenceUnit", (Class)String.class));
            this.setAccessType(3);
            try {
                this.setValue("pu");
            }
            catch (Exception ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.INFO, ex.getMessage(), ex);
            }
            this.setShortDescription(NbBundle.getMessage(PUProperty.class, (String)"HINT_PersistenceUnitName"));
        }

        public boolean supportsDefaultValue() {
            return false;
        }

        public PropertyEditor getExpliciteEditor() {
            FileObject fob = FormEditor.getFormDataObject((FormModel)this.getRADComponent().getFormModel()).getFormFile();
            String[] names = J2EEUtils.getPersistenceUnitNames(FileOwnerQuery.getOwner((FileObject)fob));
            Object[] enumValues = new Object[3 * names.length];
            for (int i = 0; i < names.length; ++i) {
                String string = names[i];
                enumValues[3 * i + 1] = string;
                enumValues[3 * i] = string;
                enumValues[3 * i + 2] = '\"' + FormUtils.escapeCharactersInString((String)names[i]) + '\"';
            }
            return new EnumEditor(enumValues);
        }
    }
}

