/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.deps.ui;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.netbeans.api.validation.adapters.DialogBuilder;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.deps.ArtifactKind;
import org.netbeans.modules.javacard.project.deps.ResolvedDependencies;
import org.netbeans.modules.javacard.project.deps.ResolvedDependency;
import org.netbeans.modules.javacard.project.deps.ui.AddDependencyWizardIterator;
import org.netbeans.modules.javacard.project.deps.ui.DependenciesNode;
import org.netbeans.modules.javacard.project.deps.ui.EditOneDependencyPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.ListView;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

class DependenciesEditorPanel
extends JPanel
implements ExplorerManager.Provider,
ActionListener,
PropertyChangeListener {
    private final ExplorerManager mgr = new ExplorerManager();
    private ResolvedDependencies deps;
    private JCProject project;
    private JButton addButton;
    private JTextField depStrategyField;
    private JLabel depStrategyLabel;
    private JScrollPane depsList;
    private JButton editButton;
    private JLabel libsLabel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JTextField pathField;
    private JLabel pathLabel;
    private JButton remButton;

    public DependenciesEditorPanel() {
        this.initComponents();
        GuiUtils.prepareContainer((Container)this);
        this.mgr.addPropertyChangeListener((PropertyChangeListener)this);
        ((ListView)this.depsList).setSelectionMode(0);
        HelpCtx.setHelpIDString((JComponent)this.addButton, (String)"org.netbeans.modules.javacard.AddLibrary");
        HelpCtx.setHelpIDString((JComponent)this.remButton, (String)"org.netbeans.modules.javacard.RemoveLibrary");
        HelpCtx.setHelpIDString((JComponent)this.editButton, (String)"org.netbeans.modules.javacard.ChangeLibraryDeploymentStrategy");
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.DependenciesPanel");
    }

    public DependenciesEditorPanel(JCProject project, ResolvedDependencies deps) {
        this();
        this.deps = deps;
        this.project = project;
        Parameters.notNull((CharSequence)"deps", (Object)deps);
        this.mgr.setRootContext((Node)new DependenciesNode(project, deps));
    }

    private void initComponents() {
        this.depsList = new ListView();
        this.libsLabel = new JLabel();
        this.addButton = new JButton();
        this.remButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.editButton = new JButton();
        this.pathLabel = new JLabel();
        this.depStrategyLabel = new JLabel();
        this.depStrategyField = new JTextField();
        this.pathField = new JTextField();
        this.depsList.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.libsLabel.setLabelFor(this.depsList);
        this.libsLabel.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.libsLabel.text"));
        this.addButton.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.addButton.text"));
        this.addButton.addActionListener(this);
        this.remButton.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.remButton.text"));
        this.remButton.setEnabled(false);
        this.remButton.addActionListener(this);
        this.moveUpButton.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.moveUpButton.text"));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(this);
        this.moveDownButton.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.moveDownButton.text"));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(this);
        this.editButton.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.editButton.text"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(this);
        this.pathLabel.setLabelFor(this.pathField);
        this.pathLabel.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.pathLabel.text"));
        this.depStrategyLabel.setLabelFor(this.depStrategyField);
        this.depStrategyLabel.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.depStrategyLabel.text"));
        this.depStrategyField.setEditable(false);
        this.depStrategyField.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.depStrategyField.text"));
        this.pathField.setEditable(false);
        this.pathField.setText(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"DependenciesEditorPanel.pathField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.libsLabel, -1, 607, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.depsList, -1, 475, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.depStrategyLabel).addComponent(this.pathLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pathField, -1, 297, Short.MAX_VALUE).addComponent(this.depStrategyField, -1, 297, Short.MAX_VALUE)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.addButton).addComponent(this.remButton).addComponent(this.editButton).addComponent(this.moveUpButton).addComponent(this.moveDownButton)))).addContainerGap()));
        layout.linkSize(0, this.addButton, this.editButton, this.moveDownButton, this.moveUpButton, this.remButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.libsLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editButton).addGap(18, 18, 18).addComponent(this.moveUpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownButton)).addComponent(this.depsList, -1, 215, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pathLabel).addComponent(this.pathField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.depStrategyLabel).addComponent(this.depStrategyField, -2, -1, -2)).addContainerGap()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addButton) {
            this.onAdd(evt);
        } else if (evt.getSource() == this.remButton) {
            this.onRemove(evt);
        } else if (evt.getSource() == this.moveUpButton) {
            this.onMoveUp(evt);
        } else if (evt.getSource() == this.moveDownButton) {
            this.onMoveDown(evt);
        } else if (evt.getSource() == this.editButton) {
            this.onEdit(evt);
        }
    }

    private void onAdd(ActionEvent evt) {
        this.postReselect(AddDependencyWizardIterator.show(this.deps, this.project));
    }

    private void onRemove(ActionEvent evt) {
        ResolvedDependency rd = this.getSelection();
        this.deps.remove(rd);
    }

    private void onEdit(ActionEvent evt) {
        ResolvedDependency dep = this.getSelection();
        assert (dep != null);
        new DialogBuilder(DependenciesEditorPanel.class).setTitle(NbBundle.getMessage(DependenciesEditorPanel.class, (String)"TTL_EDIT_LIBRARY")).setButtonSet(DialogBuilder.ButtonSet.CLOSE).setContent((Object)new EditOneDependencyPanel(dep)).showDialog();
        this.onSelectionChanged();
    }

    private void onMoveUp(ActionEvent evt) {
        ResolvedDependency rd = this.getSelection();
        this.deps.moveUp(rd);
        this.postReselect(rd);
    }

    private void onMoveDown(ActionEvent evt) {
        ResolvedDependency rd = this.getSelection();
        this.deps.moveDown(rd);
        this.postReselect(rd);
    }

    private void postReselect(final ResolvedDependency rd) {
        if (rd == null) {
            return;
        }
        Timer t = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Node n : DependenciesEditorPanel.this.mgr.getRootContext().getChildren().getNodes(true)) {
                    if (!rd.equals(n.getLookup().lookup(ResolvedDependency.class))) continue;
                    try {
                        DependenciesEditorPanel.this.mgr.setSelectedNodes(new Node[]{n});
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                    break;
                }
            }
        });
        t.setRepeats(false);
        t.start();
    }

    private ResolvedDependency getSelection() {
        Node[] n = this.mgr.getSelectedNodes();
        return n == null || n.length == 0 ? null : (ResolvedDependency)n[0].getLookup().lookup(ResolvedDependency.class);
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("selectedNodes".equals(evt.getPropertyName())) {
            this.onSelectionChanged();
        }
    }

    private void onSelectionChanged() {
        Node[] n = this.mgr.getSelectedNodes();
        if (n != null && n.length == 1) {
            ResolvedDependency dep = (ResolvedDependency)n[0].getLookup().lookup(ResolvedDependency.class);
            this.setSelectedDependency(dep);
        } else {
            this.setSelectedDependency(null);
        }
    }

    private void setSelectedDependency(ResolvedDependency d) {
        this.editButton.setEnabled(d != null);
        this.moveUpButton.setEnabled(d != null && this.deps.canMoveUp(d));
        this.moveDownButton.setEnabled(d != null && this.deps.canMoveDown(d));
        this.remButton.setEnabled(d != null);
        this.pathField.setEnabled(d != null);
        this.pathLabel.setEnabled(d != null);
        this.depStrategyLabel.setEnabled(d != null);
        this.depStrategyField.setEnabled(d != null);
        this.pathField.setText(d == null ? "" : d.getPath(ArtifactKind.ORIGIN));
        this.depStrategyField.setText(d == null ? "" : d.getDeploymentStrategy().toString());
    }
}

