/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.refactoring;

import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.refactoring.AppletXMLRefactoringSupport;
import org.netbeans.modules.javacard.project.refactoring.JCRenameRefactoringPlugin;
import org.netbeans.modules.javacard.project.refactoring.JavaCardXMLRefactoringSupport;
import org.netbeans.modules.javacard.project.refactoring.WebXMLRefactoringSupport;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.PositionBounds;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportantFilesRenameRefactoring
implements RefactoringPlugin {
    private final Transformer transformer;
    private final TransformerFactory tFactory = TransformerFactory.newInstance();
    private RefactoringPlugin refactoringPlugin;
    private final AbstractRefactoring renameRefactoring;
    private JCProject project;

    public ImportantFilesRenameRefactoring(AbstractRefactoring renameRefactoring) {
        FileObject fo;
        FileObject classSourceFO;
        TreePathHandle tpHandle;
        try {
            this.transformer = this.tFactory.newTransformer();
            this.transformer.setOutputProperty("indent", "yes");
            this.transformer.setOutputProperty("standalone", "no");
            this.transformer.setOutputProperty("omit-xml-declaration", "yes");
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException("Internal error: failed to create transformer", e);
        }
        this.renameRefactoring = renameRefactoring;
        Lookup lookup = renameRefactoring.getRefactoringSource();
        NonRecursiveFolder folder = (NonRecursiveFolder)lookup.lookup(NonRecursiveFolder.class);
        if (folder != null) {
            this.project = JCProject.getOwnerProjectOf(folder.getFolder());
            if (this.project != null) {
                this.refactoringPlugin = new RenamePackageRefactoring(folder.getFolder());
            }
        }
        if ((tpHandle = (TreePathHandle)lookup.lookup(TreePathHandle.class)) != null && TreeUtilities.CLASS_TREE_KINDS.contains((Object)tpHandle.getKind()) && (classSourceFO = tpHandle.getFileObject()) != null) {
            this.project = JCProject.getOwnerProjectOf(classSourceFO);
            if (this.project != null) {
                this.refactoringPlugin = new RenameClassRefactoring(classSourceFO);
            }
        }
        if ((fo = (FileObject)lookup.lookup(FileObject.class)) != null && fo.isData() && "text/x-java".equals(fo.getMIMEType())) {
            this.project = JCProject.getOwnerProjectOf(fo);
            if (this.project != null) {
                this.refactoringPlugin = new RenameClassRefactoring(fo);
            }
        }
    }

    public Problem preCheck() {
        return this.refactoringPlugin != null ? this.refactoringPlugin.preCheck() : null;
    }

    public Problem checkParameters() {
        return this.refactoringPlugin != null ? this.refactoringPlugin.checkParameters() : null;
    }

    public Problem fastCheckParameters() {
        return this.refactoringPlugin != null ? this.refactoringPlugin.fastCheckParameters() : null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag elements) {
        Problem result = null;
        if (this.refactoringPlugin != null) {
            result = this.refactoringPlugin.prepare(elements);
        }
        return result;
    }

    private String getResourceName(FileObject fileOrFolder) {
        ClassPathProvider cpProvider = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        ClassPath srcPath = cpProvider.findClassPath(fileOrFolder, "classpath/source");
        if (srcPath.contains(fileOrFolder)) {
            return srcPath.getResourceName(fileOrFolder, '.', false);
        }
        return null;
    }

    private Problem prepareClassRenaming(RefactoringElementsBag elements, String oldNamePrefix, String newNamePrefix) {
        Problem p = this.prepareClassRenamingForJavaCardXML(elements, oldNamePrefix, newNamePrefix);
        Problem pp = null;
        ProjectKind kind = this.project.kind();
        switch (kind) {
            case WEB: {
                pp = this.prepareClassRenamingForWebXML(elements, oldNamePrefix, newNamePrefix);
                break;
            }
            case EXTENDED_APPLET: 
            case CLASSIC_APPLET: {
                pp = this.prepareClassRenamingForAppletXML(elements, oldNamePrefix, newNamePrefix);
                break;
            }
            case CLASSIC_LIBRARY: 
            case EXTENSION_LIBRARY: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (p != null && pp != null) {
            p.setNext(pp);
        }
        return p == null ? pp : p;
    }

    private Problem prepareClassRenamingForAppletXML(RefactoringElementsBag elements, String oldNamePrefix, String newNamePrefix) {
        FileObject fo;
        FileObject appletXMLFileObject = this.project.getProjectDirectory().getFileObject("APPLET-INF/applet.xml");
        if (appletXMLFileObject == null) {
            return null;
        }
        File appletXMLFile = FileUtil.toFile((FileObject)appletXMLFileObject);
        AppletXMLRefactoringSupport descriptor = AppletXMLRefactoringSupport.fromFile(appletXMLFile);
        if (descriptor != null) {
            ArrayList<Node> nodesToUpdate = new ArrayList<Node>();
            for (NodeList nodes : new NodeList[]{descriptor.getAppletClassElements()}) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String text = node.getTextContent();
                    if (!text.startsWith(oldNamePrefix)) continue;
                    nodesToUpdate.add(node);
                }
            }
            if (nodesToUpdate.size() > 0) {
                String message = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"Update_applet_xml", (Object)oldNamePrefix);
                elements.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateXmlRefactoringElement(appletXMLFileObject, oldNamePrefix, newNamePrefix, descriptor.getDocument(), nodesToUpdate, message));
            }
        }
        if ((fo = this.project.getProjectDirectory().getFileObject("nbproject/deployment.xml")) != null) {
            try {
                DeploymentXmlModel mdl = new DeploymentXmlModel((InputStream)new BufferedInputStream(fo.getInputStream()));
                boolean changed = false;
                for (DeploymentXmlAppletEntry e : mdl.getData()) {
                    String classHint = e.getClazzHint();
                    if (!oldNamePrefix.equals(classHint)) continue;
                    e.setClazzHint(newNamePrefix);
                    changed = true;
                }
                if (changed) {
                    String msg = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"UPDATE_DEPLOYMENT_XML", (Object)oldNamePrefix);
                    elements.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateDeploymentXmlRefactoringElement(mdl, msg, fo));
                }
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return null;
    }

    private Problem prepareClassRenamingForWebXML(RefactoringElementsBag elements, String oldNamePrefix, String newNamePrefix) {
        FileObject webXMLFileObject = this.project.getProjectDirectory().getFileObject("WEB-INF/web.xml");
        if (webXMLFileObject == null) {
            return null;
        }
        File webXMLFile = FileUtil.toFile((FileObject)webXMLFileObject);
        WebXMLRefactoringSupport descriptor = WebXMLRefactoringSupport.fromFile(webXMLFile);
        if (descriptor != null) {
            ArrayList<Node> nodesToUpdate = new ArrayList<Node>();
            for (NodeList nodes : new NodeList[]{descriptor.getServletClassElements(), descriptor.getListenerClassElements(), descriptor.getFilterClassElements()}) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String text = node.getTextContent();
                    if (!text.startsWith(oldNamePrefix)) continue;
                    nodesToUpdate.add(node);
                }
            }
            if (nodesToUpdate.size() > 0) {
                String message = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"Update_web_xml", (Object)oldNamePrefix);
                elements.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateXmlRefactoringElement(webXMLFileObject, oldNamePrefix, newNamePrefix, descriptor.getDocument(), nodesToUpdate, message));
            }
        }
        return null;
    }

    private Problem prepareClassRenamingForJavaCardXML(RefactoringElementsBag elements, String oldNamePrefix, String newNamePrefix) {
        FileObject javaCardXMLFileObject = this.project.getProjectDirectory().getFileObject("META-INF/javacard.xml");
        if (javaCardXMLFileObject == null) {
            return null;
        }
        File javaCardXMLFile = FileUtil.toFile((FileObject)javaCardXMLFileObject);
        JavaCardXMLRefactoringSupport descriptor = JavaCardXMLRefactoringSupport.fromFile(javaCardXMLFile);
        if (descriptor != null) {
            ArrayList<Node> nodesToUpdate = new ArrayList<Node>();
            for (NodeList nodes : new NodeList[]{descriptor.getDynamicallyLoadedClassElements(), descriptor.getShareableInterfaceClassElements()}) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    Node node = nodes.item(i);
                    String text = node.getTextContent();
                    if (!text.startsWith(oldNamePrefix)) continue;
                    nodesToUpdate.add(node);
                }
            }
            if (nodesToUpdate.size() > 0) {
                String message = NbBundle.getMessage(JCRenameRefactoringPlugin.class, (String)"Update_jc_specific_descriptor", (Object)oldNamePrefix);
                elements.add(this.renameRefactoring, (RefactoringElementImplementation)new UpdateXmlRefactoringElement(javaCardXMLFileObject, oldNamePrefix, newNamePrefix, descriptor.getDocument(), nodesToUpdate, message));
            }
        }
        return null;
    }

    private final class UpdateXmlRefactoringElement
    extends SimpleRefactoringElementImplementation {
        private String oldPrefix;
        private String newPrefix;
        private FileObject targetFile;
        private Document doc;
        private List<Node> nodesToUpdate;
        private String message;

        UpdateXmlRefactoringElement(FileObject targetFile, String oldPrefix, String newPrefix, Document doc, List<Node> nodesToUpdate, String message) {
            this.oldPrefix = oldPrefix;
            this.newPrefix = newPrefix;
            this.targetFile = targetFile;
            this.doc = doc;
            this.nodesToUpdate = nodesToUpdate;
            this.message = message;
        }

        public String getDisplayText() {
            return this.getText();
        }

        public void performChange() {
            for (Node node : this.nodesToUpdate) {
                String text = node.getTextContent();
                text = this.newPrefix + text.substring(this.oldPrefix.length());
                node.setTextContent(text);
            }
            try {
                ImportantFilesRenameRefactoring.this.transformer.transform(new DOMSource(this.doc), new StreamResult(FileUtil.toFile((FileObject)this.targetFile)));
            }
            catch (TransformerException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public String getText() {
            return this.message;
        }

        public Lookup getLookup() {
            return Lookup.EMPTY;
        }

        public FileObject getParentFile() {
            return this.targetFile;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private static final class UpdateDeploymentXmlRefactoringElement
    extends SimpleRefactoringElementImplementation {
        private FileObject target;
        private DeploymentXmlModel mdl;
        private String msg;

        UpdateDeploymentXmlRefactoringElement(DeploymentXmlModel mdl, String msg, FileObject target) {
            this.mdl = mdl;
            this.msg = msg;
            this.target = target;
        }

        public String getText() {
            return this.msg;
        }

        public String getDisplayText() {
            return this.getText();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void performChange() {
            try {
                OutputStream out = this.target.getOutputStream();
                String xml = this.mdl.toXml();
                PrintWriter pw = new PrintWriter(out);
                try {
                    pw.println(xml);
                }
                finally {
                    pw.close();
                    out.close();
                }
            }
            catch (FileAlreadyLockedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        public Lookup getLookup() {
            return Lookups.fixed((Object[])new Object[]{this, this.target});
        }

        public FileObject getParentFile() {
            return this.target;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }

    private final class RenameClassRefactoring
    implements RefactoringPlugin {
        FileObject sourceFile;

        public RenameClassRefactoring(FileObject sourceFile) {
            this.sourceFile = sourceFile;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag elements) {
            if (ImportantFilesRenameRefactoring.this.renameRefactoring instanceof RenameRefactoring) {
                String oldClassName = ImportantFilesRenameRefactoring.this.getResourceName(this.sourceFile);
                String name = ((RenameRefactoring)ImportantFilesRenameRefactoring.this.renameRefactoring).getNewName();
                String newClassName = oldClassName.substring(0, oldClassName.lastIndexOf(46) + 1) + name;
                return ImportantFilesRenameRefactoring.this.prepareClassRenaming(elements, oldClassName, newClassName);
            }
            Problem res = null;
            MoveRefactoring mv = (MoveRefactoring)ImportantFilesRenameRefactoring.this.renameRefactoring;
            URL url = (URL)mv.getTarget().lookup(URL.class);
            for (FileObject fo : mv.getRefactoringSource().lookupAll(FileObject.class)) {
                String oldClassName = ImportantFilesRenameRefactoring.this.getResourceName(fo);
                String newClassName = this.getRelativePath(fo, url);
                Problem p = ImportantFilesRenameRefactoring.this.prepareClassRenaming(elements, oldClassName, newClassName);
                if (res != null) {
                    res.setNext(p);
                }
                res = p;
            }
            return res;
        }

        private String getRelativePath(FileObject fo, URL url) {
            if (url == null) {
                return null;
            }
            if (fo != null) {
                File f = FileUtil.toFile((FileObject)fo);
                try {
                    File x = new File(url.toURI());
                    Project p = FileOwnerQuery.getOwner((FileObject)fo);
                    JCProject jp = (JCProject)p.getLookup().lookup(JCProject.class);
                    if (jp != null) {
                        ClassPath srcPath = jp.getSourceClassPath();
                        for (FileObject root : srcPath.getRoots()) {
                            if (!root.equals(fo) && !FileUtil.isParentOf((FileObject)root, (FileObject)fo)) continue;
                            String newPackageName = srcPath.getResourceName(fo.getParent(), File.separatorChar, false);
                            int ix = f.getAbsolutePath().indexOf(newPackageName);
                            if (ix > 0 && ix < x.getAbsolutePath().length()) {
                                String destAsPackage = x.getAbsolutePath().substring(ix).replace(File.separatorChar, '.');
                                return destAsPackage + '.' + fo.getName();
                            }
                            if (ix >= x.getAbsolutePath().length()) {
                                return fo.getName();
                            }
                            if (ix != 0) continue;
                            return x.getAbsolutePath().substring(f.getParentFile().getAbsolutePath().length() + 1).replace(File.separatorChar, '.') + '.' + fo.getName();
                        }
                    }
                }
                catch (URISyntaxException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return null;
        }
    }

    private class RenamePackageRefactoring
    implements RefactoringPlugin {
        private FileObject packageFolder;

        public RenamePackageRefactoring(FileObject packageFolder) {
            this.packageFolder = packageFolder;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag elements) {
            String oldPackageName = ImportantFilesRenameRefactoring.this.getResourceName(this.packageFolder);
            if (ImportantFilesRenameRefactoring.this.renameRefactoring instanceof RenameRefactoring) {
                String newPackageName = ((RenameRefactoring)ImportantFilesRenameRefactoring.this.renameRefactoring).getNewName();
                return ImportantFilesRenameRefactoring.this.prepareClassRenaming(elements, oldPackageName, newPackageName);
            }
            return null;
        }
    }
}

