/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.api;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class J2MEProjectBuilder {
    private static final Logger LOG = Logger.getLogger(J2MEProjectBuilder.class.getName());
    private static final String DEFAULT_MAIN_TEMPLATE = "Templates/j2me/Midlet.java";
    private static final SpecificationVersion VERSION_8 = new SpecificationVersion("8.0");
    private static final String ME_PROCESSOR_PATH = "lib/compiler/me_plugin.jar";
    private final File projectDirectory;
    private final String name;
    private final JavaPlatform platform;
    private final Collection<File> sourceRoots;
    private final Collection<Library> compileLibraries;
    private final Collection<Library> runtimeLibraries;
    private JavaPlatform sdk = JavaPlatform.getDefault();
    private boolean hasDefaultRoots;
    private String librariesDefinition;
    private String buildXmlName;
    private String distFolder;
    private String mainMIDlet;
    private String mainMIDletTemplate;
    private String manifest;
    private Map<String, String> customProjectProperties;
    private Map<String, String> customPrivateProperties;
    private static final String loggerName = "org.netbeans.ui.metrics.j2se";
    private static final String loggerKey = "USG_PROJECT_CREATE_J2ME_EMBEDDED";

    private J2MEProjectBuilder(@NonNull File projectDirectory, @NonNull String name, @NonNull JavaPlatform platform) {
        Parameters.notNull((CharSequence)"projectDirectory", (Object)projectDirectory);
        Parameters.notNull((CharSequence)"name", (Object)name);
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        J2MEProjectBuilder.validatePlatform(platform);
        this.projectDirectory = projectDirectory;
        this.name = name;
        this.platform = platform;
        this.sourceRoots = new LinkedHashSet<File>();
        this.compileLibraries = new LinkedHashSet<Library>();
        this.runtimeLibraries = new LinkedHashSet<Library>();
    }

    @NonNull
    public J2MEProjectBuilder setSDKPlatform(@NonNull JavaPlatform sdk) {
        Parameters.notNull((CharSequence)"sdk", (Object)sdk);
        this.sdk = sdk;
        return this;
    }

    @NonNull
    public J2MEProjectBuilder addDefaultSourceRoots() {
        this.hasDefaultRoots = true;
        return this;
    }

    @NonNull
    public J2MEProjectBuilder addSourceRoots(File ... folders) {
        Parameters.notNull((CharSequence)"folder", (Object)folders);
        for (File f : folders) {
            if (!this.sourceRoots.contains(f)) continue;
            throw new IllegalArgumentException("The folder: " + f + " is already included in sources.");
        }
        Collections.addAll(this.sourceRoots, folders);
        return this;
    }

    public J2MEProjectBuilder setLibrariesDefinitionFile(@NullAllowed String librariesDefinition) {
        this.librariesDefinition = librariesDefinition;
        return this;
    }

    @NonNull
    public J2MEProjectBuilder setMainMIDLetName(@NullAllowed String midletName) {
        this.mainMIDlet = midletName;
        return this;
    }

    @NonNull
    public J2MEProjectBuilder setMainMIDLetTemplate(@NullAllowed String template) {
        this.mainMIDletTemplate = template;
        return this;
    }

    @NonNull
    public J2MEProjectBuilder addCustomProjectProperties(@NullAllowed Map<String, String> props) {
        this.customProjectProperties = props;
        return this;
    }

    @NonNull
    public J2MEProjectBuilder addCustomPrivateProperties(@NullAllowed Map<String, String> props) {
        this.customPrivateProperties = props;
        return this;
    }

    public AntProjectHelper build() throws IOException {
        assert (this.projectDirectory != null);
        assert (this.sourceRoots != null);
        final FileObject dirFO = FileUtil.createFolder((File)this.projectDirectory);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                SpecificationVersion sourceLevel = J2MEProjectBuilder.this.getSourceLevel();
                h[0] = J2MEProjectBuilder.createProject(dirFO, J2MEProjectBuilder.this.name, sourceLevel, J2MEProjectBuilder.this.hasDefaultRoots ? "src" : null, J2MEProjectBuilder.this.buildXmlName, J2MEProjectBuilder.this.distFolder, J2MEProjectBuilder.this.manifest, J2MEProjectBuilder.this.librariesDefinition, J2MEProjectBuilder.toClassPathElements(J2MEProjectBuilder.this.compileLibraries, new String[0]), J2MEProjectBuilder.toClassPathElements(J2MEProjectBuilder.this.runtimeLibraries, new String[]{"${javac.classpath}:", "${build.classes.dir}"}), J2MEProjectBuilder.this.platform, J2MEProjectBuilder.this.sdk, J2MEProjectBuilder.this.customProjectProperties, J2MEProjectBuilder.this.customPrivateProperties);
                final J2MEProject p = (J2MEProject)ProjectManager.getDefault().findProject(dirFO);
                ProjectManager.getDefault().saveProject((Project)p);
                final ReferenceHelper refHelper = p.getReferenceHelper();
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            J2MEProjectBuilder.registerRoots(h[0], refHelper, J2MEProjectBuilder.this.sourceRoots);
                            ProjectManager.getDefault().saveProject((Project)p);
                            ArrayList libsToCopy = new ArrayList();
                            libsToCopy.addAll(J2MEProjectBuilder.this.compileLibraries);
                            libsToCopy.addAll(J2MEProjectBuilder.this.runtimeLibraries);
                            J2MEProjectBuilder.copyRequiredLibraries(h[0], refHelper, libsToCopy);
                            ProjectUtils.getSources((Project)p).getSourceGroups("java");
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex.getException());
                }
                FileObject srcFolder = null;
                if (J2MEProjectBuilder.this.hasDefaultRoots) {
                    srcFolder = dirFO.createFolder("src");
                } else if (!J2MEProjectBuilder.this.sourceRoots.isEmpty()) {
                    srcFolder = FileUtil.toFileObject((File)((File)J2MEProjectBuilder.this.sourceRoots.iterator().next()));
                }
                if (srcFolder != null && J2MEProjectBuilder.this.mainMIDlet != null) {
                    J2MEProjectBuilder.createMainMIDLet(srcFolder, J2MEProjectBuilder.this.mainMIDlet, J2MEProjectBuilder.this.mainMIDletTemplate);
                }
            }
        });
        return h[0];
    }

    public static J2MEProjectBuilder forDirectory(@NonNull File projectDirectory, @NonNull String name, @NonNull JavaPlatform platform) {
        return new J2MEProjectBuilder(projectDirectory, name, platform);
    }

    private static DataObject createMainMIDLet(@NonNull FileObject srcFolder, @NonNull String mainMIDLetName, @NullAllowed String mainMIDLetTemplate) throws IOException {
        DataFolder pDf;
        DataObject res;
        FileObject mainTemplate;
        String pName;
        String mName;
        int lastDotIdx = mainMIDLetName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainMIDLetName.trim();
            pName = null;
        } else {
            mName = mainMIDLetName.substring(lastDotIdx + 1).trim();
            pName = mainMIDLetName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return null;
        }
        if (mainMIDLetTemplate == null) {
            mainMIDLetTemplate = DEFAULT_MAIN_TEMPLATE;
        }
        if ((mainTemplate = FileUtil.getConfigFile((String)mainMIDLetTemplate)) == null) {
            LOG.log(Level.WARNING, "Template {0} not found!", mainMIDLetTemplate);
            return null;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        if ((res = mt.createFromTemplate(pDf = DataFolder.findFolder((FileObject)pkgFolder), mName)) == null || !res.isValid()) {
            LOG.log(Level.WARNING, "Template {0} created an invalid DataObject in folder {1}!", new Object[]{mainMIDLetTemplate, FileUtil.getFileDisplayName((FileObject)pkgFolder)});
            return null;
        }
        return res;
    }

    @NonNull
    private SpecificationVersion getSourceLevel() {
        SpecificationVersion specVersion = this.platform.getSpecification().getVersion();
        SpecificationVersion runtimeVersion = VERSION_8.compareTo((Object)specVersion) <= 0 ? new SpecificationVersion("1.8") : new SpecificationVersion("1.3");
        SpecificationVersion toolsVersion = this.sdk.getSpecification().getVersion();
        return runtimeVersion.compareTo((Object)toolsVersion) <= 0 ? runtimeVersion : toolsVersion;
    }

    private static void registerRoots(AntProjectHelper helper, ReferenceHelper refHelper, Collection<? extends File> sourceFolders) {
        if (sourceFolders.isEmpty()) {
            return;
        }
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2me-embedded-project/1", "source-roots");
        assert (nl.getLength() == 1);
        Element sourceRoots = (Element)nl.item(0);
        boolean first = true;
        for (File file : sourceFolders) {
            String name;
            if (first) {
                name = "src";
                first = false;
            } else {
                name = file.getName();
            }
            String propName = name + ".dir";
            int rootIndex = 1;
            EditableProperties props = helper.getProperties("nbproject/project.properties");
            while (props.containsKey((Object)propName)) {
                propName = name + ++rootIndex + ".dir";
            }
            String srcReference = refHelper.createForeignFileReference(file, "java");
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2me-embedded-project/1", "root");
            root.setAttribute("id", propName);
            sourceRoots.appendChild(root);
            props = helper.getProperties("nbproject/project.properties");
            props.put(propName, srcReference);
            helper.putProperties("nbproject/project.properties", props);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, Collection<? extends Library> libraries) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        for (Library library : libraries) {
            String libName = library.getName();
            if (rh.getProjectLibraryManager().getLibrary(libName) != null || LibraryManager.getDefault().getLibrary(libName) == null) continue;
            rh.copyLibrary(LibraryManager.getDefault().getLibrary(libName));
        }
    }

    @NonNull
    private static String[] toClassPathElements(@NonNull Collection<? extends Library> libraries, String ... additionalEntries) {
        String[] result = new String[libraries.size() + additionalEntries.length];
        Iterator<? extends Library> it = libraries.iterator();
        int i = 0;
        while (it.hasNext()) {
            Library lib = it.next();
            result[i] = "${libs." + lib.getName() + ".classpath}" + (it.hasNext() || additionalEntries.length != 0 ? ":" : "");
            ++i;
        }
        System.arraycopy(additionalEntries, 0, result, libraries.size(), additionalEntries.length);
        return result;
    }

    private static void validatePlatform(@NonNull JavaPlatform platform) {
        Specification spec = platform.getSpecification();
        if (!"j2me".equals(spec.getName())) {
            throw new IllegalArgumentException("Invalid Java Platform type: " + spec.getName());
        }
        if (VERSION_8.compareTo((Object)spec.getVersion()) > 0) {
            throw new IllegalArgumentException("Invalid Specification Version: " + spec.getVersion());
        }
    }

    private static AntProjectHelper createProject(@NonNull FileObject dirFO, @NonNull String name, @NonNull SpecificationVersion sourceLevel, @NullAllowed String srcRoot, @NullAllowed String buildXmlName, @NullAllowed String distFolder, @NullAllowed String manifestFile, @NullAllowed String librariesDefinition, @NonNull String[] compileClassPath, @NonNull String[] runtimeClassPath, @NonNull JavaPlatform platform, @NonNull JavaPlatform sdkPlatform, @NullAllowed Map<String, String> customProjectProperties, @NullAllowed Map<String, String> customPrivateProperties) throws IOException {
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.j2me.project", (String)librariesDefinition);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2me-embedded-project/1", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2me-embedded-project/1", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2me-embedded-project/1", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2me-embedded-project/1", "test-roots");
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.setProperty("dist.dir", distFolder != null ? distFolder : "dist");
        String antProjectName = PropertyUtils.getUsablePropertyName((String)name);
        ep.put("dist.jad", antProjectName + ".jad");
        ep.setProperty("dist.jar.file", antProjectName + ".jar");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(J2MEProjectBuilder.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/${dist.jar.file}");
        ep.setProperty("javac.classpath", compileClassPath);
        ep.setProperty("javac.processorpath", new String[]{"${javac.classpath}"});
        ep.setProperty("run.classpath", runtimeClassPath);
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setComment("debug.classpath", new String[]{"# " + NbBundle.getMessage(J2MEProjectBuilder.class, (String)"COMMENT_debug.transport"), "#debug.transport=dt_socket"}, false);
        ep.setProperty("jar.compress", "false");
        boolean meProcessor = J2MEProjectBuilder.setUpMEProcessor(ep, platform);
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", Boolean.toString(meProcessor));
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("annotation.processing.processor.options", "");
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(J2MEProjectBuilder.class, (String)"COMMENT_javac.compilerargs")}, false);
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("meta.inf.dir", "${src.dir}/META-INF");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(J2MEProjectBuilder.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("build.fatjar.dir", "${build.dir}/fatjar");
        ep.setProperty("platform.active", (String)platform.getProperties().get("platform.ant.name"));
        ep.setProperty(J2MEProjectProperties.PLATFORM_SDK, (String)sdkPlatform.getProperties().get("platform.ant.name"));
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (manifestFile != null) {
            ep.setProperty("manifest.file", manifestFile);
        }
        if (buildXmlName != null) {
            ep.put("buildfile", buildXmlName);
        }
        ep.setProperty("dist.archive.excludes", "");
        ep.setComment("dist.archive.excludes", new String[]{"# " + NbBundle.getMessage(J2MEProjectBuilder.class, (String)"COMMENT_dist.archive.excludes")}, false);
        if (customProjectProperties != null) {
            ep.putAll(customProjectProperties);
        }
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        Collection installFolders = platform.getInstallFolders();
        if (installFolders.isEmpty()) {
            throw new IllegalArgumentException("The platform: " + platform.getDisplayName() + " is broken.");
        }
        FileObject platformFolder = (FileObject)platform.getInstallFolders().iterator().next();
        if (platformFolder == null) {
            throw new IllegalArgumentException("The platform: " + platform.getDisplayName() + " is broken.");
        }
        File platformDir = FileUtil.toFile((FileObject)platformFolder);
        if (platformDir == null) {
            throw new IllegalArgumentException("Platform: " + platform.getDisplayName() + " is not on a local file system.");
        }
        ep.setProperty("platform.home", platformDir.getAbsolutePath());
        if (customPrivateProperties != null) {
            ep.putAll(customPrivateProperties);
        }
        h.putProperties("nbproject/private/private.properties", ep);
        J2MEProjectBuilder.logUsage();
        return h;
    }

    private static boolean setUpMEProcessor(@NonNull EditableProperties pp, @NonNull JavaPlatform meSdk) {
        FileObject ap;
        FileObject sdkHome;
        Collection locs = meSdk.getInstallFolders();
        FileObject fileObject = sdkHome = locs.isEmpty() ? null : (FileObject)locs.iterator().next();
        if (sdkHome != null && (ap = sdkHome.getFileObject(ME_PROCESSOR_PATH)) != null) {
            String meProcessorResolved = String.format("${platform.home}/%s", ME_PROCESSOR_PATH);
            String path = pp.getProperty("javac.processorpath");
            if (path == null || path.isEmpty()) {
                pp.setProperty("javac.processorpath", meProcessorResolved);
            } else {
                String[] pathElements = PropertyUtils.tokenizePath((String)path);
                String[] newPathElements = new String[pathElements.length + 1];
                newPathElements[0] = J2MEProjectBuilder.toPathEntry(meProcessorResolved, false);
                for (int i = 0; i < pathElements.length; ++i) {
                    newPathElements[1 + i] = J2MEProjectBuilder.toPathEntry(pathElements[i], i == pathElements.length - 1);
                }
                pp.setProperty("javac.processorpath", newPathElements);
            }
            return true;
        }
        return false;
    }

    @NonNull
    private static String toPathEntry(@NonNull String entry, boolean last) {
        return last ? entry : String.format("%s:", entry);
    }

    private static void logUsage() {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        Logger.getLogger(loggerName).log(logRecord);
    }
}

