/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.wizard;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.wizard.J2METargetChooserPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public class NewJ2MEFileWizardIterator
implements WizardDescriptor.AsynchronousInstantiatingIterator<WizardDescriptor> {
    static final String FOLDER = "Classes";
    static final String JDK_5 = "jdk5";
    private static final long serialVersionUID = 1L;
    private final Type type;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private final transient Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public NewJ2MEFileWizardIterator() {
        this(Type.FILE);
    }

    private NewJ2MEFileWizardIterator(Type type) {
        this.type = type;
    }

    public static NewJ2MEFileWizardIterator createNewMidletWizardIterator() {
        return new NewJ2MEFileWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        if (project == null) {
            throw new NullPointerException("No project found for: " + wizardDescriptor);
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if ((groups = NewJ2MEFileWizardIterator.checkNotNull(groups, sources)).length == 0) {
            groups = sources.getSourceGroups("generic");
            groups = NewJ2MEFileWizardIterator.checkNotNull(groups, sources);
            return new WizardDescriptor.Panel[]{Templates.buildSimpleTargetChooser((Project)project, (SourceGroup[])groups).create()};
        }
        if (this.type == Type.FILE) {
            return new WizardDescriptor.Panel[]{new J2METargetChooserPanel(project, groups, null, Type.FILE, false)};
        }
        if (this.type == Type.PKG_INFO) {
            return new WizardDescriptor.Panel[]{new J2METargetChooserPanel(project, groups, null, Type.PKG_INFO, true)};
        }
        assert (this.type == Type.PACKAGE);
        SourceGroup[] resources = sources.getSourceGroups("resources");
        assert (resources != null);
        if (resources.length > 0) {
            ArrayList<SourceGroup> all = new ArrayList<SourceGroup>();
            all.addAll(Arrays.asList(groups));
            all.addAll(Arrays.asList(resources));
            groups = all.toArray(new SourceGroup[all.size()]);
        }
        return new WizardDescriptor.Panel[]{new J2METargetChooserPanel(project, groups, null, Type.PACKAGE, false)};
    }

    private static SourceGroup[] checkNotNull(SourceGroup[] groups, Sources sources) {
        ArrayList<SourceGroup> sourceGroups = new ArrayList<SourceGroup>();
        for (SourceGroup sourceGroup : groups) {
            if (sourceGroup == null) {
                Exceptions.printStackTrace((Throwable)new NullPointerException(sources + " returns null SourceGroup!"));
                continue;
            }
            sourceGroups.add(sourceGroup);
        }
        return sourceGroups.toArray(new SourceGroup[sourceGroups.size()]);
    }

    private String[] createSteps(String[] before, WizardDescriptor.Panel[] panels) {
        assert (panels != null);
        int diff = 0;
        if (before == null) {
            before = new String[]{};
        } else if (before.length > 0) {
            diff = "...".equals(before[before.length - 1]) ? 1 : 0;
        }
        String[] res = new String[before.length - diff + panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < before.length - diff ? before[i] : panels[i - before.length + diff].getComponent().getName();
        }
        return res;
    }

    public Set<FileObject> instantiate() throws IOException {
        Project project;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wiz);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wiz);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject createdFile = null;
        if (this.type == Type.PACKAGE) {
            targetName = targetName.replace('.', '/');
            createdFile = FileUtil.createFolder((FileObject)dir, (String)targetName);
        } else {
            DataObject dTemplate = DataObject.find((FileObject)template);
            DataObject dobj = dTemplate.createFromTemplate(df, targetName);
            createdFile = dobj.getPrimaryFile();
        }
        Object isMidletObject = Templates.getTemplate((WizardDescriptor)this.wiz).getAttribute("isMIDletTemplate");
        boolean isMIDlet = false;
        if (isMidletObject instanceof Boolean) {
            isMIDlet = (Boolean)isMidletObject;
        }
        if (isMIDlet && (project = Templates.getProject((WizardDescriptor)this.wiz)) instanceof J2MEProject) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    NewJ2MEFileWizardIterator.this.addMidletManifestAttribute((J2MEProject)project);
                }
            });
        }
        return Collections.singleton(createdFile);
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels(wiz);
        String[] beforeSteps = null;
        Object prop = wiz.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        String[] steps = this.createSteps(beforeSteps, this.panels);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return "";
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        ChangeListener[] ls;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener l : ls) {
            l.stateChanged(ev);
        }
    }

    private void addMidletManifestAttribute(J2MEProject project) {
        String createdMidletName = (String)this.wiz.getProperty("MidletName");
        String createdMidletClass = (String)this.wiz.getProperty("MidletClassName");
        if (createdMidletName == null || createdMidletClass == null) {
            return;
        }
        AntProjectHelper h = project.getUpdateHelper().getAntProjectHelper();
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        String midlets = ep.getProperty("manifest.midlets");
        String[] midletsSplitted = midlets != null ? midlets.split("\n") : new String[]{};
        int midletCount = 0;
        for (String midlet : midletsSplitted) {
            if (midlet == null || !midlet.startsWith("MIDlet-")) continue;
            ++midletCount;
        }
        StringBuilder midletsUpdate = new StringBuilder();
        midletsUpdate.append("MIDlet-").append(++midletCount).append(": ");
        midletsUpdate.append(createdMidletName);
        midletsUpdate.append(",,");
        midletsUpdate.append(createdMidletClass);
        midletsUpdate.append("\n");
        if (midlets != null) {
            midletsUpdate.append(midlets);
        }
        ep.put("manifest.midlets", midletsUpdate.toString());
        h.putProperties("nbproject/project.properties", ep);
        try {
            ProjectManager.getDefault().saveProject((Project)project);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static enum Type {
        FILE,
        PACKAGE,
        PKG_INFO;

    }
}

