/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class DateType {
    public static final String DEFAULT_FOMAT_PATTERN = "yyyy-MM-dd";
    private static final DateFormat[] DATE_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("yyyy-MM-dd"), DateFormat.getDateInstance(), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(3, TimestampType.LOCALE), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("MM-dd-yyyy")};

    public DateType() {
        for (int i = 0; i < DATE_PARSING_FORMATS.length; ++i) {
            DATE_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public static java.sql.Date convert(Object value) throws DBException {
        Calendar cal = Calendar.getInstance();
        if (null == value) {
            return null;
        }
        if (value instanceof Timestamp) {
            cal.setTimeInMillis(((Timestamp)value).getTime());
        } else if (value instanceof Date) {
            cal.setTimeInMillis(((Date)value).getTime());
        } else if (value instanceof String) {
            Date dVal = DateType.doParse((String)value);
            if (dVal == null) {
                throw new DBException(NbBundle.getMessage(DateType.class, (String)"MSG_failure_convert_date", (Object)value.getClass().getName(), (Object)value.toString()));
            }
            cal.setTimeInMillis(dVal.getTime());
        } else {
            throw new DBException(NbBundle.getMessage(DateType.class, (String)"MSG_failure_convert_date", (Object)value.getClass().getName(), (Object)value.toString()));
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    private static synchronized Date doParse(String sVal) {
        Date dVal = null;
        for (DateFormat format : DATE_PARSING_FORMATS) {
            try {
                dVal = format.parse(sVal);
                break;
            }
            catch (ParseException ex) {
                Logger.getLogger(DateType.class.getName()).log(Level.FINEST, ex.getLocalizedMessage(), ex);
            }
        }
        return dVal;
    }
}

