/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.base.ident;

import java.io.Reader;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.asm.base.SparcModelProvider;
import org.netbeans.modules.cnd.asm.base.X86ModelProvider;
import org.netbeans.modules.cnd.asm.base.att.ATTIdentResolver;
import org.netbeans.modules.cnd.asm.base.att.ATTSparcSyntaxProvider;
import org.netbeans.modules.cnd.asm.base.att.ATTx86SyntaxProvider;
import org.netbeans.modules.cnd.asm.base.dis.DisSparcSyntaxProvider;
import org.netbeans.modules.cnd.asm.base.dis.DisX86SyntaxProvider;
import org.netbeans.modules.cnd.asm.base.generated.IdentScanner;
import org.netbeans.modules.cnd.asm.base.syntax.IdentResolver;
import org.netbeans.modules.cnd.asm.model.AbstractAsmModel;
import org.netbeans.modules.cnd.asm.model.AsmModelProvider;
import org.netbeans.modules.cnd.asm.model.AsmSyntaxProvider;
import org.netbeans.modules.cnd.asm.model.AsmTypesProvider;
import org.netbeans.modules.cnd.asm.model.util.DefaultAsmTypesEntry;
import org.netbeans.modules.cnd.asm.model.util.DefaultResolverResult;

public class SparcX86Resolver
implements AsmTypesProvider {
    public static final AsmSyntaxProvider ATT_X86_SYNTAX = new ATTx86SyntaxProvider();
    public static final AsmSyntaxProvider ATT_SPARC_SYNTAX = new ATTSparcSyntaxProvider();
    public static final AsmSyntaxProvider DIS_X86_SYNTAX = new DisX86SyntaxProvider();
    public static final AsmSyntaxProvider DIS_SPARC_SYNTAX = new DisSparcSyntaxProvider();
    public static final AsmModelProvider AMD64 = X86ModelProvider.getInstance();
    public static final AsmModelProvider SPARC = SparcModelProvider.getInstance();

    @Override
    public List<AsmTypesProvider.AsmTypesEntry> getAsmTypes() {
        DefaultAsmTypesEntry amd64 = new DefaultAsmTypesEntry(AMD64, ATT_X86_SYNTAX, DIS_X86_SYNTAX);
        DefaultAsmTypesEntry sparc = new DefaultAsmTypesEntry(SPARC, ATT_SPARC_SYNTAX, DIS_SPARC_SYNTAX);
        return Arrays.asList(amd64, sparc);
    }

    @Override
    public AsmTypesProvider.ResolverResult resolve(Reader source) {
        AbstractAsmModel amd64 = (AbstractAsmModel)AMD64.getModel();
        AbstractAsmModel sparc = (AbstractAsmModel)SPARC.getModel();
        IdentResolver[] resolvers = new IdentResolver[]{new ATTIdentResolver(amd64), new ATTIdentResolver(sparc)};
        SyntaxChooser syntChooser = new SyntaxChooser();
        ModelChooser modelChooser = new ModelChooser(resolvers);
        this.resolver(source, new ScannerListener[]{syntChooser, modelChooser});
        int synt = modelChooser.getResult();
        AsmModelProvider modelRes = synt == 0 ? AMD64 : SPARC;
        AsmSyntaxProvider syntRes = syntChooser.hasDis() ? (synt == 0 ? DIS_X86_SYNTAX : DIS_SPARC_SYNTAX) : (synt == 0 ? ATT_X86_SYNTAX : ATT_SPARC_SYNTAX);
        return new DefaultResolverResult(modelRes, syntRes, null);
    }

    private void resolver(Reader source, ScannerListener[] listeners) {
        Token tok;
        IdentScanner scanner = new IdentScanner(source);
        for (ScannerListener lis : listeners) {
            lis.start();
        }
        do {
            try {
                tok = scanner.nextToken();
            }
            catch (TokenStreamException ex) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Ident lexer crashed");
                break;
            }
            for (ScannerListener lis : listeners) {
                lis.token(tok);
            }
        } while (tok.getType() != 1);
        int numLines = scanner.getNumLines();
        for (ScannerListener lis : listeners) {
            lis.end(numLines);
        }
    }

    private static class ModelChooser
    implements ScannerListener {
        private final int[] results;
        private final IdentResolver[] resolvers;

        public ModelChooser(IdentResolver[] resolvers) {
            assert (resolvers.length > 0);
            this.resolvers = resolvers;
            this.results = new int[resolvers.length];
        }

        public int getResult() {
            int maxIdx = 0;
            for (int i = 1; i < this.results.length; ++i) {
                if (this.results[maxIdx] >= this.results[i]) continue;
                maxIdx = i;
            }
            if (this.results[maxIdx] == 0) {
                return 0;
            }
            return maxIdx;
        }

        @Override
        public void token(Token tok) {
            String text = tok.getText();
            int type = tok.getType();
            if (type == 47) {
                for (int i = 0; i < this.resolvers.length; ++i) {
                    if (this.resolvers[i].getRegister(text) == null) continue;
                    int n = i;
                    this.results[n] = this.results[n] + 1;
                }
            }
        }

        @Override
        public void start() {
        }

        @Override
        public void end(int lines) {
        }
    }

    private static class SyntaxChooser
    implements ScannerListener {
        private int numPluses;
        private int numOpcodes;
        private int numComments;
        private int numLines;

        private SyntaxChooser() {
        }

        @Override
        public void token(Token tok) {
            String text = tok.getText();
            int type = tok.getType();
            switch (type) {
                case 29: {
                    if (!"+".equals(text)) break;
                    ++this.numPluses;
                    break;
                }
                case 45: {
                    ++this.numComments;
                    break;
                }
                case 46: {
                    if (!this.isOpcode(text)) break;
                    ++this.numOpcodes;
                    break;
                }
            }
        }

        public boolean hasDis() {
            float opCodesPerLine = 0.0f;
            float plusesPerLine = 0.0f;
            if (this.numLines > 0) {
                opCodesPerLine = (float)this.numOpcodes / (float)this.numLines;
                plusesPerLine = (float)this.numPluses / (float)this.numLines;
            }
            return Float.compare(opCodesPerLine, 2.0f) > 0 || Float.compare(plusesPerLine, 0.9f) > 0;
        }

        private boolean isOpcode(String res) {
            return res.length() == 2 && this.isHexDigit(res.charAt(0)) && this.isHexDigit(res.charAt(1));
        }

        private boolean isHexDigit(char ch) {
            return ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
        }

        @Override
        public void end(int lines) {
            this.numLines = lines - this.numComments;
        }

        @Override
        public void start() {
        }
    }

    private static interface ScannerListener
    extends EventListener {
        public void start();

        public void token(Token var1);

        public void end(int var1);
    }
}

