/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.cnd.api.model.services.CsmCacheMap;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Exceptions;

public final class CsmCacheManager {
    private static final Callable<CsmCacheMap> INIT_AS_MAP = new Callable<CsmCacheMap>(){

        @Override
        public CsmCacheMap call() {
            return new CsmCacheMap(CsmCacheStorage.class.getSimpleName());
        }
    };
    static final Logger LOGGER = Logger.getLogger(CsmCacheManager.class.getSimpleName());
    private static final ThreadLocal<CsmCacheStorage> storagesPool = new ThreadLocal<CsmCacheStorage>(){

        @Override
        protected CsmCacheStorage initialValue() {
            return new CsmCacheStorage();
        }
    };

    public static void enter() {
        storagesPool.get().enterImpl();
    }

    public static void leave() {
        storagesPool.get().leaveImpl();
    }

    public static boolean isActive() {
        return storagesPool.get().isActive();
    }

    public static Object get(@NonNull Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        CsmCacheMap map = CsmCacheManager.getSharedCache();
        if (map == null) {
            return null;
        }
        CsmCacheMap.Value value = map.get(key);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "getValue {1}->{2}\n", new Object[]{key, value});
        }
        return value != null ? value.getResult() : null;
    }

    public static Object put(@NonNull Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        CsmCacheMap map = CsmCacheManager.getSharedCache();
        if (map == null) {
            return null;
        }
        CsmCacheMap.Value prev = map.put(key, CsmCacheMap.toValue(value, Integer.MAX_VALUE));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "putValue {1}->{2} (replaced {3})\n", new Object[]{key, value, prev});
        }
        return prev != null ? prev.getResult() : null;
    }

    public static CsmCacheMap getSharedCache() {
        return (CsmCacheMap)storagesPool.get().getEntry(CsmCacheStorage.class, INIT_AS_MAP);
    }

    public static <T extends CsmClientCache> T getClientCache(@NonNull Object entryKey, Callable<T> init) {
        CsmClientCache entry = storagesPool.get().getEntry(entryKey, init);
        return (T)entry;
    }

    private CsmCacheManager() {
    }

    private static final class CsmCacheStorage {
        private final Map<Object, CsmClientCache> cacheEntries = new HashMap<Object, CsmClientCache>();
        private int activeReferences = 0;
        private long initTime;
        private Exception initStack;
        private Exception releasedStack;

        CsmCacheStorage() {
        }

        void enterImpl() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "CsmCacheStorage: Enter {0}:[{1}]{2}\n", new Object[]{this.activeReferences, Thread.currentThread().getId(), Thread.currentThread().getName()});
            }
            if (this.activeReferences == 0) {
                this.initTime = System.currentTimeMillis();
                if (CndUtils.isDebugMode() || CndUtils.isUnitTestMode()) {
                    this.initStack = new Exception("Created for " + Thread.currentThread().getName());
                }
            }
            ++this.activeReferences;
        }

        void leaveImpl() {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "CsmCacheStorage: Leave {0}:[{1}]{3}\n", new Object[]{this.activeReferences, Thread.currentThread().getId(), Thread.currentThread().getName()});
            }
            if (this.activeReferences == 0) {
                this.traceError();
                return;
            }
            if (--this.activeReferences == 0) {
                this.initTime = System.currentTimeMillis() - this.initTime;
                if (CndUtils.isDebugMode() || CndUtils.isUnitTestMode()) {
                    this.releasedStack = new Exception("Released for " + Thread.currentThread().getName());
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "CsmCacheStorage: Used {0}ms; Dispose {1}:[{2}]{3}\n", new Object[]{this.initTime, this.cacheEntries.size(), Thread.currentThread().getId(), Thread.currentThread().getName()});
                }
                for (CsmClientCache entry : this.cacheEntries.values()) {
                    entry.cleanup();
                }
                this.cacheEntries.clear();
            }
        }

        boolean isActive() {
            if (!CndTraceFlags.USE_CSM_CACHE) {
                return false;
            }
            return this.activeReferences > 0;
        }

        CsmClientCache getEntry(@NonNull Object entryKey, Callable<? extends CsmClientCache> init) {
            if (!CndTraceFlags.USE_CSM_CACHE) {
                return null;
            }
            if (this.activeReferences == 0) {
                CndUtils.printStackTraceOnce((Throwable)new Exception("no any active cache transaction:" + entryKey));
                return null;
            }
            CsmClientCache out = this.cacheEntries.get(entryKey);
            if (out == null && init != null) {
                try {
                    out = init.call();
                    this.cacheEntries.put(entryKey, out);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return out;
        }

        private void traceError() {
            if (this.releasedStack != null) {
                LOGGER.log(Level.INFO, "Unexpected Release:\n{0}\n", new Exception());
                LOGGER.log(Level.INFO, "Already Released:\n{0}\n", this.releasedStack);
                LOGGER.log(Level.INFO, "Was created at:\n{0}\n", this.initStack);
            } else {
                LOGGER.log(Level.WARNING, "Unexpected Release:\n{0}\n", new Exception());
            }
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("activeReferences=").append(this.activeReferences).append("\n");
            for (Map.Entry<Object, CsmClientCache> entry : this.cacheEntries.entrySet()) {
                out.append(entry.getKey()).append("=>\n{").append(entry.getValue()).append("}\n");
            }
            return out.toString();
        }
    }

    public static interface CsmClientCache {
        public void cleanup();
    }
}

