/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.xref;

import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.spi.model.services.CsmInlcudeHierachyViewProvider;
import org.netbeans.modules.cnd.utils.UIGesturesSupport;
import org.openide.util.Lookup;

public abstract class CsmIncludeHierarchyResolver {
    private static final CsmIncludeHierarchyResolver EMPTY = new Empty();
    private static final CsmInlcudeHierachyViewProvider V_EMPTY = new VEmpty();
    private static CsmIncludeHierarchyResolver defaultResolver;

    protected CsmIncludeHierarchyResolver() {
    }

    public static CsmIncludeHierarchyResolver getDefault() {
        if (defaultResolver != null) {
            return defaultResolver;
        }
        defaultResolver = (CsmIncludeHierarchyResolver)Lookup.getDefault().lookup(CsmIncludeHierarchyResolver.class);
        return defaultResolver == null ? EMPTY : defaultResolver;
    }

    public static void showIncludeHierachyView(CsmFile file) {
        UIGesturesSupport.submit((String)"USG_CND_SHOW_INCLUDE_HIERARCHY", (Object[])new Object[0]);
        CsmIncludeHierarchyResolver.getInlcudeHierachyViewProvider().showIncludeHierachyView(file);
    }

    private static CsmInlcudeHierachyViewProvider getInlcudeHierachyViewProvider() {
        CsmInlcudeHierachyViewProvider instance = (CsmInlcudeHierachyViewProvider)Lookup.getDefault().lookup(CsmInlcudeHierachyViewProvider.class);
        return instance == null ? V_EMPTY : instance;
    }

    public abstract Collection<CsmFile> getFiles(CsmFile var1);

    public abstract Collection<CsmReference> getIncludes(CsmFile var1);

    private static final class VEmpty
    implements CsmInlcudeHierachyViewProvider {
        VEmpty() {
        }

        @Override
        public void showIncludeHierachyView(CsmFile file) {
        }
    }

    private static final class Empty
    extends CsmIncludeHierarchyResolver {
        Empty() {
        }

        @Override
        public Collection<CsmFile> getFiles(CsmFile referencedFile) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmReference> getIncludes(CsmFile referencedFile) {
            return Collections.emptyList();
        }
    }
}

