/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppStringTokenId;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

public class CppBracesMatcher
implements BracesMatcher,
BracesMatcherFactory {
    private static final char[] PAIRS = new char[]{'(', ')', '[', ']', '{', '}'};
    private static final CppTokenId[] PAIR_TOKEN_IDS = new CppTokenId[]{CppTokenId.LPAREN, CppTokenId.RPAREN, CppTokenId.LBRACKET, CppTokenId.RBRACKET, CppTokenId.LBRACE, CppTokenId.RBRACE};
    private static final Set<TokenId> SPECIAL_TOKENS = new HashSet<TokenId>(Arrays.asList(CppTokenId.STRING_LITERAL, CppTokenId.RAW_STRING_LITERAL, CppTokenId.BLOCK_COMMENT, CppTokenId.LINE_COMMENT, CppTokenId.DOXYGEN_LINE_COMMENT, CppTokenId.DOXYGEN_COMMENT, CppStringTokenId.TEXT));
    private final MatcherContext context;
    private int originOffset;
    private char originChar;
    private char matchingChar;
    private boolean backward;
    private List<TokenSequence<?>> sequences;

    public CppBracesMatcher() {
        this(null);
    }

    private CppBracesMatcher(MatcherContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws BadLocationException, InterruptedException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int[] origin = BracesMatcherSupport.findChar((Document)this.context.getDocument(), (int)this.context.getSearchOffset(), (int)this.context.getLimitOffset(), (char[])PAIRS);
            if (origin != null) {
                TokenSequence<?> seq;
                this.originOffset = origin[0];
                this.originChar = PAIRS[origin[1]];
                this.matchingChar = PAIRS[origin[1] + origin[2]];
                this.backward = origin[2] < 0;
                TokenHierarchy th = TokenHierarchy.get((Document)this.context.getDocument());
                this.sequences = th.embeddedTokenSequences(this.originOffset, this.backward);
                if (!this.sequences.isEmpty() && (seq = this.getTokenSequence()) == null) {
                    int[] nArray = null;
                    return nArray;
                }
                int[] nArray = new int[]{this.originOffset, this.originOffset + 1};
                return nArray;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TokenSequence<?> getTokenSequence() {
        if (this.sequences.isEmpty()) {
            return null;
        }
        TokenSequence<?> seq = this.sequences.get(this.sequences.size() - 1);
        seq.move(this.originOffset);
        if (seq.moveNext()) return seq;
        if (this.sequences.size() <= 1) return null;
        seq = this.sequences.get(this.sequences.size() - 2);
        seq.move(this.originOffset);
        if (!seq.moveNext()) return seq;
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            TokenSequence<?> seq = this.getTokenSequence();
            if (seq == null) {
                int[] nArray = null;
                return nArray;
            }
            seq.move(this.originOffset);
            if (seq.moveNext() && SPECIAL_TOKENS.contains(seq.token().id())) {
                int offset = BracesMatcherSupport.matchChar((Document)this.context.getDocument(), (int)(this.backward ? this.originOffset : this.originOffset + 1), (int)(this.backward ? seq.offset() : seq.offset() + seq.token().length()), (char)this.originChar, (char)this.matchingChar);
                if (offset != -1) {
                    int[] nArray = new int[]{offset, offset + 1};
                    return nArray;
                }
                int[] nArray = null;
                return nArray;
            }
            CppTokenId originId = this.getTokenId(this.originChar);
            CppTokenId lookingForId = this.getTokenId(this.matchingChar);
            seq.move(this.originOffset);
            LinkedList<StackEntry> stack = new LinkedList<StackEntry>();
            stack.push(new StackEntry(0));
            if (this.backward) {
                while (seq.movePrevious()) {
                    this.processPreprocessor(seq, stack);
                    if (originId == seq.token().id()) {
                        ++stack.peek().dep;
                        continue;
                    }
                    if (lookingForId != seq.token().id()) continue;
                    if (stack.peek().dep == 0) {
                        int[] nArray = new int[]{seq.offset(), seq.offset() + seq.token().length()};
                        return nArray;
                    }
                    --stack.peek().dep;
                }
            } else {
                seq.moveNext();
                while (seq.moveNext()) {
                    this.processPreprocessor(seq, stack);
                    if (originId == seq.token().id()) {
                        ++stack.peek().dep;
                        continue;
                    }
                    if (lookingForId != seq.token().id()) continue;
                    if (stack.peek().dep == 0) {
                        int[] nArray = new int[]{seq.offset(), seq.offset() + seq.token().length()};
                        return nArray;
                    }
                    --stack.peek().dep;
                }
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private void processPreprocessor(TokenSequence<?> ts, LinkedList<StackEntry> stack) {
        TokenSequence prep = ts.embedded(CppTokenId.languagePreproc());
        if (prep == null) {
            return;
        }
        prep.moveStart();
        while (prep.moveNext() && (prep.token().id() == CppTokenId.WHITESPACE || prep.token().id() == CppTokenId.PREPROCESSOR_START || prep.token().id() == CppTokenId.PREPROCESSOR_START_ALT)) {
        }
        Token directive = null;
        if (prep.token() != null) {
            directive = prep.token();
        }
        if (directive == null) {
            return;
        }
        if (this.backward) {
            switch ((CppTokenId)directive.id()) {
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    if (stack.size() <= 1) break;
                    int current = stack.peek().dep;
                    if (stack.peek().matched) {
                        stack.poll();
                        stack.peek().dep = current;
                        break;
                    }
                    stack.poll();
                    break;
                }
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    boolean matched = false;
                    if (stack.size() > 1) {
                        stack.poll();
                        matched = true;
                    }
                    int current = stack.peek().dep;
                    stack.push(new StackEntry(current));
                    stack.peek().matched = matched;
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    int current = stack.peek().dep;
                    stack.push(new StackEntry(current));
                }
            }
        } else {
            switch ((CppTokenId)directive.id()) {
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: {
                    int current = stack.peek().dep;
                    stack.push(new StackEntry(current));
                    break;
                }
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: {
                    boolean matched = false;
                    if (stack.size() > 1) {
                        if (stack.peek().matched) {
                            stack.poll();
                            matched = true;
                        } else {
                            stack.poll();
                        }
                    }
                    int current = stack.peek().dep;
                    stack.push(new StackEntry(current));
                    stack.peek().matched = matched;
                    break;
                }
                case PREPROCESSOR_ENDIF: {
                    if (stack.size() <= 1) break;
                    int current = stack.peek().dep;
                    if (stack.peek().matched) {
                        stack.poll();
                        stack.peek().dep = current;
                        break;
                    }
                    stack.poll();
                }
            }
        }
    }

    private CppTokenId getTokenId(char ch) {
        for (int i = 0; i < PAIRS.length; ++i) {
            if (PAIRS[i] != ch) continue;
            return PAIR_TOKEN_IDS[i];
        }
        return null;
    }

    public BracesMatcher createMatcher(MatcherContext context) {
        return new CppBracesMatcher(context);
    }

    private static final class StackEntry {
        int dep;
        boolean matched = true;

        private StackEntry(int dep) {
            this.dep = dep;
        }
    }
}

