/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppStringTokenId;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.editor.BaseDocument;
import org.netbeans.spi.editor.typinghooks.DeletedTextInterceptor;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;
import org.openide.util.CharSequences;

public class CppTypingCompletion {
    private static final String EMPTY_RAW_STRING = "\"()\"";
    private static final String EMPTY_RAW_STRING_WITHOUT_CHARACTER = "\")\"";

    private CppTypingCompletion() {
    }

    static ExtraText checkRawStringRemove(DeletedTextInterceptor.Context context) throws BadLocationException {
        Token token;
        int dotPos;
        BaseDocument doc = (BaseDocument)context.getDocument();
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)(dotPos = context.getOffset()), (boolean)true, (boolean)false);
        if (ts == null) {
            return null;
        }
        if (ts.move(dotPos) != 0 && ts.moveNext() && (token = ts.token()).id() == CppTokenId.RAW_STRING_LITERAL) {
            TokenSequence es = ts.embedded();
            RawStringContext rsContext = CppTypingCompletion.calculateRawStringContext((TokenSequence<CppStringTokenId>)es, dotPos);
            if (rsContext.emptyString) {
                return new ExtraText(rsContext.firstQuoteOffset, rsContext.firstQuoteOffset, EMPTY_RAW_STRING_WITHOUT_CHARACTER);
            }
            if (rsContext.contextTokenId != null && !rsContext.emptyDelimeter) {
                CppStringTokenId id = rsContext.contextTokenId;
                if (context.isBackwardDelete()) {
                    if (id == CppStringTokenId.START_DELIMETER || id == CppStringTokenId.START_DELIMETER_PAREN) {
                        return new ExtraText(dotPos, rsContext.matchingDelimeterSymbolOffset - 2, context.getText());
                    }
                    if (id == CppStringTokenId.LAST_QUOTE || id == CppStringTokenId.END_DELIMETER) {
                        return new ExtraText(dotPos, rsContext.matchingDelimeterSymbolOffset - 1, context.getText());
                    }
                } else {
                    if (id == CppStringTokenId.START_DELIMETER) {
                        return new ExtraText(dotPos, rsContext.matchingDelimeterSymbolOffset - 1, context.getText());
                    }
                    if (id == CppStringTokenId.END_DELIMETER) {
                        return new ExtraText(dotPos, rsContext.matchingDelimeterSymbolOffset, context.getText());
                    }
                }
            }
        }
        return null;
    }

    static ExtraText checkRawStringInsertion(TypedTextInterceptor.MutableContext context) {
        TokenSequence es;
        RawStringContext rsContext;
        Token token;
        int dotPos;
        String text = context.getText();
        if (text.length() != 1) {
            return null;
        }
        BaseDocument doc = (BaseDocument)context.getDocument();
        TokenSequence ts = CndLexerUtilities.getCppTokenSequence((Document)doc, (int)(dotPos = context.getOffset()), (boolean)true, (boolean)false);
        if (ts == null) {
            return null;
        }
        ExtraText rawStringTypingInfo = null;
        char typedChar = text.charAt(0);
        int offsetInToken = ts.move(dotPos);
        if (typedChar == '\"' && offsetInToken == 0 && ts.movePrevious()) {
            Token tokenAtDot = ts.token();
            if (tokenAtDot != null && (CppTokenId.IDENTIFIER == tokenAtDot.id() || CppTokenId.PREPROCESSOR_IDENTIFIER == tokenAtDot.id())) {
                CharSequence tokText = tokenAtDot.text();
                if (CppStringTokenId.PREFIX_R.fixedText().contentEquals(tokText) || CppStringTokenId.PREFIX_LR.fixedText().contentEquals(tokText) || CppStringTokenId.PREFIX_UR.fixedText().contentEquals(tokText) || CppStringTokenId.PREFIX_u8R.fixedText().contentEquals(tokText)) {
                    context.setText(EMPTY_RAW_STRING, 1);
                    rawStringTypingInfo = new ExtraText(dotPos + 1);
                }
            }
            if (rawStringTypingInfo == null) {
                ts.move(dotPos);
            }
        }
        if (rawStringTypingInfo == null && ts.moveNext() && (token = ts.token()).id() == CppTokenId.RAW_STRING_LITERAL && (rsContext = CppTypingCompletion.calculateRawStringContext((TokenSequence<CppStringTokenId>)(es = ts.embedded()), dotPos)).contextTokenId != null) {
            CppStringTokenId id = rsContext.contextTokenId;
            if (typedChar == '(' && id == CppStringTokenId.START_DELIMETER_PAREN) {
                context.setText("", 0);
                return new ExtraText(dotPos + 1);
            }
            if (typedChar == '\"' && id == CppStringTokenId.LAST_QUOTE) {
                context.setText("", 0);
                return new ExtraText(dotPos + 1);
            }
            if (typedChar == ')' && id == CppStringTokenId.END_DELIMETER_PAREN && rsContext.emptyDelimeter) {
                context.setText("", 0);
                return new ExtraText(dotPos + 1);
            }
            if (rsContext.matchingDelimeterSymbolOffset != -1) {
                context.setText("", 0);
                return new ExtraText(dotPos, rsContext.matchingDelimeterSymbolOffset, "" + typedChar);
            }
        }
        return rawStringTypingInfo;
    }

    private static RawStringContext calculateRawStringContext(TokenSequence<CppStringTokenId> es, int dotPos) {
        Object out = null;
        Token firstQuote = null;
        int firstQuoteOffset = -1;
        Token startDelim = null;
        int startDelimOffset = -1;
        Token startDelimParen = null;
        int startDelimParenOffset = -1;
        Token endDelimParen = null;
        int endDelimParenOffset = -1;
        Token endDelim = null;
        int endDelimOffset = -1;
        Token lastQuote = null;
        int lastQuoteOffset = -1;
        Token contextToken = null;
        int matchingOffset = -1;
        int matchingDelimSymbolOffset = -1;
        es.moveStart();
        block11: while (es.moveNext()) {
            Token cur = es.token();
            int curOffset = es.offset();
            switch ((CppStringTokenId)cur.id()) {
                case FIRST_QUOTE: {
                    assert (firstQuote == null);
                    firstQuote = cur;
                    firstQuoteOffset = curOffset;
                    if (curOffset != dotPos) continue block11;
                    contextToken = cur;
                    continue block11;
                }
                case START_DELIMETER: {
                    assert (startDelim == null);
                    startDelim = cur;
                    startDelimOffset = curOffset;
                    if (curOffset > dotPos || dotPos >= curOffset + cur.length()) continue block11;
                    contextToken = cur;
                    continue block11;
                }
                case START_DELIMETER_PAREN: {
                    assert (startDelimParen == null);
                    startDelimParen = cur;
                    startDelimParenOffset = curOffset;
                    if (curOffset != dotPos) continue block11;
                    contextToken = cur;
                    continue block11;
                }
                case PREFIX_L: 
                case PREFIX_R: 
                case PREFIX_U: 
                case PREFIX_u: 
                case PREFIX_u8: 
                case PREFIX_LR: 
                case PREFIX_UR: 
                case PREFIX_uR: 
                case PREFIX_u8R: {
                    continue block11;
                }
            }
            break;
        }
        CppStringTokenId contextTokenId = contextToken == null ? null : (CppStringTokenId)contextToken.id();
        es.moveEnd();
        block12: while (es.movePrevious()) {
            Token cur = es.token();
            int curOffset = es.offset();
            switch ((CppStringTokenId)cur.id()) {
                case LAST_QUOTE: {
                    assert (lastQuote == null);
                    lastQuote = cur;
                    lastQuoteOffset = curOffset;
                    if (curOffset == dotPos) {
                        contextToken = cur;
                        if (startDelimParenOffset == -1) continue block12;
                        matchingDelimSymbolOffset = matchingOffset = startDelimParenOffset;
                        continue block12;
                    }
                    if (contextTokenId != CppStringTokenId.START_DELIMETER_PAREN) continue block12;
                    matchingDelimSymbolOffset = matchingOffset = curOffset;
                    continue block12;
                }
                case END_DELIMETER: {
                    assert (endDelim == null);
                    endDelim = cur;
                    endDelimOffset = curOffset;
                    if (curOffset <= dotPos && dotPos < curOffset + cur.length()) {
                        contextToken = cur;
                        if (startDelimOffset == -1) continue block12;
                        assert (startDelimOffset != -1);
                        assert (matchingOffset == -1);
                        matchingDelimSymbolOffset = matchingOffset = startDelimOffset + (dotPos - curOffset);
                        continue block12;
                    }
                    if (contextTokenId != CppStringTokenId.START_DELIMETER) continue block12;
                    assert (startDelimOffset != -1);
                    assert (matchingOffset == -1);
                    assert (dotPos >= startDelimOffset);
                    matchingDelimSymbolOffset = matchingOffset = curOffset + (dotPos - startDelimOffset);
                    continue block12;
                }
                case END_DELIMETER_PAREN: {
                    assert (endDelimParen == null);
                    endDelimParen = cur;
                    endDelimParenOffset = curOffset;
                    if (curOffset != dotPos) continue block12;
                    contextToken = cur;
                    if (startDelimParenOffset == -1) continue block12;
                    matchingOffset = startDelimParenOffset + 1;
                    continue block12;
                }
            }
            break;
        }
        if (startDelim == null && endDelim == null || startDelim != null && endDelim != null && CharSequences.comparator().compare(startDelim.text(), endDelim.text()) == 0) {
            return new RawStringContext((Token<CppStringTokenId>)contextToken, firstQuoteOffset, firstQuoteOffset + EMPTY_RAW_STRING.length() - 1 == lastQuoteOffset, matchingOffset, matchingDelimSymbolOffset, startDelim == null, endDelim == null);
        }
        return new RawStringContext((Token<CppStringTokenId>)contextToken, firstQuoteOffset, false, matchingOffset, -1, startDelim == null, endDelim == null);
    }

    private static final class RawStringContext {
        private final int firstQuoteOffset;
        private final int matchingOffset;
        private final int matchingDelimeterSymbolOffset;
        private final Token<CppStringTokenId> contextToken;
        private final CppStringTokenId contextTokenId;
        private final boolean emptyStartDelimeter;
        private final boolean emptyEndDelimeter;
        private final boolean emptyDelimeter;
        private final boolean emptyString;

        public RawStringContext(Token<CppStringTokenId> contextToken, int firstQuoteOffset, boolean emptyString, int matchingOffset, int matchingDelimeterSymbolOffset, boolean emptyStartDelimeter, boolean emptyEndDelimeter) {
            this.firstQuoteOffset = firstQuoteOffset;
            this.emptyString = emptyString;
            this.matchingOffset = matchingOffset;
            this.matchingDelimeterSymbolOffset = matchingDelimeterSymbolOffset;
            this.contextToken = contextToken;
            this.contextTokenId = contextToken == null ? null : (CppStringTokenId)contextToken.id();
            this.emptyStartDelimeter = emptyStartDelimeter;
            this.emptyEndDelimeter = emptyEndDelimeter;
            this.emptyDelimeter = emptyStartDelimeter && emptyEndDelimeter;
        }

        public String toString() {
            return "RawStringContext{matchingOffset=" + this.matchingOffset + ", matchingDelimeterSymbolOffset=" + this.matchingDelimeterSymbolOffset + ", contextToken=" + this.contextToken + ", contextTokenId=" + this.contextTokenId + ", emptyStartDelimeter=" + this.emptyStartDelimeter + ", emptyEndDelimeter=" + this.emptyEndDelimeter + ", emptyDelimeter=" + this.emptyDelimeter + '}';
        }
    }

    static final class ExtraText {
        private final int caretPosition;
        private final int textPosition;
        private final String extraText;

        public ExtraText(int caretPosition) {
            this.caretPosition = caretPosition;
            this.textPosition = -1;
            this.extraText = null;
        }

        public ExtraText(int caretPosition, int textPosition, String text) {
            this.caretPosition = caretPosition;
            this.textPosition = textPosition;
            this.extraText = text;
        }

        public int getCaretPosition() {
            return this.caretPosition;
        }

        public String getExtraText() {
            return this.extraText;
        }

        public int getExtraTextPostion() {
            return this.textPosition;
        }
    }
}

